/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.Clazz;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMember;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.EnclosingMethodAttribute;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.AnnotationDefaultAttribute;
import proguard.classfile.attribute.annotation.AnnotationElementValue;
import proguard.classfile.attribute.annotation.AnnotationsAttribute;
import proguard.classfile.attribute.annotation.ArrayElementValue;
import proguard.classfile.attribute.annotation.ClassElementValue;
import proguard.classfile.attribute.annotation.ConstantElementValue;
import proguard.classfile.attribute.annotation.ElementValue;
import proguard.classfile.attribute.annotation.EnumConstantElementValue;
import proguard.classfile.attribute.annotation.ParameterAnnotationsAttribute;
import proguard.classfile.attribute.annotation.visitor.AnnotationVisitor;
import proguard.classfile.attribute.annotation.visitor.ElementValueVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.FieldrefConstant;
import proguard.classfile.constant.InterfaceMethodrefConstant;
import proguard.classfile.constant.MethodrefConstant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.editor.StackSizeUpdater;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;

public class MemberReferenceFixer
extends SimplifiedVisitor
implements ClassVisitor,
ConstantVisitor,
MemberVisitor,
AttributeVisitor,
AnnotationVisitor,
ElementValueVisitor {
    private static final boolean DEBUG = false;
    private final ConstantPoolEditor constantPoolEditor = new ConstantPoolEditor();
    private final StackSizeUpdater stackSizeUpdater = new StackSizeUpdater();
    private int constantIndex;
    private boolean isInterfaceMethod;
    private boolean stackSizesMayHaveChanged;

    public void visitProgramClass(ProgramClass programClass) {
        this.stackSizesMayHaveChanged = false;
        for (int index = 1; index < programClass.u2constantPoolCount; ++index) {
            Constant constant = programClass.constantPool[index];
            if (constant == null) continue;
            this.constantIndex = index;
            constant.accept(programClass, this);
        }
        programClass.fieldsAccept(this);
        programClass.methodsAccept(this);
        programClass.attributesAccept(this);
    }

    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        Member referencedMember = stringConstant.referencedMember;
        if (referencedMember != null) {
            Clazz referencedClass = stringConstant.referencedClass;
            String newName = referencedMember.getName(referencedClass);
            if (!stringConstant.getString(clazz).equals(newName)) {
                stringConstant.u2stringIndex = this.constantPoolEditor.addUtf8Constant((ProgramClass)clazz, newName);
            }
        }
    }

    public void visitFieldrefConstant(Clazz clazz, FieldrefConstant fieldrefConstant) {
        Member referencedMember = fieldrefConstant.referencedMember;
        if (referencedMember != null) {
            Clazz referencedClass = fieldrefConstant.referencedClass;
            String newName = referencedMember.getName(referencedClass);
            String newType = referencedMember.getDescriptor(referencedClass);
            if (!fieldrefConstant.getName(clazz).equals(newName) || !fieldrefConstant.getType(clazz).equals(newType)) {
                fieldrefConstant.u2nameAndTypeIndex = this.constantPoolEditor.addNameAndTypeConstant((ProgramClass)clazz, newName, newType);
            }
        }
    }

    public void visitInterfaceMethodrefConstant(Clazz clazz, InterfaceMethodrefConstant interfaceMethodrefConstant) {
        Member referencedMember = interfaceMethodrefConstant.referencedMember;
        if (referencedMember != null) {
            Clazz referencedClass = interfaceMethodrefConstant.referencedClass;
            String newName = referencedMember.getName(referencedClass);
            String newType = referencedMember.getDescriptor(referencedClass);
            if (!interfaceMethodrefConstant.getName(clazz).equals(newName) || !interfaceMethodrefConstant.getType(clazz).equals(newType)) {
                interfaceMethodrefConstant.u2nameAndTypeIndex = this.constantPoolEditor.addNameAndTypeConstant((ProgramClass)clazz, newName, newType);
                this.stackSizesMayHaveChanged = true;
            }
            this.isInterfaceMethod = true;
            clazz.constantPoolEntryAccept(interfaceMethodrefConstant.u2classIndex, this);
            if (!this.isInterfaceMethod) {
                ((ProgramClass)clazz).constantPool[this.constantIndex] = new MethodrefConstant(interfaceMethodrefConstant.u2classIndex, interfaceMethodrefConstant.u2nameAndTypeIndex, referencedClass, referencedMember);
            }
        }
    }

    public void visitMethodrefConstant(Clazz clazz, MethodrefConstant methodrefConstant) {
        Member referencedMember = methodrefConstant.referencedMember;
        if (referencedMember != null) {
            Clazz referencedClass = methodrefConstant.referencedClass;
            String newName = referencedMember.getName(referencedClass);
            String newType = referencedMember.getDescriptor(referencedClass);
            if (!methodrefConstant.getName(clazz).equals(newName) || !methodrefConstant.getType(clazz).equals(newType)) {
                methodrefConstant.u2nameAndTypeIndex = this.constantPoolEditor.addNameAndTypeConstant((ProgramClass)clazz, newName, newType);
                this.stackSizesMayHaveChanged = true;
            }
            this.isInterfaceMethod = false;
            clazz.constantPoolEntryAccept(methodrefConstant.u2classIndex, this);
            if (this.isInterfaceMethod) {
                ((ProgramClass)clazz).constantPool[this.constantIndex] = new InterfaceMethodrefConstant(methodrefConstant.u2classIndex, methodrefConstant.u2nameAndTypeIndex, referencedClass, referencedMember);
            }
        }
    }

    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        if (ClassUtil.isInternalArrayType(classConstant.getName(clazz))) {
            this.isInterfaceMethod = false;
        } else {
            Clazz referencedClass = classConstant.referencedClass;
            if (referencedClass != null) {
                this.isInterfaceMethod = (referencedClass.getAccessFlags() & 0x200) != 0;
            }
        }
    }

    public void visitProgramMember(ProgramClass programClass, ProgramMember programMember) {
        programMember.attributesAccept(programClass, this);
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitEnclosingMethodAttribute(Clazz clazz, EnclosingMethodAttribute enclosingMethodAttribute) {
        Method referencedMember = enclosingMethodAttribute.referencedMethod;
        if (referencedMember != null) {
            Clazz referencedClass = enclosingMethodAttribute.referencedClass;
            if (!enclosingMethodAttribute.getClassName(clazz).equals(referencedClass.getName())) {
                enclosingMethodAttribute.u2classIndex = this.constantPoolEditor.addClassConstant((ProgramClass)clazz, referencedClass);
            }
            if (!enclosingMethodAttribute.getName(clazz).equals(referencedMember.getName(referencedClass)) || !enclosingMethodAttribute.getType(clazz).equals(referencedMember.getDescriptor(referencedClass))) {
                enclosingMethodAttribute.u2nameAndTypeIndex = this.constantPoolEditor.addNameAndTypeConstant((ProgramClass)clazz, referencedMember.getName(referencedClass), referencedMember.getDescriptor(referencedClass));
            }
        }
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        if (this.stackSizesMayHaveChanged) {
            this.stackSizeUpdater.visitCodeAttribute(clazz, method, codeAttribute);
        }
        codeAttribute.attributesAccept(clazz, method, this);
    }

    public void visitAnyAnnotationsAttribute(Clazz clazz, AnnotationsAttribute annotationsAttribute) {
        annotationsAttribute.annotationsAccept(clazz, this);
    }

    public void visitAnyParameterAnnotationsAttribute(Clazz clazz, Method method, ParameterAnnotationsAttribute parameterAnnotationsAttribute) {
        parameterAnnotationsAttribute.annotationsAccept(clazz, method, this);
    }

    public void visitAnnotationDefaultAttribute(Clazz clazz, Method method, AnnotationDefaultAttribute annotationDefaultAttribute) {
        annotationDefaultAttribute.defaultValueAccept(clazz, this);
    }

    public void visitAnnotation(Clazz clazz, Annotation annotation) {
        annotation.elementValuesAccept(clazz, this);
    }

    public void visitConstantElementValue(Clazz clazz, Annotation annotation, ConstantElementValue constantElementValue) {
        this.fixElementValue(clazz, annotation, constantElementValue);
    }

    public void visitEnumConstantElementValue(Clazz clazz, Annotation annotation, EnumConstantElementValue enumConstantElementValue) {
        this.fixElementValue(clazz, annotation, enumConstantElementValue);
    }

    public void visitClassElementValue(Clazz clazz, Annotation annotation, ClassElementValue classElementValue) {
        this.fixElementValue(clazz, annotation, classElementValue);
    }

    public void visitAnnotationElementValue(Clazz clazz, Annotation annotation, AnnotationElementValue annotationElementValue) {
        this.fixElementValue(clazz, annotation, annotationElementValue);
        annotationElementValue.annotationAccept(clazz, this);
    }

    public void visitArrayElementValue(Clazz clazz, Annotation annotation, ArrayElementValue arrayElementValue) {
        this.fixElementValue(clazz, annotation, arrayElementValue);
        arrayElementValue.elementValuesAccept(clazz, annotation, this);
    }

    private void fixElementValue(Clazz clazz, Annotation annotation, ElementValue elementValue) {
        String newMethodName;
        String methodName;
        Method referencedMember = elementValue.referencedMethod;
        if (referencedMember != null && !(methodName = elementValue.getMethodName(clazz)).equals(newMethodName = referencedMember.getName(elementValue.referencedClass))) {
            elementValue.u2elementNameIndex = this.constantPoolEditor.addUtf8Constant((ProgramClass)clazz, newMethodName);
        }
    }

    private void debug(Clazz clazz, StringConstant stringConstant, Clazz referencedClass, Member referencedMember) {
        System.out.println("MemberReferenceFixer:");
        System.out.println("  Class file      = " + clazz.getName());
        System.out.println("  Ref class       = " + referencedClass.getName());
        System.out.println("  Ref member name = " + stringConstant.getString(clazz));
        System.out.println("                 -> " + referencedMember.getName(referencedClass));
    }

    private void debug(Clazz clazz, RefConstant refConstant, Clazz referencedClass, Member referencedMember) {
        System.out.println("MemberReferenceFixer:");
        System.out.println("  Class file      = " + clazz.getName());
        System.out.println("  Ref class       = " + referencedClass.getName());
        System.out.println("  Ref member name = " + refConstant.getName(clazz));
        System.out.println("                 -> " + referencedMember.getName(referencedClass));
        System.out.println("  Ref descriptor  = " + refConstant.getType(clazz));
        System.out.println("                 -> " + referencedMember.getDescriptor(referencedClass));
    }
}

