/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.Clazz;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;

public class MethodInvocationFixer
extends SimplifiedVisitor
implements AttributeVisitor,
InstructionVisitor,
ConstantVisitor,
ClassVisitor,
MemberVisitor {
    private static final boolean DEBUG = false;
    private final CodeAttributeEditor codeAttributeEditor = new CodeAttributeEditor();
    private Clazz referencedClass;
    private Clazz referencedMethodClass;
    private Member referencedMethod;

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        this.codeAttributeEditor.reset(codeAttribute.u4codeLength);
        codeAttribute.instructionsAccept(clazz, method, this);
        this.codeAttributeEditor.visitCodeAttribute(clazz, method, codeAttribute);
    }

    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
    }

    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
        int constantIndex = constantInstruction.constantIndex;
        this.referencedMethod = null;
        clazz.constantPoolEntryAccept(constantIndex, this);
        if (this.referencedMethod != null) {
            byte opcode = constantInstruction.opcode;
            if ((this.referencedMethod.getAccessFlags() & 8) != 0) {
                if (opcode != -72) {
                    Instruction replacementInstruction = new ConstantInstruction(-72, constantIndex).shrink();
                    this.codeAttributeEditor.replaceInstruction(offset, replacementInstruction);
                }
            } else if ((this.referencedMethod.getAccessFlags() & 2) != 0 || this.referencedMethod.getName(this.referencedMethodClass).equals("<init>")) {
                if (opcode != -73) {
                    Instruction replacementInstruction = new ConstantInstruction(-73, constantIndex).shrink();
                    this.codeAttributeEditor.replaceInstruction(offset, replacementInstruction);
                }
            } else if ((this.referencedClass.getAccessFlags() & 0x200) != 0) {
                int invokeinterfaceConstant = ClassUtil.internalMethodParameterSize(this.referencedMethod.getDescriptor(this.referencedMethodClass), false) << 8;
                if (opcode != -71 || constantInstruction.constant != invokeinterfaceConstant) {
                    Instruction replacementInstruction = new ConstantInstruction(-71, constantIndex, invokeinterfaceConstant).shrink();
                    this.codeAttributeEditor.replaceInstruction(offset, replacementInstruction);
                }
            } else if (!(opcode == -74 || opcode == -73 && clazz.extends_(this.referencedClass))) {
                Instruction replacementInstruction = new ConstantInstruction(-74, constantIndex).shrink();
                this.codeAttributeEditor.replaceInstruction(offset, replacementInstruction);
            }
        }
    }

    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    public void visitAnyMethodrefConstant(Clazz clazz, RefConstant refConstant) {
        clazz.constantPoolEntryAccept(refConstant.u2classIndex, this);
        refConstant.referencedMemberAccept(this);
    }

    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        classConstant.referencedClassAccept(this);
    }

    public void visitAnyClass(Clazz clazz) {
        this.referencedClass = clazz;
    }

    public void visitAnyMember(Clazz clazz, Member member) {
        this.referencedMethodClass = clazz;
        this.referencedMethod = member;
    }

    private void debug(Clazz clazz, Method method, int offset, ConstantInstruction constantInstruction, Instruction replacementInstruction) {
        System.out.println("MethodInvocationFixer:");
        System.out.println("  Class       = " + clazz.getName());
        System.out.println("  Method      = " + method.getName(clazz) + method.getDescriptor(clazz));
        System.out.println("  Instruction = " + constantInstruction.toString(offset));
        System.out.println("  -> Class    = " + this.referencedClass);
        System.out.println("     Method   = " + this.referencedMethod);
        if ((this.referencedClass.getAccessFlags() & 0x200) != 0) {
            System.out.println("     Parameter size   = " + ClassUtil.internalMethodParameterSize(this.referencedMethod.getDescriptor(this.referencedMethodClass), false));
        }
        System.out.println("  Replacement instruction = " + replacementInstruction.toString(offset));
    }
}

