/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util;

import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.EnclosingMethodAttribute;
import proguard.classfile.attribute.LocalVariableInfo;
import proguard.classfile.attribute.LocalVariableTableAttribute;
import proguard.classfile.attribute.LocalVariableTypeInfo;
import proguard.classfile.attribute.LocalVariableTypeTableAttribute;
import proguard.classfile.attribute.SignatureAttribute;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.AnnotationDefaultAttribute;
import proguard.classfile.attribute.annotation.AnnotationElementValue;
import proguard.classfile.attribute.annotation.AnnotationsAttribute;
import proguard.classfile.attribute.annotation.ArrayElementValue;
import proguard.classfile.attribute.annotation.ClassElementValue;
import proguard.classfile.attribute.annotation.ConstantElementValue;
import proguard.classfile.attribute.annotation.ElementValue;
import proguard.classfile.attribute.annotation.EnumConstantElementValue;
import proguard.classfile.attribute.annotation.ParameterAnnotationsAttribute;
import proguard.classfile.attribute.annotation.visitor.AnnotationVisitor;
import proguard.classfile.attribute.annotation.visitor.ElementValueVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.LocalVariableInfoVisitor;
import proguard.classfile.attribute.visitor.LocalVariableTypeInfoVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.DescriptorClassEnumeration;
import proguard.classfile.util.MemberFinder;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;

public class ClassReferenceInitializer
extends SimplifiedVisitor
implements ClassVisitor,
MemberVisitor,
ConstantVisitor,
AttributeVisitor,
LocalVariableInfoVisitor,
LocalVariableTypeInfoVisitor,
AnnotationVisitor,
ElementValueVisitor {
    private final ClassPool programClassPool;
    private final ClassPool libraryClassPool;
    private final WarningPrinter warningPrinter;
    private final MemberFinder memberFinder = new MemberFinder();

    public ClassReferenceInitializer(ClassPool programClassPool, ClassPool libraryClassPool, WarningPrinter warningPrinter) {
        this.programClassPool = programClassPool;
        this.libraryClassPool = libraryClassPool;
        this.warningPrinter = warningPrinter;
    }

    public void visitProgramClass(ProgramClass programClass) {
        programClass.constantPoolEntriesAccept(this);
        programClass.fieldsAccept(this);
        programClass.methodsAccept(this);
        programClass.attributesAccept(this);
    }

    public void visitLibraryClass(LibraryClass libraryClass) {
        libraryClass.fieldsAccept(this);
        libraryClass.methodsAccept(this);
    }

    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        programField.referencedClass = this.findReferencedClass(programField.getDescriptor(programClass));
        programField.attributesAccept(programClass, this);
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        programMethod.referencedClasses = this.findReferencedClasses(programMethod.getDescriptor(programClass));
        programMethod.attributesAccept(programClass, this);
    }

    public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
        libraryField.referencedClass = this.findReferencedClass(libraryField.getDescriptor(libraryClass));
    }

    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        libraryMethod.referencedClasses = this.findReferencedClasses(libraryMethod.getDescriptor(libraryClass));
    }

    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        stringConstant.javaLangStringClass = this.findClass("java/lang/String");
    }

    public void visitAnyRefConstant(Clazz clazz, RefConstant refConstant) {
        String className = refConstant.getClassName(clazz);
        Clazz referencedClass = this.findClass(className);
        if (referencedClass != null && !ClassUtil.isInternalArrayType(className)) {
            String name = refConstant.getName(clazz);
            String type = refConstant.getType(clazz);
            boolean isFieldRef = refConstant.getTag() == 9;
            refConstant.referencedMember = this.memberFinder.findMember(clazz, referencedClass, name, type, isFieldRef);
            refConstant.referencedClass = this.memberFinder.correspondingClass();
            if (refConstant.referencedMember == null && this.warningPrinter != null) {
                this.warningPrinter.print("Warning: " + ClassUtil.externalClassName(clazz.getName()) + ": can't find referenced " + (isFieldRef ? "field '" + ClassUtil.externalFullFieldDescription(0, name, type) : "method '" + ClassUtil.externalFullMethodDescription(className, 0, name, type)) + "' in class " + ClassUtil.externalClassName(className));
            }
        }
    }

    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        classConstant.referencedClass = this.findClass(classConstant.getName(clazz));
        classConstant.javaLangClassClass = this.findClass("java/lang/Class");
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitEnclosingMethodAttribute(Clazz clazz, EnclosingMethodAttribute enclosingMethodAttribute) {
        String type;
        String className = enclosingMethodAttribute.getClassName(clazz);
        Clazz referencedClass = this.findClass(className);
        if (referencedClass == null) {
            if (this.warningPrinter != null) {
                this.warningPrinter.print("Warning: " + ClassUtil.externalClassName(clazz.getName()) + ": can't find enclosing class " + ClassUtil.externalClassName(className));
            }
            return;
        }
        if (enclosingMethodAttribute.u2nameAndTypeIndex == 0) {
            return;
        }
        String name = enclosingMethodAttribute.getName(clazz);
        Method referencedMethod = referencedClass.findMethod(name, type = enclosingMethodAttribute.getType(clazz));
        if (referencedMethod == null) {
            if (this.warningPrinter != null) {
                this.warningPrinter.print("Warning: " + ClassUtil.externalClassName(clazz.getName()) + ": can't find enclosing method '" + ClassUtil.externalFullMethodDescription(className, 0, name, type) + "' in class " + ClassUtil.externalClassName(className));
            }
            return;
        }
        enclosingMethodAttribute.referencedClass = referencedClass;
        enclosingMethodAttribute.referencedMethod = referencedMethod;
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        codeAttribute.attributesAccept(clazz, method, this);
    }

    public void visitLocalVariableTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTableAttribute localVariableTableAttribute) {
        localVariableTableAttribute.localVariablesAccept(clazz, method, codeAttribute, this);
    }

    public void visitLocalVariableTypeTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeTableAttribute localVariableTypeTableAttribute) {
        localVariableTypeTableAttribute.localVariablesAccept(clazz, method, codeAttribute, this);
    }

    public void visitSignatureAttribute(Clazz clazz, SignatureAttribute signatureAttribute) {
        signatureAttribute.referencedClasses = this.findReferencedClasses(clazz.getString(signatureAttribute.u2signatureIndex));
    }

    public void visitAnyAnnotationsAttribute(Clazz clazz, AnnotationsAttribute annotationsAttribute) {
        annotationsAttribute.annotationsAccept(clazz, this);
    }

    public void visitAnyParameterAnnotationsAttribute(Clazz clazz, Method method, ParameterAnnotationsAttribute parameterAnnotationsAttribute) {
        parameterAnnotationsAttribute.annotationsAccept(clazz, method, this);
    }

    public void visitAnnotationDefaultAttribute(Clazz clazz, Method method, AnnotationDefaultAttribute annotationDefaultAttribute) {
        annotationDefaultAttribute.defaultValueAccept(clazz, this);
    }

    public void visitLocalVariableInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableInfo localVariableInfo) {
        localVariableInfo.referencedClass = this.findReferencedClass(clazz.getString(localVariableInfo.u2descriptorIndex));
    }

    public void visitLocalVariableTypeInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeInfo localVariableTypeInfo) {
        localVariableTypeInfo.referencedClasses = this.findReferencedClasses(clazz.getString(localVariableTypeInfo.u2signatureIndex));
    }

    public void visitAnnotation(Clazz clazz, Annotation annotation) {
        annotation.referencedClasses = this.findReferencedClasses(clazz.getString(annotation.u2typeIndex));
        annotation.elementValuesAccept(clazz, this);
    }

    public void visitConstantElementValue(Clazz clazz, Annotation annotation, ConstantElementValue constantElementValue) {
        this.initializeElementValue(clazz, annotation, constantElementValue);
    }

    public void visitEnumConstantElementValue(Clazz clazz, Annotation annotation, EnumConstantElementValue enumConstantElementValue) {
        this.initializeElementValue(clazz, annotation, enumConstantElementValue);
        enumConstantElementValue.referencedClasses = this.findReferencedClasses(clazz.getString(enumConstantElementValue.u2typeNameIndex));
    }

    public void visitClassElementValue(Clazz clazz, Annotation annotation, ClassElementValue classElementValue) {
        this.initializeElementValue(clazz, annotation, classElementValue);
        classElementValue.referencedClasses = this.findReferencedClasses(clazz.getString(classElementValue.u2classInfoIndex));
    }

    public void visitAnnotationElementValue(Clazz clazz, Annotation annotation, AnnotationElementValue annotationElementValue) {
        this.initializeElementValue(clazz, annotation, annotationElementValue);
        annotationElementValue.annotationAccept(clazz, this);
    }

    public void visitArrayElementValue(Clazz clazz, Annotation annotation, ArrayElementValue arrayElementValue) {
        this.initializeElementValue(clazz, annotation, arrayElementValue);
        arrayElementValue.elementValuesAccept(clazz, annotation, this);
    }

    private void initializeElementValue(Clazz clazz, Annotation annotation, ElementValue elementValue) {
        if (annotation != null && annotation.referencedClasses != null && elementValue.u2elementNameIndex != 0) {
            Clazz referencedClass;
            String name = clazz.getString(elementValue.u2elementNameIndex);
            elementValue.referencedClass = referencedClass = annotation.referencedClasses[0];
            elementValue.referencedMethod = referencedClass.findMethod(name, null);
        }
    }

    private Clazz findReferencedClass(String descriptor) {
        DescriptorClassEnumeration enumeration = new DescriptorClassEnumeration(descriptor);
        enumeration.nextFluff();
        if (enumeration.hasMoreClassNames()) {
            return this.findClass(enumeration.nextClassName());
        }
        return null;
    }

    private Clazz[] findReferencedClasses(String descriptor) {
        DescriptorClassEnumeration enumeration = new DescriptorClassEnumeration(descriptor);
        int classCount = enumeration.classCount();
        if (classCount > 0) {
            Clazz[] referencedClasses = new Clazz[classCount];
            boolean foundReferencedClasses = false;
            for (int index = 0; index < classCount; ++index) {
                String fluff = enumeration.nextFluff();
                String name = enumeration.nextClassName();
                Clazz referencedClass = this.findClass(name);
                if (referencedClass == null) continue;
                referencedClasses[index] = referencedClass;
                foundReferencedClasses = true;
            }
            if (foundReferencedClasses) {
                return referencedClasses;
            }
        }
        return null;
    }

    private Clazz findClass(String name) {
        Clazz clazz = this.programClassPool.getClass(name);
        if (clazz == null) {
            clazz = this.libraryClassPool.getClass(name);
        }
        return clazz;
    }
}

