/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util;

import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.ClassVisitor;

public class ClassSuperHierarchyInitializer
extends SimplifiedVisitor
implements ClassVisitor,
ConstantVisitor {
    private final ClassPool programClassPool;
    private final ClassPool libraryClassPool;
    private final WarningPrinter warningPrinter;

    public ClassSuperHierarchyInitializer(ClassPool programClassPool, ClassPool libraryClassPool, WarningPrinter warningPrinter) {
        this.programClassPool = programClassPool;
        this.libraryClassPool = libraryClassPool;
        this.warningPrinter = warningPrinter;
    }

    public void visitProgramClass(ProgramClass programClass) {
        if (programClass.u2superClass != 0) {
            programClass.constantPoolEntryAccept(programClass.u2superClass, this);
        }
        for (int index = 0; index < programClass.u2interfacesCount; ++index) {
            programClass.constantPoolEntryAccept(programClass.u2interfaces[index], this);
        }
    }

    public void visitLibraryClass(LibraryClass libraryClass) {
        String className = libraryClass.getName();
        String superClassName = libraryClass.superClassName;
        if (superClassName != null) {
            libraryClass.superClass = this.findClass(className, superClassName);
        }
        if (libraryClass.interfaceNames != null) {
            String[] interfaceNames = libraryClass.interfaceNames;
            Clazz[] interfaceClasses = new Clazz[interfaceNames.length];
            for (int index = 0; index < interfaceNames.length; ++index) {
                interfaceClasses[index] = this.findClass(className, interfaceNames[index]);
            }
            libraryClass.interfaceClasses = interfaceClasses;
        }
        libraryClass.superClassName = null;
        libraryClass.interfaceNames = null;
    }

    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        classConstant.referencedClass = this.findClass(clazz.getName(), classConstant.getName(clazz));
    }

    private Clazz findClass(String subClassName, String name) {
        Clazz clazz = this.programClassPool.getClass(name);
        if (clazz == null) {
            clazz = this.libraryClassPool.getClass(name);
        }
        if (clazz == null && this.warningPrinter != null) {
            this.warningPrinter.print("Warning: " + ClassUtil.externalClassName(subClassName) + ": can't find superclass or interface " + ClassUtil.externalClassName(name));
        }
        return clazz;
    }
}

