/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util;

public class InternalTypeEnumeration {
    private String descriptor;
    private int index;

    public InternalTypeEnumeration(String descriptor) {
        this.descriptor = descriptor;
        this.index = descriptor.indexOf(40) + 1;
    }

    public boolean hasMoreTypes() {
        return this.index < this.descriptor.length() && this.descriptor.charAt(this.index) != ')';
    }

    public String nextType() {
        boolean parsingArrayPrefix;
        int startIndex = this.index;
        int nestingLevel = 0;
        boolean parsingRawType = true;
        block11: do {
            parsingArrayPrefix = false;
            char c = this.descriptor.charAt(this.index++);
            if (parsingRawType) {
                switch (c) {
                    case '<': {
                        parsingRawType = false;
                        ++nestingLevel;
                        break;
                    }
                    case '>': {
                        parsingRawType = false;
                        --nestingLevel;
                        break;
                    }
                    case '[': {
                        parsingArrayPrefix = true;
                        break;
                    }
                    case 'L': 
                    case 'T': {
                        parsingRawType = false;
                        nestingLevel += 2;
                    }
                }
                continue;
            }
            switch (c) {
                case ';': {
                    parsingRawType = true;
                    if ((nestingLevel -= 2) != 1 || this.descriptor.charAt(this.index) == '>') continue block11;
                    parsingRawType = false;
                    break;
                }
                case '<': {
                    parsingRawType = true;
                    ++nestingLevel;
                    break;
                }
                case ':': {
                    parsingRawType = true;
                }
            }
        } while (nestingLevel > 0 || parsingArrayPrefix);
        return this.descriptor.substring(startIndex, this.index);
    }

    public String returnType() {
        return this.descriptor.substring(this.descriptor.indexOf(41) + 1);
    }

    public static void main(String[] args) {
        try {
            System.out.println("Descriptor [" + args[0] + "]");
            InternalTypeEnumeration enumeration = new InternalTypeEnumeration(args[0]);
            while (enumeration.hasMoreTypes()) {
                System.out.println("  Type [" + enumeration.nextType() + "]");
            }
            System.out.println("  Return type [" + enumeration.returnType() + "]");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

