/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.constant.FieldrefConstant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.InternalTypeEnumeration;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.evaluation.InvocationUnit;
import proguard.evaluation.Stack;
import proguard.evaluation.Variables;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.Value;
import proguard.evaluation.value.ValueFactory;

public class BasicInvocationUnit
extends SimplifiedVisitor
implements InvocationUnit,
ConstantVisitor,
MemberVisitor {
    private final ValueFactory valueFactory = new ValueFactory();
    private boolean isStatic;
    private boolean isLoad;
    private Stack stack;
    private Clazz returnTypeClass;

    public void enterMethod(Clazz clazz, Method method, Variables variables) {
        String descriptor = method.getDescriptor(clazz);
        boolean isStatic = (method.getAccessFlags() & 8) != 0;
        int parameterSize = ClassUtil.internalMethodParameterSize(descriptor, isStatic);
        variables.reset(parameterSize);
        InternalTypeEnumeration internalTypeEnumeration = new InternalTypeEnumeration(descriptor);
        int parameterIndex = 0;
        int variableIndex = 0;
        if (!isStatic) {
            Value value = this.getMethodParameterValue(clazz, method, parameterIndex++, ClassUtil.internalTypeFromClassName(clazz.getName()), clazz);
            variables.store(variableIndex++, value);
        }
        Clazz[] referencedClasses = ((ProgramMethod)method).referencedClasses;
        int referencedClassIndex = 0;
        while (internalTypeEnumeration.hasMoreTypes()) {
            String type = internalTypeEnumeration.nextType();
            Clazz referencedClass = referencedClasses != null && ClassUtil.isInternalClassType(type) ? referencedClasses[referencedClassIndex++] : null;
            Value value = this.getMethodParameterValue(clazz, method, parameterIndex++, type, referencedClass);
            variables.store(variableIndex++, value);
            if (!value.isCategory2()) continue;
            ++variableIndex;
        }
    }

    public void exitMethod(Clazz clazz, Method method, Value returnValue) {
        this.setMethodReturnValue(clazz, method, returnValue);
    }

    public void invokeMember(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction, Stack stack) {
        int constantIndex = constantInstruction.constantIndex;
        switch (constantInstruction.opcode) {
            case -78: {
                this.isStatic = true;
                this.isLoad = true;
                break;
            }
            case -77: {
                this.isStatic = true;
                this.isLoad = false;
                break;
            }
            case -76: {
                this.isStatic = false;
                this.isLoad = true;
                break;
            }
            case -75: {
                this.isStatic = false;
                this.isLoad = false;
                break;
            }
            case -72: {
                this.isStatic = true;
                break;
            }
            case -74: 
            case -73: 
            case -71: {
                this.isStatic = false;
            }
        }
        this.stack = stack;
        clazz.constantPoolEntryAccept(constantIndex, this);
        this.stack = null;
    }

    public void visitFieldrefConstant(Clazz clazz, FieldrefConstant fieldrefConstant) {
        if (!this.isLoad) {
            this.setFieldValue(clazz, fieldrefConstant, this.stack.pop());
        }
        if (!this.isStatic) {
            this.setFieldClassValue(clazz, fieldrefConstant, this.stack.apop());
        }
        if (this.isLoad) {
            String type = fieldrefConstant.getType(clazz);
            this.stack.push(this.getFieldValue(clazz, fieldrefConstant, type));
        }
    }

    public void visitAnyMethodrefConstant(Clazz clazz, RefConstant methodrefConstant) {
        String type = methodrefConstant.getType(clazz);
        int parameterCount = ClassUtil.internalMethodParameterCount(type);
        if (!this.isStatic) {
            ++parameterCount;
        }
        for (int parameterIndex = parameterCount - 1; parameterIndex >= 0; --parameterIndex) {
            this.setMethodParameterValue(clazz, methodrefConstant, parameterIndex, this.stack.pop());
        }
        String returnType = ClassUtil.internalMethodReturnType(type);
        if (returnType.charAt(0) != 'V') {
            this.stack.push(this.getMethodReturnValue(clazz, methodrefConstant, returnType));
        }
    }

    protected void setFieldClassValue(Clazz clazz, RefConstant refConstant, ReferenceValue value) {
    }

    protected Value getFieldClassValue(Clazz clazz, RefConstant refConstant, String type) {
        this.returnTypeClass = null;
        refConstant.referencedMemberAccept(this);
        return this.valueFactory.createValue(type, this.returnTypeClass, true);
    }

    protected void setFieldValue(Clazz clazz, RefConstant refConstant, Value value) {
    }

    protected Value getFieldValue(Clazz clazz, RefConstant refConstant, String type) {
        this.returnTypeClass = null;
        refConstant.referencedMemberAccept(this);
        return this.valueFactory.createValue(type, this.returnTypeClass, true);
    }

    protected void setMethodParameterValue(Clazz clazz, RefConstant refConstant, int parameterIndex, Value value) {
    }

    protected Value getMethodParameterValue(Clazz clazz, Method method, int parameterIndex, String type, Clazz referencedClass) {
        return this.valueFactory.createValue(type, referencedClass, true);
    }

    protected void setMethodReturnValue(Clazz clazz, Method method, Value value) {
    }

    protected Value getMethodReturnValue(Clazz clazz, RefConstant refConstant, String type) {
        this.returnTypeClass = null;
        refConstant.referencedMemberAccept(this);
        return this.valueFactory.createValue(type, this.returnTypeClass, true);
    }

    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        this.returnTypeClass = programField.referencedClass;
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        Clazz[] referencedClasses = programMethod.referencedClasses;
        if (referencedClasses != null) {
            this.returnTypeClass = referencedClasses[referencedClasses.length - 1];
        }
    }

    public void visitLibraryField(LibraryClass programClass, LibraryField programField) {
        this.returnTypeClass = programField.referencedClass;
    }

    public void visitLibraryMethod(LibraryClass programClass, LibraryMethod programMethod) {
        Clazz[] referencedClasses = programMethod.referencedClasses;
        if (referencedClasses != null) {
            this.returnTypeClass = referencedClasses[referencedClasses.length - 1];
        }
    }
}

