/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation;

import proguard.evaluation.Stack;
import proguard.evaluation.value.Value;

public class TracedStack
extends Stack {
    private Value producerValue;
    private Stack producerStack;

    public TracedStack(int maxSize) {
        super(maxSize);
        this.producerStack = new Stack(maxSize);
    }

    public TracedStack(TracedStack tracedStack) {
        super(tracedStack);
        this.producerStack = new Stack(tracedStack.producerStack);
    }

    public void setProducerValue(Value producerValue) {
        this.producerValue = producerValue;
    }

    public Value getBottomProducerValue(int index) {
        return this.producerStack.getBottom(index);
    }

    public void setBottomProducerValue(int index, Value value) {
        this.producerStack.setBottom(index, value);
    }

    public Value getTopProducerValue(int index) {
        return this.producerStack.getTop(index);
    }

    public void setTopProducerValue(int index, Value value) {
        this.producerStack.setTop(index, value);
    }

    public void reset(int size) {
        super.reset(size);
        this.producerStack.reset(size);
    }

    public void copy(TracedStack other) {
        super.copy(other);
        this.producerStack.copy(other.producerStack);
    }

    public boolean generalize(TracedStack other) {
        return super.generalize(other) | this.producerStack.generalize(other.producerStack);
    }

    public void clear() {
        super.clear();
        this.producerStack.clear();
    }

    public void removeTop(int index) {
        super.removeTop(index);
        this.producerStack.removeTop(index);
    }

    public void push(Value value) {
        super.push(value);
        this.producerPush();
        if (value.isCategory2()) {
            this.producerPush();
        }
    }

    public Value pop() {
        Value value = super.pop();
        this.producerPop();
        if (value.isCategory2()) {
            this.producerPop();
        }
        return value;
    }

    public void pop1() {
        super.pop1();
        this.producerPop();
    }

    public void pop2() {
        super.pop2();
        this.producerPop();
        this.producerPop();
    }

    public void dup() {
        super.dup();
        this.producerPop();
        this.producerPush();
        this.producerPush();
    }

    public void dup_x1() {
        super.dup_x1();
        this.producerPop();
        this.producerPop();
        this.producerPush();
        this.producerPush();
        this.producerPush();
    }

    public void dup_x2() {
        super.dup_x2();
        this.producerPop();
        this.producerPop();
        this.producerPop();
        this.producerPush();
        this.producerPush();
        this.producerPush();
        this.producerPush();
    }

    public void dup2() {
        super.dup2();
        this.producerPop();
        this.producerPop();
        this.producerPush();
        this.producerPush();
        this.producerPush();
        this.producerPush();
    }

    public void dup2_x1() {
        super.dup2_x1();
        this.producerPop();
        this.producerPop();
        this.producerPop();
        this.producerPush();
        this.producerPush();
        this.producerPush();
        this.producerPush();
        this.producerPush();
    }

    public void dup2_x2() {
        super.dup2_x2();
        this.producerPop();
        this.producerPop();
        this.producerPop();
        this.producerPop();
        this.producerPush();
        this.producerPush();
        this.producerPush();
        this.producerPush();
        this.producerPush();
        this.producerPush();
    }

    public void swap() {
        super.swap();
        this.producerPop();
        this.producerPop();
        this.producerPush();
        this.producerPush();
    }

    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TracedStack other = (TracedStack)object;
        return super.equals(object) && this.producerStack.equals(other.producerStack);
    }

    public int hashCode() {
        return super.hashCode() ^ this.producerStack.hashCode();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (int index = 0; index < this.size(); ++index) {
            Value value = this.values[index];
            Value producerValue = this.producerStack.getBottom(index);
            buffer = buffer.append('[').append(producerValue == null ? "empty" : producerValue.toString()).append('>').append(value == null ? "empty" : value.toString()).append(']');
        }
        return buffer.toString();
    }

    private void producerPush() {
        this.producerStack.push(this.producerValue);
    }

    private void producerPop() {
        this.producerStack.pop();
    }
}

