/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.value;

import java.util.HashSet;
import java.util.Set;
import proguard.classfile.Clazz;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.ClassCollector;
import proguard.evaluation.value.Category1Value;
import proguard.evaluation.value.IntegerValue;
import proguard.evaluation.value.Value;
import proguard.evaluation.value.ValueFactory;

public class ReferenceValue
extends Category1Value {
    private static final boolean DEBUG = false;
    private final String type;
    private final Clazz referencedClass;
    private final boolean mayBeNull;

    public ReferenceValue(String type, Clazz referencedClass, boolean mayBeNull) {
        this.type = type;
        this.referencedClass = referencedClass;
        this.mayBeNull = mayBeNull;
    }

    public String getType() {
        return this.type;
    }

    public Clazz getReferencedClass() {
        return this.referencedClass;
    }

    public int isNull() {
        return this.type == null ? 1 : (this.mayBeNull ? 0 : -1);
    }

    public int instanceOf(String otherType, Clazz otherReferencedClass) {
        String thisType = this.type;
        if (thisType == null) {
            return -1;
        }
        int thisDimensionCount = ClassUtil.internalArrayTypeDimensionCount(thisType);
        int otherDimensionCount = ClassUtil.internalArrayTypeDimensionCount(otherType);
        int commonDimensionCount = Math.min(thisDimensionCount, otherDimensionCount);
        thisType = thisType.substring(commonDimensionCount);
        otherType = otherType.substring(commonDimensionCount);
        if (commonDimensionCount > 0 && (ClassUtil.isInternalPrimitiveType(thisType.charAt(0)) || ClassUtil.isInternalPrimitiveType(otherType.charAt(0)))) {
            return !thisType.equals(otherType) ? -1 : (this.mayBeNull ? 0 : 1);
        }
        if (thisDimensionCount == commonDimensionCount) {
            thisType = ClassUtil.internalClassNameFromClassType(thisType);
        }
        if (otherDimensionCount == commonDimensionCount) {
            otherType = ClassUtil.internalClassNameFromClassType(otherType);
        }
        if (thisDimensionCount > otherDimensionCount && !ClassUtil.isInternalArrayInterfaceName(otherType)) {
            return -1;
        }
        if (thisDimensionCount < otherDimensionCount && !ClassUtil.isInternalArrayInterfaceName(thisType)) {
            return -1;
        }
        if (this.mayBeNull) {
            return 0;
        }
        if (thisType.equals(otherType) || "java/lang/Object".equals(otherType)) {
            return 1;
        }
        if (thisDimensionCount > otherDimensionCount) {
            return 1;
        }
        if (thisDimensionCount < otherDimensionCount) {
            return 0;
        }
        return this.referencedClass != null && otherReferencedClass != null && this.referencedClass.extendsOrImplements(otherReferencedClass) ? 1 : 0;
    }

    public IntegerValue arrayLength(ValueFactory valueFactory) {
        return valueFactory.createIntegerValue();
    }

    public Value arrayLoad(IntegerValue integerValue, ValueFactory valueFactory) {
        return this.type == null ? ValueFactory.REFERENCE_VALUE_NULL : (!ClassUtil.isInternalArrayType(this.type) ? ValueFactory.REFERENCE_VALUE_JAVA_LANG_OBJECT_MAYBE_NULL : valueFactory.createValue(this.type.substring(1), this.referencedClass, true));
    }

    public ReferenceValue generalize(ReferenceValue other) {
        boolean mayBeNull;
        String thisType = this.type;
        String otherType = other.type;
        if (thisType == null && otherType == null) {
            return ValueFactory.REFERENCE_VALUE_NULL;
        }
        if (thisType == null) {
            return other.generalizeMayBeNull(true);
        }
        if (otherType == null) {
            return this.generalizeMayBeNull(true);
        }
        boolean bl = mayBeNull = this.mayBeNull || other.mayBeNull;
        if (thisType.equals(otherType)) {
            return this.generalizeMayBeNull(mayBeNull);
        }
        int thisDimensionCount = ClassUtil.internalArrayTypeDimensionCount(thisType);
        int otherDimensionCount = ClassUtil.internalArrayTypeDimensionCount(otherType);
        int commonDimensionCount = Math.min(thisDimensionCount, otherDimensionCount);
        if (thisDimensionCount == otherDimensionCount) {
            Clazz thisReferencedClass = this.referencedClass;
            Clazz otherReferencedClass = other.referencedClass;
            if (thisReferencedClass != null && otherReferencedClass != null) {
                if (thisReferencedClass.extendsOrImplements(otherReferencedClass)) {
                    return other.generalizeMayBeNull(mayBeNull);
                }
                if (otherReferencedClass.extendsOrImplements(thisReferencedClass)) {
                    return this.generalizeMayBeNull(mayBeNull);
                }
                HashSet thisSuperClasses = new HashSet();
                thisReferencedClass.hierarchyAccept(false, true, true, false, new ClassCollector(thisSuperClasses));
                HashSet otherSuperClasses = new HashSet();
                otherReferencedClass.hierarchyAccept(false, true, true, false, new ClassCollector(otherSuperClasses));
                thisSuperClasses.retainAll(otherSuperClasses);
                Clazz commonClazz = null;
                int maximumSuperClassCount = -1;
                for (Clazz commonSuperClass : thisSuperClasses) {
                    int superClassCount = this.superClassCount(commonSuperClass, thisSuperClasses);
                    if (maximumSuperClassCount >= superClassCount && (maximumSuperClassCount != superClassCount || commonClazz == null || commonClazz.getName().compareTo(commonSuperClass.getName()) <= 0)) continue;
                    commonClazz = commonSuperClass;
                    maximumSuperClassCount = superClassCount;
                }
                if (commonClazz == null) {
                    throw new IllegalArgumentException("Can't find common super class of [" + thisType + "] and [" + otherType + "]");
                }
                return new ReferenceValue(commonDimensionCount == 0 ? commonClazz.getName() : ClassUtil.internalArrayTypeFromClassName(commonClazz.getName(), commonDimensionCount), commonClazz, mayBeNull);
            }
        } else if (thisDimensionCount > otherDimensionCount) {
            if (ClassUtil.isInternalArrayInterfaceName(ClassUtil.internalClassNameFromClassType(otherType))) {
                return other.generalizeMayBeNull(mayBeNull);
            }
        } else if (thisDimensionCount < otherDimensionCount && ClassUtil.isInternalArrayInterfaceName(ClassUtil.internalClassNameFromClassType(thisType))) {
            return this.generalizeMayBeNull(mayBeNull);
        }
        if (commonDimensionCount > 0 && ClassUtil.isInternalPrimitiveType(otherType.charAt(commonDimensionCount)) || ClassUtil.isInternalPrimitiveType(thisType.charAt(commonDimensionCount))) {
            --commonDimensionCount;
        }
        return commonDimensionCount == 0 ? (mayBeNull ? ValueFactory.REFERENCE_VALUE_JAVA_LANG_OBJECT_MAYBE_NULL : ValueFactory.REFERENCE_VALUE_JAVA_LANG_OBJECT_NOT_NULL) : new ReferenceValue(ClassUtil.internalArrayTypeFromClassName("java/lang/Object", commonDimensionCount), null, mayBeNull);
    }

    private int superClassCount(Clazz subClass, Set classes) {
        int count = 0;
        for (Clazz clazz : classes) {
            if (!subClass.extendsOrImplements(clazz)) continue;
            ++count;
        }
        return count;
    }

    public int equal(ReferenceValue other) {
        return this.type == null && other.type == null ? 1 : 0;
    }

    public final int isNotNull() {
        return -this.isNull();
    }

    private ReferenceValue generalizeMayBeNull(boolean mayBeNull) {
        return this.mayBeNull || !mayBeNull ? this : new ReferenceValue(this.type, this.referencedClass, true);
    }

    public final int notEqual(ReferenceValue other) {
        return -this.equal(other);
    }

    public final ReferenceValue referenceValue() {
        return this;
    }

    public final Value generalize(Value other) {
        return this.generalize(other.referenceValue());
    }

    public boolean isSpecific() {
        return this.type == null;
    }

    public final int computationalType() {
        return 5;
    }

    public final String internalType() {
        return this.type == null ? "Ljava/lang/Object;" : (ClassUtil.isInternalArrayType(this.type) ? this.type : 'L' + this.type + ';');
    }

    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ReferenceValue other = (ReferenceValue)object;
        return this.type == null ? other.type == null : this.mayBeNull == other.mayBeNull && this.type.equals(other.type);
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ (this.type == null ? 0 : this.type.hashCode() ^ (this.mayBeNull ? 0 : 1));
    }

    public String toString() {
        return "a:" + (this.type == null ? "null" : this.type + (this.referencedClass == null ? "?" : "") + (this.mayBeNull ? "" : "!"));
    }
}

