/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.value;

import proguard.evaluation.value.DoubleValue;
import proguard.evaluation.value.FloatValue;
import proguard.evaluation.value.IntegerValue;
import proguard.evaluation.value.LongValue;
import proguard.evaluation.value.SpecificFloatValue;
import proguard.evaluation.value.SpecificIntegerValue;
import proguard.evaluation.value.SpecificLongValue;
import proguard.evaluation.value.SpecificValueFactory;
import proguard.evaluation.value.ValueFactory;

final class SpecificDoubleValue
extends DoubleValue {
    private final double value;

    public SpecificDoubleValue(double value) {
        this.value = value;
    }

    public double value() {
        return this.value;
    }

    public DoubleValue generalize(DoubleValue other) {
        return other.generalize(this);
    }

    public DoubleValue add(DoubleValue other) {
        return other.add(this);
    }

    public DoubleValue subtract(DoubleValue other) {
        return other.subtractFrom(this);
    }

    public DoubleValue subtractFrom(DoubleValue other) {
        return other.subtract(this);
    }

    public DoubleValue multiply(DoubleValue other) {
        return other.multiply(this);
    }

    public DoubleValue divide(DoubleValue other) {
        return other.divideOf(this);
    }

    public DoubleValue divideOf(DoubleValue other) {
        return other.divide(this);
    }

    public DoubleValue remainder(DoubleValue other) {
        return other.remainderOf(this);
    }

    public DoubleValue remainderOf(DoubleValue other) {
        return other.remainder(this);
    }

    public IntegerValue compare(DoubleValue other, ValueFactory valueFactory) {
        return other.compareReverse(this, valueFactory);
    }

    public DoubleValue negate() {
        return new SpecificDoubleValue(-this.value);
    }

    public IntegerValue convertToInteger(ValueFactory valueFactory) {
        return new SpecificIntegerValue((int)this.value);
    }

    public LongValue convertToLong(ValueFactory valueFactory) {
        return new SpecificLongValue((long)this.value);
    }

    public FloatValue convertToFloat(ValueFactory valueFactory) {
        return new SpecificFloatValue((float)this.value);
    }

    public DoubleValue generalize(SpecificDoubleValue other) {
        return this.value == other.value ? this : ValueFactory.DOUBLE_VALUE;
    }

    public DoubleValue add(SpecificDoubleValue other) {
        return new SpecificDoubleValue(this.value + other.value);
    }

    public DoubleValue subtract(SpecificDoubleValue other) {
        return new SpecificDoubleValue(this.value - other.value);
    }

    public DoubleValue subtractFrom(SpecificDoubleValue other) {
        return new SpecificDoubleValue(other.value - this.value);
    }

    public DoubleValue multiply(SpecificDoubleValue other) {
        return new SpecificDoubleValue(this.value * other.value);
    }

    public DoubleValue divide(SpecificDoubleValue other) {
        return new SpecificDoubleValue(this.value / other.value);
    }

    public DoubleValue divideOf(SpecificDoubleValue other) {
        return new SpecificDoubleValue(other.value / this.value);
    }

    public DoubleValue remainder(SpecificDoubleValue other) {
        return new SpecificDoubleValue(this.value % other.value);
    }

    public DoubleValue remainderOf(SpecificDoubleValue other) {
        return new SpecificDoubleValue(other.value % this.value);
    }

    public IntegerValue compare(SpecificDoubleValue other, ValueFactory valueFactory) {
        return this.value < other.value ? SpecificValueFactory.INTEGER_VALUE_M1 : (this.value == other.value ? SpecificValueFactory.INTEGER_VALUE_0 : SpecificValueFactory.INTEGER_VALUE_1);
    }

    public boolean isSpecific() {
        return true;
    }

    public boolean equals(Object object) {
        return object != null && this.getClass() == object.getClass() && this.value == ((SpecificDoubleValue)object).value;
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ (int)Double.doubleToLongBits(this.value);
    }

    public String toString() {
        return "d:" + this.value;
    }
}

