/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.value;

import proguard.evaluation.value.DoubleValue;
import proguard.evaluation.value.FloatValue;
import proguard.evaluation.value.IntegerValue;
import proguard.evaluation.value.LongValue;
import proguard.evaluation.value.ValueFactory;

final class SpecificFloatValue
extends FloatValue {
    private final float value;

    public SpecificFloatValue(float value) {
        this.value = value;
    }

    public float value() {
        return this.value;
    }

    public FloatValue generalize(FloatValue other) {
        return other.generalize(this);
    }

    public FloatValue add(FloatValue other) {
        return other.add(this);
    }

    public FloatValue subtract(FloatValue other) {
        return other.subtractFrom(this);
    }

    public FloatValue subtractFrom(FloatValue other) {
        return other.subtract(this);
    }

    public FloatValue multiply(FloatValue other) {
        return other.multiply(this);
    }

    public FloatValue divide(FloatValue other) {
        return other.divideOf(this);
    }

    public FloatValue divideOf(FloatValue other) {
        return other.divide(this);
    }

    public FloatValue remainder(FloatValue other) {
        return other.remainderOf(this);
    }

    public FloatValue remainderOf(FloatValue other) {
        return other.remainder(this);
    }

    public IntegerValue compare(FloatValue other, ValueFactory valueFactory) {
        return other.compareReverse(this, valueFactory);
    }

    public FloatValue negate() {
        return new SpecificFloatValue(-this.value);
    }

    public IntegerValue convertToInteger(ValueFactory valueFactory) {
        return valueFactory.createIntegerValue((int)this.value);
    }

    public LongValue convertToLong(ValueFactory valueFactory) {
        return valueFactory.createLongValue((long)this.value);
    }

    public DoubleValue convertToDouble(ValueFactory valueFactory) {
        return valueFactory.createDoubleValue(this.value);
    }

    public FloatValue generalize(SpecificFloatValue other) {
        return this.value == other.value ? this : ValueFactory.FLOAT_VALUE;
    }

    public FloatValue add(SpecificFloatValue other) {
        return new SpecificFloatValue(this.value + other.value);
    }

    public FloatValue subtract(SpecificFloatValue other) {
        return new SpecificFloatValue(this.value - other.value);
    }

    public FloatValue subtractFrom(SpecificFloatValue other) {
        return new SpecificFloatValue(other.value - this.value);
    }

    public FloatValue multiply(SpecificFloatValue other) {
        return new SpecificFloatValue(this.value * other.value);
    }

    public FloatValue divide(SpecificFloatValue other) {
        return new SpecificFloatValue(this.value / other.value);
    }

    public FloatValue divideOf(SpecificFloatValue other) {
        return new SpecificFloatValue(other.value / this.value);
    }

    public FloatValue remainder(SpecificFloatValue other) {
        return new SpecificFloatValue(this.value % other.value);
    }

    public FloatValue remainderOf(SpecificFloatValue other) {
        return new SpecificFloatValue(other.value % this.value);
    }

    public IntegerValue compare(SpecificFloatValue other, ValueFactory valueFactory) {
        return this.value < other.value ? valueFactory.createIntegerValue(-1) : (this.value == other.value ? valueFactory.createIntegerValue(0) : valueFactory.createIntegerValue(1));
    }

    public boolean isSpecific() {
        return true;
    }

    public boolean equals(Object object) {
        return object != null && this.getClass() == object.getClass() && this.value == ((SpecificFloatValue)object).value;
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ Float.floatToIntBits(this.value);
    }

    public String toString() {
        return "f:" + this.value;
    }
}

