/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.value;

import proguard.evaluation.value.DoubleValue;
import proguard.evaluation.value.FloatValue;
import proguard.evaluation.value.IntegerValue;
import proguard.evaluation.value.LongValue;
import proguard.evaluation.value.SpecificLongValue;
import proguard.evaluation.value.ValueFactory;

final class SpecificIntegerValue
extends IntegerValue {
    private final int value;

    public SpecificIntegerValue(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    public IntegerValue generalize(IntegerValue other) {
        return other.generalize(this);
    }

    public IntegerValue add(IntegerValue other) {
        return other.add(this);
    }

    public IntegerValue subtract(IntegerValue other) {
        return other.subtractFrom(this);
    }

    public IntegerValue subtractFrom(IntegerValue other) {
        return other.subtract(this);
    }

    public IntegerValue multiply(IntegerValue other) {
        return other.multiply(this);
    }

    public IntegerValue divide(IntegerValue other) throws ArithmeticException {
        return other.divideOf(this);
    }

    public IntegerValue divideOf(IntegerValue other) throws ArithmeticException {
        return other.divide(this);
    }

    public IntegerValue remainder(IntegerValue other) throws ArithmeticException {
        return other.remainderOf(this);
    }

    public IntegerValue remainderOf(IntegerValue other) throws ArithmeticException {
        return other.remainder(this);
    }

    public IntegerValue shiftLeft(IntegerValue other) {
        return other.shiftLeftOf(this);
    }

    public IntegerValue shiftLeftOf(IntegerValue other) {
        return other.shiftLeft(this);
    }

    public IntegerValue shiftRight(IntegerValue other) {
        return other.shiftRightOf(this);
    }

    public IntegerValue shiftRightOf(IntegerValue other) {
        return other.shiftRight(this);
    }

    public IntegerValue unsignedShiftRight(IntegerValue other) {
        return other.unsignedShiftRightOf(this);
    }

    public IntegerValue unsignedShiftRightOf(IntegerValue other) {
        return other.unsignedShiftRight(this);
    }

    public LongValue shiftLeftOf(LongValue other) {
        return other.shiftLeft(this);
    }

    public LongValue shiftRightOf(LongValue other) {
        return other.shiftRight(this);
    }

    public LongValue unsignedShiftRightOf(LongValue other) {
        return other.unsignedShiftRight(this);
    }

    public IntegerValue and(IntegerValue other) {
        return other.and(this);
    }

    public IntegerValue or(IntegerValue other) {
        return other.or(this);
    }

    public IntegerValue xor(IntegerValue other) {
        return other.xor(this);
    }

    public int equal(IntegerValue other) {
        return other.equal(this);
    }

    public int lessThan(IntegerValue other) {
        return other.greaterThan(this);
    }

    public int lessThanOrEqual(IntegerValue other) {
        return other.greaterThanOrEqual(this);
    }

    public IntegerValue negate() {
        return new SpecificIntegerValue(-this.value);
    }

    public IntegerValue convertToByte(ValueFactory valueFactory) {
        byte byteValue = (byte)this.value;
        return byteValue == this.value ? this : new SpecificIntegerValue(byteValue);
    }

    public IntegerValue convertToCharacter(ValueFactory valueFactory) {
        char charValue = (char)this.value;
        return charValue == this.value ? this : new SpecificIntegerValue(charValue);
    }

    public IntegerValue convertToShort(ValueFactory valueFactory) {
        short shortValue = (short)this.value;
        return shortValue == this.value ? this : new SpecificIntegerValue(shortValue);
    }

    public IntegerValue convertToInteger(ValueFactory valueFactory) {
        return this;
    }

    public LongValue convertToLong(ValueFactory valueFactory) {
        return valueFactory.createLongValue(this.value);
    }

    public FloatValue convertToFloat(ValueFactory valueFactory) {
        return valueFactory.createFloatValue(this.value);
    }

    public DoubleValue convertToDouble(ValueFactory valueFactory) {
        return valueFactory.createDoubleValue(this.value);
    }

    public IntegerValue generalize(SpecificIntegerValue other) {
        return this.value == other.value ? this : ValueFactory.INTEGER_VALUE;
    }

    public IntegerValue add(SpecificIntegerValue other) {
        return new SpecificIntegerValue(this.value + other.value);
    }

    public IntegerValue subtract(SpecificIntegerValue other) {
        return new SpecificIntegerValue(this.value - other.value);
    }

    public IntegerValue subtractFrom(SpecificIntegerValue other) {
        return new SpecificIntegerValue(other.value - this.value);
    }

    public IntegerValue multiply(SpecificIntegerValue other) {
        return new SpecificIntegerValue(this.value * other.value);
    }

    public IntegerValue divide(SpecificIntegerValue other) throws ArithmeticException {
        return new SpecificIntegerValue(this.value / other.value);
    }

    public IntegerValue divideOf(SpecificIntegerValue other) throws ArithmeticException {
        return new SpecificIntegerValue(other.value / this.value);
    }

    public IntegerValue remainder(SpecificIntegerValue other) throws ArithmeticException {
        return new SpecificIntegerValue(this.value % other.value);
    }

    public IntegerValue remainderOf(SpecificIntegerValue other) throws ArithmeticException {
        return new SpecificIntegerValue(other.value % this.value);
    }

    public IntegerValue shiftLeft(SpecificIntegerValue other) {
        return new SpecificIntegerValue(this.value << other.value);
    }

    public IntegerValue shiftLeftOf(SpecificIntegerValue other) {
        return new SpecificIntegerValue(other.value << this.value);
    }

    public IntegerValue shiftRight(SpecificIntegerValue other) {
        return new SpecificIntegerValue(this.value >> other.value);
    }

    public IntegerValue shiftRightOf(SpecificIntegerValue other) {
        return new SpecificIntegerValue(other.value >> this.value);
    }

    public IntegerValue unsignedShiftRight(SpecificIntegerValue other) {
        return new SpecificIntegerValue(this.value >>> other.value);
    }

    public IntegerValue unsignedShiftRightOf(SpecificIntegerValue other) {
        return new SpecificIntegerValue(other.value >>> this.value);
    }

    public LongValue shiftLeftOf(SpecificLongValue other, ValueFactory valueFactory) {
        return valueFactory.createLongValue(other.value() << this.value);
    }

    public LongValue shiftRightOf(SpecificLongValue other, ValueFactory valueFactory) {
        return valueFactory.createLongValue(other.value() >> this.value);
    }

    public LongValue unsignedShiftRightOf(SpecificLongValue other, ValueFactory valueFactory) {
        return valueFactory.createLongValue(other.value() >>> this.value);
    }

    public IntegerValue and(SpecificIntegerValue other) {
        return new SpecificIntegerValue(this.value & other.value);
    }

    public IntegerValue or(SpecificIntegerValue other) {
        return new SpecificIntegerValue(this.value | other.value);
    }

    public IntegerValue xor(SpecificIntegerValue other) {
        return new SpecificIntegerValue(this.value ^ other.value);
    }

    public int equal(SpecificIntegerValue other) {
        return this.value == other.value ? 1 : -1;
    }

    public int lessThan(SpecificIntegerValue other) {
        return this.value < other.value ? 1 : -1;
    }

    public int lessThanOrEqual(SpecificIntegerValue other) {
        return this.value <= other.value ? 1 : -1;
    }

    public boolean isSpecific() {
        return true;
    }

    public boolean equals(Object object) {
        return object != null && this.getClass() == object.getClass() && this.value == ((SpecificIntegerValue)object).value;
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.value;
    }

    public String toString() {
        return "i:" + this.value;
    }
}

