/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.value;

import proguard.evaluation.value.DoubleValue;
import proguard.evaluation.value.FloatValue;
import proguard.evaluation.value.IntegerValue;
import proguard.evaluation.value.LongValue;
import proguard.evaluation.value.SpecificIntegerValue;
import proguard.evaluation.value.ValueFactory;

final class SpecificLongValue
extends LongValue {
    private final long value;

    public SpecificLongValue(long value) {
        this.value = value;
    }

    public long value() {
        return this.value;
    }

    public LongValue generalize(LongValue other) {
        return other.generalize(this);
    }

    public LongValue add(LongValue other) {
        return other.add(this);
    }

    public LongValue subtract(LongValue other) {
        return other.subtractFrom(this);
    }

    public LongValue subtractFrom(LongValue other) {
        return other.subtract(this);
    }

    public LongValue multiply(LongValue other) {
        return other.multiply(this);
    }

    public LongValue divide(LongValue other) {
        return other.divideOf(this);
    }

    public LongValue divideOf(LongValue other) {
        return other.divide(this);
    }

    public LongValue remainder(LongValue other) {
        return other.remainderOf(this);
    }

    public LongValue remainderOf(LongValue other) {
        return other.remainder(this);
    }

    public LongValue shiftLeft(IntegerValue other) {
        return other.shiftLeftOf(this);
    }

    public LongValue shiftRight(IntegerValue other) {
        return other.shiftRightOf(this);
    }

    public LongValue unsignedShiftRight(IntegerValue other) {
        return other.unsignedShiftRightOf(this);
    }

    public LongValue and(LongValue other) {
        return other.and(this);
    }

    public LongValue or(LongValue other) {
        return other.or(this);
    }

    public LongValue xor(LongValue other) {
        return other.xor(this);
    }

    public IntegerValue compare(LongValue other, ValueFactory valueFactory) {
        return other.compareReverse(this, valueFactory);
    }

    public LongValue negate() {
        return new SpecificLongValue(-this.value);
    }

    public IntegerValue convertToInteger(ValueFactory valueFactory) {
        return valueFactory.createIntegerValue((int)this.value);
    }

    public FloatValue convertToFloat(ValueFactory valueFactory) {
        return valueFactory.createFloatValue(this.value);
    }

    public DoubleValue convertToDouble(ValueFactory valueFactory) {
        return valueFactory.createDoubleValue(this.value);
    }

    public LongValue generalize(SpecificLongValue other) {
        return this.value == other.value ? this : ValueFactory.LONG_VALUE;
    }

    public LongValue add(SpecificLongValue other) {
        return new SpecificLongValue(this.value + other.value);
    }

    public LongValue subtract(SpecificLongValue other) {
        return new SpecificLongValue(this.value - other.value);
    }

    public LongValue subtractFrom(SpecificLongValue other) {
        return new SpecificLongValue(other.value - this.value);
    }

    public LongValue multiply(SpecificLongValue other) {
        return new SpecificLongValue(this.value * other.value);
    }

    public LongValue divide(SpecificLongValue other) {
        return new SpecificLongValue(this.value / other.value);
    }

    public LongValue divideOf(SpecificLongValue other) {
        return new SpecificLongValue(other.value / this.value);
    }

    public LongValue remainder(SpecificLongValue other) {
        return new SpecificLongValue(this.value % other.value);
    }

    public LongValue remainderOf(SpecificLongValue other) {
        return new SpecificLongValue(other.value % this.value);
    }

    public LongValue shiftLeft(SpecificIntegerValue other) {
        return new SpecificLongValue(this.value << other.value());
    }

    public LongValue shiftRight(SpecificIntegerValue other) {
        return new SpecificLongValue(this.value >> other.value());
    }

    public LongValue unsignedShiftRight(SpecificIntegerValue other) {
        return new SpecificLongValue(this.value >>> other.value());
    }

    public LongValue and(SpecificLongValue other) {
        return new SpecificLongValue(this.value & other.value);
    }

    public LongValue or(SpecificLongValue other) {
        return new SpecificLongValue(this.value | other.value);
    }

    public LongValue xor(SpecificLongValue other) {
        return new SpecificLongValue(this.value ^ other.value);
    }

    public IntegerValue compare(SpecificLongValue other, ValueFactory valueFactory) {
        return this.value < other.value ? valueFactory.createIntegerValue(-1) : (this.value == other.value ? valueFactory.createIntegerValue(0) : valueFactory.createIntegerValue(1));
    }

    public boolean isSpecific() {
        return true;
    }

    public boolean equals(Object object) {
        return object != null && this.getClass() == object.getClass() && this.value == ((SpecificLongValue)object).value;
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ (int)this.value;
    }

    public String toString() {
        return "l:" + this.value;
    }
}

