/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.value;

import proguard.evaluation.value.DoubleValue;
import proguard.evaluation.value.FloatValue;
import proguard.evaluation.value.IntegerValue;
import proguard.evaluation.value.LongValue;
import proguard.evaluation.value.SpecificDoubleValue;
import proguard.evaluation.value.SpecificFloatValue;
import proguard.evaluation.value.SpecificIntegerValue;
import proguard.evaluation.value.SpecificLongValue;
import proguard.evaluation.value.ValueFactory;

public class SpecificValueFactory
extends ValueFactory {
    static final IntegerValue INTEGER_VALUE_M1 = new SpecificIntegerValue(-1);
    static final IntegerValue INTEGER_VALUE_0 = new SpecificIntegerValue(0);
    static final IntegerValue INTEGER_VALUE_1 = new SpecificIntegerValue(1);
    static final IntegerValue INTEGER_VALUE_2 = new SpecificIntegerValue(2);
    static final IntegerValue INTEGER_VALUE_3 = new SpecificIntegerValue(3);
    static final IntegerValue INTEGER_VALUE_4 = new SpecificIntegerValue(4);
    static final IntegerValue INTEGER_VALUE_5 = new SpecificIntegerValue(5);
    static final LongValue LONG_VALUE_0 = new SpecificLongValue(0L);
    static final LongValue LONG_VALUE_1 = new SpecificLongValue(1L);
    static final FloatValue FLOAT_VALUE_0 = new SpecificFloatValue(0.0f);
    static final FloatValue FLOAT_VALUE_1 = new SpecificFloatValue(1.0f);
    static final FloatValue FLOAT_VALUE_2 = new SpecificFloatValue(2.0f);
    static final DoubleValue DOUBLE_VALUE_0 = new SpecificDoubleValue(0.0);
    static final DoubleValue DOUBLE_VALUE_1 = new SpecificDoubleValue(1.0);

    public IntegerValue createIntegerValue(int value) {
        switch (value) {
            case -1: {
                return INTEGER_VALUE_M1;
            }
            case 0: {
                return INTEGER_VALUE_0;
            }
            case 1: {
                return INTEGER_VALUE_1;
            }
            case 2: {
                return INTEGER_VALUE_2;
            }
            case 3: {
                return INTEGER_VALUE_3;
            }
            case 4: {
                return INTEGER_VALUE_4;
            }
            case 5: {
                return INTEGER_VALUE_5;
            }
        }
        return new SpecificIntegerValue(value);
    }

    public LongValue createLongValue(long value) {
        return value == 0L ? LONG_VALUE_0 : (value == 1L ? LONG_VALUE_1 : new SpecificLongValue(value));
    }

    public FloatValue createFloatValue(float value) {
        return value == 0.0f ? FLOAT_VALUE_0 : (value == 1.0f ? FLOAT_VALUE_1 : (value == 2.0f ? FLOAT_VALUE_2 : new SpecificFloatValue(value)));
    }

    public DoubleValue createDoubleValue(double value) {
        return value == 0.0 ? DOUBLE_VALUE_0 : (value == 1.0 ? DOUBLE_VALUE_1 : new SpecificDoubleValue(value));
    }
}

