/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.io.DataEntry;
import proguard.io.DataEntryReader;
import proguard.io.DataEntryWriter;

public class DataEntryRewriter
implements DataEntryReader {
    private final ClassPool classPool;
    private final DataEntryWriter dataEntryWriter;

    public DataEntryRewriter(ClassPool classPool, DataEntryWriter dataEntryWriter) {
        this.classPool = classPool;
        this.dataEntryWriter = dataEntryWriter;
    }

    public void read(DataEntry dataEntry) throws IOException {
        try {
            OutputStream outputStream = this.dataEntryWriter.getOutputStream(dataEntry);
            if (outputStream != null) {
                InputStream inputStream = dataEntry.getInputStream();
                this.copyData(inputStream, outputStream);
                dataEntry.closeInputStream();
            }
        }
        catch (IOException ex) {
            System.err.println("Warning: can't write resource [" + dataEntry.getName() + "] (" + ex.getMessage() + ")");
        }
    }

    private void copyData(InputStream inputStream, OutputStream outputStream) throws IOException {
        int i;
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream));
        StringBuffer word = new StringBuffer();
        while ((i = ((Reader)reader).read()) >= 0) {
            char c = (char)i;
            if (Character.isJavaIdentifierPart(c) || c == '.' || c == '-') {
                word.append(c);
                continue;
            }
            this.writeUpdatedWord(writer, word.toString());
            word.setLength(0);
            ((Writer)writer).write(c);
        }
        this.writeUpdatedWord(writer, word.toString());
        ((Writer)writer).flush();
        outputStream.flush();
    }

    private void writeUpdatedWord(Writer writer, String word) throws IOException {
        if (word.length() > 0) {
            String newClassName;
            String newWord = word;
            boolean containsDots = word.indexOf(46) >= 0;
            String className = containsDots ? word.replace('.', '/') : word;
            Clazz clazz = this.classPool.getClass(className);
            if (clazz != null && !className.equals(newClassName = clazz.getName())) {
                newWord = containsDots ? newClassName.replace('/', '.') : newClassName;
            }
            writer.write(newWord);
        }
    }
}

