/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.EnclosingMethodAttribute;
import proguard.classfile.attribute.InnerClassesAttribute;
import proguard.classfile.attribute.InnerClassesInfo;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.InnerClassesInfoVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.obfuscate.NameFactory;
import proguard.obfuscate.SimpleNameFactory;

public class ClassObfuscator
extends SimplifiedVisitor
implements ClassVisitor,
AttributeVisitor,
InnerClassesInfoVisitor,
ConstantVisitor {
    private final boolean useMixedCaseClassNames;
    private final String flattenPackageHierarchy;
    private final String repackageClasses;
    private final boolean allowAccessModification;
    private final Set classNamesToAvoid = new HashSet();
    private final Map packagePrefixMap = new HashMap();
    private final Map packagePrefixPackageNameFactoryMap = new HashMap();
    private final Map packagePrefixClassNameFactoryMap = new HashMap();
    private String newClassName;

    public ClassObfuscator(ClassPool programClassPool, boolean useMixedCaseClassNames, String flattenPackageHierarchy, String repackageClasses, boolean allowAccessModification) {
        if (flattenPackageHierarchy != null && flattenPackageHierarchy.length() > 0) {
            flattenPackageHierarchy = flattenPackageHierarchy + '/';
        }
        if (repackageClasses != null && repackageClasses.length() > 0) {
            repackageClasses = repackageClasses + '/';
        }
        this.useMixedCaseClassNames = useMixedCaseClassNames;
        this.flattenPackageHierarchy = flattenPackageHierarchy;
        this.repackageClasses = repackageClasses;
        this.allowAccessModification = allowAccessModification;
        this.packagePrefixMap.put("", "");
        programClassPool.classesAccept(new MyKeepCollector());
    }

    public void visitProgramClass(ProgramClass programClass) {
        this.newClassName = ClassObfuscator.newClassName(programClass);
        if (this.newClassName == null) {
            programClass.attributesAccept(this);
            String newPackagePrefix = this.newClassName != null ? this.newClassName + '$' : this.newPackagePrefix(ClassUtil.internalPackagePrefix(programClass.getName()));
            this.newClassName = this.generateUniqueClassName(newPackagePrefix);
            ClassObfuscator.setNewClassName(programClass, this.newClassName);
        }
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitInnerClassesAttribute(Clazz clazz, InnerClassesAttribute innerClassesAttribute) {
        innerClassesAttribute.innerClassEntriesAccept(clazz, this);
    }

    public void visitEnclosingMethodAttribute(Clazz clazz, EnclosingMethodAttribute enclosingMethodAttribute) {
        enclosingMethodAttribute.referencedClassAccept(this);
    }

    public void visitInnerClassesInfo(Clazz clazz, InnerClassesInfo innerClassesInfo) {
        int innerClassIndex = innerClassesInfo.u2innerClassIndex;
        int outerClassIndex = innerClassesInfo.u2outerClassIndex;
        if (innerClassIndex != 0 && outerClassIndex != 0 && clazz.getClassName(innerClassIndex).equals(clazz.getName())) {
            clazz.constantPoolEntryAccept(outerClassIndex, this);
        }
    }

    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        classConstant.referencedClassAccept(this);
    }

    private String newPackagePrefix(String packagePrefix) {
        String newPackagePrefix = (String)this.packagePrefixMap.get(packagePrefix);
        if (newPackagePrefix == null) {
            if (this.repackageClasses != null) {
                return this.repackageClasses;
            }
            String newSuperPackagePrefix = this.flattenPackageHierarchy != null ? this.flattenPackageHierarchy : this.newPackagePrefix(ClassUtil.internalPackagePrefix(packagePrefix));
            newPackagePrefix = this.generateUniquePackagePrefix(newSuperPackagePrefix);
            this.packagePrefixMap.put(packagePrefix, newPackagePrefix);
        }
        return newPackagePrefix;
    }

    private String generateUniquePackagePrefix(String newSuperPackagePrefix) {
        String newPackagePrefix;
        NameFactory packageNameFactory = (NameFactory)this.packagePrefixPackageNameFactoryMap.get(newSuperPackagePrefix);
        if (packageNameFactory == null) {
            packageNameFactory = new SimpleNameFactory(this.useMixedCaseClassNames);
            this.packagePrefixPackageNameFactoryMap.put(newSuperPackagePrefix, packageNameFactory);
        }
        while (this.packagePrefixMap.containsValue(newPackagePrefix = newSuperPackagePrefix + packageNameFactory.nextName() + '/')) {
        }
        return newPackagePrefix;
    }

    private String generateUniqueClassName(String newPackagePrefix) {
        String newClassName;
        NameFactory classNameFactory = (NameFactory)this.packagePrefixClassNameFactoryMap.get(newPackagePrefix);
        if (classNameFactory == null) {
            classNameFactory = new SimpleNameFactory(this.useMixedCaseClassNames);
            this.packagePrefixClassNameFactoryMap.put(newPackagePrefix, classNameFactory);
        }
        while (this.classNamesToAvoid.contains(this.mixedCaseClassName(newClassName = newPackagePrefix + classNameFactory.nextName()))) {
        }
        return newClassName;
    }

    private String mixedCaseClassName(String className) {
        return this.useMixedCaseClassNames ? className : className.toLowerCase();
    }

    static void setNewClassName(Clazz clazz, String name) {
        clazz.setVisitorInfo(name);
    }

    static String newClassName(Clazz clazz) {
        Object visitorInfo = clazz.getVisitorInfo();
        return visitorInfo instanceof String ? (String)visitorInfo : null;
    }

    private class MyKeepCollector
    implements ClassVisitor {
        private MyKeepCollector() {
        }

        public void visitProgramClass(ProgramClass programClass) {
            String newClassName = ClassObfuscator.newClassName(programClass);
            if (newClassName != null) {
                ClassObfuscator.this.classNamesToAvoid.add(ClassObfuscator.this.mixedCaseClassName(newClassName));
                if (ClassObfuscator.this.repackageClasses == null || !ClassObfuscator.this.allowAccessModification) {
                    String className = programClass.getName();
                    this.mapPackageName(className, newClassName, ClassObfuscator.this.repackageClasses == null && ClassObfuscator.this.flattenPackageHierarchy == null);
                }
            }
        }

        public void visitLibraryClass(LibraryClass libraryClass) {
        }

        private void mapPackageName(String className, String newClassName, boolean recursively) {
            String packagePrefix = ClassUtil.internalPackagePrefix(className);
            String newPackagePrefix = ClassUtil.internalPackagePrefix(newClassName);
            do {
                ClassObfuscator.this.packagePrefixMap.put(packagePrefix, newPackagePrefix);
                if (!recursively) break;
                packagePrefix = ClassUtil.internalPackagePrefix(packagePrefix);
                newPackagePrefix = ClassUtil.internalPackagePrefix(newPackagePrefix);
            } while (packagePrefix.length() > 0 && newPackagePrefix.length() > 0);
        }
    }
}

