/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import proguard.classfile.Clazz;
import proguard.classfile.Member;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMember;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.util.AccessUtil;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;

public class ClassOpener
extends SimplifiedVisitor
implements ConstantVisitor {
    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        this.fixPackageVisibility(clazz, stringConstant.referencedClass, stringConstant.referencedMember);
    }

    public void visitAnyRefConstant(Clazz clazz, RefConstant refConstant) {
        this.fixPackageVisibility(clazz, refConstant.referencedClass, refConstant.referencedMember);
    }

    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        int accessFlags;
        Clazz referencedClass = classConstant.referencedClass;
        if (referencedClass != null && this.isNotPublic(accessFlags = referencedClass.getAccessFlags()) && referencedClass instanceof ProgramClass && this.inDifferentPackages(clazz, referencedClass)) {
            ((ProgramClass)referencedClass).u2accessFlags = AccessUtil.replaceAccessFlags(accessFlags, 1);
        }
    }

    private void fixPackageVisibility(Clazz clazz, Clazz referencedClass, Member referencedMember) {
        int accessFlags;
        if (referencedMember != null && this.isNotPublic(accessFlags = referencedMember.getAccessFlags()) && referencedMember instanceof ProgramMember && this.inDifferentPackages(clazz, referencedClass)) {
            ((ProgramMember)referencedMember).u2accessFlags = AccessUtil.replaceAccessFlags(accessFlags, clazz.extends_(referencedClass) ? 4 : 1);
        }
    }

    private boolean inDifferentPackages(Clazz class1, Clazz class2) {
        return !ClassUtil.internalPackageName(class1.getName()).equals(ClassUtil.internalPackageName(class2.getName()));
    }

    private boolean isNotPublic(int accessFlags) {
        return (accessFlags & 1) == 0;
    }
}

