/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.obfuscate.ClassObfuscator;
import proguard.obfuscate.MemberObfuscator;

class NameMarker
implements ClassVisitor,
MemberVisitor {
    NameMarker() {
    }

    public void visitProgramClass(ProgramClass programClass) {
        this.keepClassName(programClass);
    }

    public void visitLibraryClass(LibraryClass libraryClass) {
        this.keepClassName(libraryClass);
    }

    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        this.keepFieldName(programClass, programField);
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        this.keepMethodName(programClass, programMethod);
    }

    public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
        this.keepFieldName(libraryClass, libraryField);
    }

    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        this.keepMethodName(libraryClass, libraryMethod);
    }

    public void keepClassName(Clazz clazz) {
        ClassObfuscator.setNewClassName(clazz, clazz.getName());
    }

    private void keepFieldName(Clazz clazz, Field field) {
        MemberObfuscator.setFixedNewMemberName(field, field.getName(clazz));
    }

    private void keepMethodName(Clazz clazz, Method method) {
        String name = method.getName(clazz);
        if (!name.equals("<clinit>") && !name.equals("<init>")) {
            MemberObfuscator.setFixedNewMemberName(method, method.getName(clazz));
        }
    }
}

