/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import proguard.ClassSpecificationVisitorFactory;
import proguard.Configuration;
import proguard.classfile.ClassPool;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeNameFilter;
import proguard.classfile.attribute.visitor.RequiredAttributeFilter;
import proguard.classfile.constant.visitor.AllConstantVisitor;
import proguard.classfile.editor.ClassReferenceFixer;
import proguard.classfile.editor.MemberReferenceFixer;
import proguard.classfile.util.MethodLinker;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.AllMemberVisitor;
import proguard.classfile.visitor.BottomClassFilter;
import proguard.classfile.visitor.ClassCleaner;
import proguard.classfile.visitor.ClassHierarchyTraveler;
import proguard.classfile.visitor.ClassPoolVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberAccessFilter;
import proguard.classfile.visitor.MultiClassVisitor;
import proguard.obfuscate.AttributeShrinker;
import proguard.obfuscate.AttributeUsageMarker;
import proguard.obfuscate.ClassObfuscator;
import proguard.obfuscate.ClassOpener;
import proguard.obfuscate.ClassRenamer;
import proguard.obfuscate.DictionaryNameFactory;
import proguard.obfuscate.MapCleaner;
import proguard.obfuscate.MappingKeeper;
import proguard.obfuscate.MappingPrinter;
import proguard.obfuscate.MappingProcessor;
import proguard.obfuscate.MappingReader;
import proguard.obfuscate.MemberNameCollector;
import proguard.obfuscate.MemberNameConflictFixer;
import proguard.obfuscate.MemberObfuscator;
import proguard.obfuscate.MemberSpecialNameFilter;
import proguard.obfuscate.MultiMappingProcessor;
import proguard.obfuscate.NameAndTypeShrinker;
import proguard.obfuscate.NameAndTypeUsageMarker;
import proguard.obfuscate.NameFactory;
import proguard.obfuscate.NameMarker;
import proguard.obfuscate.SimpleNameFactory;
import proguard.obfuscate.SourceFileRenamer;
import proguard.obfuscate.SpecialNameFactory;
import proguard.obfuscate.Utf8Shrinker;
import proguard.obfuscate.Utf8UsageMarker;
import proguard.util.ListParser;
import proguard.util.NameParser;

public class Obfuscator {
    private final Configuration configuration;

    public Obfuscator(Configuration configuration) {
        this.configuration = configuration;
    }

    public void execute(ClassPool programClassPool, ClassPool libraryClassPool) throws IOException {
        int warningCount;
        if (this.configuration.keep == null && this.configuration.applyMapping == null && this.configuration.printMapping == null) {
            throw new IOException("You have to specify '-keep' options for the obfuscation step.");
        }
        programClassPool.classesAccept(new ClassCleaner());
        libraryClassPool.classesAccept(new ClassCleaner());
        ClassVisitor memberInfoLinker = this.configuration.useUniqueClassMemberNames ? new AllMemberVisitor(new MethodLinker()) : new BottomClassFilter(new MethodLinker());
        programClassPool.classesAccept(memberInfoLinker);
        libraryClassPool.classesAccept(memberInfoLinker);
        NameMarker nameMarker = new NameMarker();
        ClassPoolVisitor classPoolvisitor = ClassSpecificationVisitorFactory.createClassPoolVisitor(this.configuration.keep, nameMarker, nameMarker, false, false, true);
        programClassPool.accept(classPoolvisitor);
        libraryClassPool.accept(classPoolvisitor);
        libraryClassPool.classesAccept(nameMarker);
        libraryClassPool.classesAccept(new AllMemberVisitor(nameMarker));
        if (this.configuration.applyMapping != null) {
            int mappingWarningCount;
            WarningPrinter warningPrinter = this.configuration.warn ? new WarningPrinter(System.err) : null;
            MappingReader reader = new MappingReader(this.configuration.applyMapping);
            MultiMappingProcessor keeper = new MultiMappingProcessor(new MappingProcessor[]{new MappingKeeper(programClassPool, warningPrinter), new MappingKeeper(libraryClassPool, null)});
            reader.pump(keeper);
            if (warningPrinter != null && (mappingWarningCount = warningPrinter.getWarningCount()) > 0) {
                System.err.println("Warning: there were " + mappingWarningCount + " kept classes and class members that were remapped anyway.");
                System.err.println("         You should adapt your configuration or edit the mapping file.");
                if (!this.configuration.ignoreWarnings) {
                    System.err.println("         If you are sure this remapping won't hurt,");
                    System.err.println("         you could try your luck using the '-ignorewarnings' option.");
                    throw new IOException("Please correct the above warnings first.");
                }
            }
        }
        AttributeUsageMarker requiredAttributeUsageMarker = new AttributeUsageMarker();
        AttributeUsageMarker optionalAttributeUsageMarker = this.configuration.keepAttributes == null ? null : (this.configuration.keepAttributes.size() == 0 ? requiredAttributeUsageMarker : new AttributeNameFilter(new ListParser(new NameParser()).parse(this.configuration.keepAttributes), requiredAttributeUsageMarker));
        programClassPool.classesAccept(new AllAttributeVisitor(true, new RequiredAttributeFilter(requiredAttributeUsageMarker, optionalAttributeUsageMarker)));
        programClassPool.classesAccept(new AttributeShrinker());
        programClassPool.classesAccept(new ClassObfuscator(programClassPool, this.configuration.useMixedCaseClassNames, this.configuration.flattenPackageHierarchy, this.configuration.repackageClasses, this.configuration.allowAccessModification));
        NameFactory nameFactory = new SimpleNameFactory();
        if (this.configuration.obfuscationDictionary != null) {
            nameFactory = new DictionaryNameFactory(this.configuration.obfuscationDictionary, nameFactory);
        }
        WarningPrinter warningPrinter = this.configuration.warn ? new WarningPrinter(System.err) : null;
        HashMap descriptorMap = new HashMap();
        if (this.configuration.useUniqueClassMemberNames) {
            programClassPool.classesAccept(new AllMemberVisitor(new MemberNameCollector(this.configuration.overloadAggressively, descriptorMap)));
            programClassPool.classesAccept(new AllMemberVisitor(new MemberObfuscator(this.configuration.overloadAggressively, nameFactory, descriptorMap)));
        } else {
            programClassPool.classesAccept(new MultiClassVisitor(new ClassVisitor[]{new ClassHierarchyTraveler(true, false, false, true, new AllMemberVisitor(new MemberAccessFilter(2, 0, new MemberNameCollector(this.configuration.overloadAggressively, descriptorMap)))), new ClassHierarchyTraveler(true, true, true, true, new AllMemberVisitor(new MemberAccessFilter(0, 2, new MemberNameCollector(this.configuration.overloadAggressively, descriptorMap)))), new AllMemberVisitor(new MemberAccessFilter(0, 2, new MemberObfuscator(this.configuration.overloadAggressively, nameFactory, descriptorMap))), new MapCleaner(descriptorMap)}));
            programClassPool.classesAccept(new MultiClassVisitor(new ClassVisitor[]{new AllMemberVisitor(new MemberNameCollector(this.configuration.overloadAggressively, descriptorMap)), new ClassHierarchyTraveler(false, true, true, false, new AllMemberVisitor(new MemberAccessFilter(0, 2, new MemberNameCollector(this.configuration.overloadAggressively, descriptorMap)))), new AllMemberVisitor(new MemberAccessFilter(2, 0, new MemberObfuscator(this.configuration.overloadAggressively, nameFactory, descriptorMap))), new MapCleaner(descriptorMap)}));
        }
        SpecialNameFactory specialNameFactory = new SpecialNameFactory(new SimpleNameFactory());
        HashMap specialDescriptorMap = new HashMap();
        programClassPool.classesAccept(new AllMemberVisitor(new MemberSpecialNameFilter(new MemberNameCollector(this.configuration.overloadAggressively, specialDescriptorMap))));
        libraryClassPool.classesAccept(new AllMemberVisitor(new MemberSpecialNameFilter(new MemberNameCollector(this.configuration.overloadAggressively, specialDescriptorMap))));
        programClassPool.classesAccept(new MultiClassVisitor(new ClassVisitor[]{new ClassHierarchyTraveler(true, false, false, true, new AllMemberVisitor(new MemberAccessFilter(2, 0, new MemberNameCollector(this.configuration.overloadAggressively, descriptorMap)))), new ClassHierarchyTraveler(true, true, true, false, new AllMemberVisitor(new MemberAccessFilter(0, 2, new MemberNameCollector(this.configuration.overloadAggressively, descriptorMap)))), new ClassHierarchyTraveler(true, true, true, false, new AllMemberVisitor(new MemberAccessFilter(0, 2, new MemberNameConflictFixer(this.configuration.overloadAggressively, descriptorMap, warningPrinter, new MemberObfuscator(this.configuration.overloadAggressively, specialNameFactory, specialDescriptorMap))))), new MapCleaner(descriptorMap)}));
        programClassPool.classesAccept(new MultiClassVisitor(new ClassVisitor[]{new AllMemberVisitor(new MemberNameCollector(this.configuration.overloadAggressively, descriptorMap)), new ClassHierarchyTraveler(false, true, true, false, new AllMemberVisitor(new MemberAccessFilter(0, 2, new MemberNameCollector(this.configuration.overloadAggressively, descriptorMap)))), new AllMemberVisitor(new MemberAccessFilter(2, 0, new MemberNameConflictFixer(this.configuration.overloadAggressively, descriptorMap, warningPrinter, new MemberObfuscator(this.configuration.overloadAggressively, specialNameFactory, specialDescriptorMap)))), new MapCleaner(descriptorMap)}));
        if (warningPrinter != null && (warningCount = warningPrinter.getWarningCount()) > 0) {
            System.err.println("Warning: there were " + warningCount + " conflicting class member name mappings.");
            System.err.println("         Your configuration may be inconsistent.");
            if (!this.configuration.ignoreWarnings) {
                System.err.println("         If you are sure the conflicts are harmless,");
                System.err.println("         you could try your luck using the '-ignorewarnings' option.");
                throw new IOException("Please correct the above warnings first.");
            }
        }
        if (this.configuration.printMapping != null) {
            PrintStream ps = this.isFile(this.configuration.printMapping) ? new PrintStream(new BufferedOutputStream(new FileOutputStream(this.configuration.printMapping))) : System.out;
            programClassPool.classesAcceptAlphabetically(new MappingPrinter(ps));
            if (ps != System.out) {
                ps.close();
            }
        }
        programClassPool.classesAccept(new ClassRenamer());
        libraryClassPool.classesAccept(new ClassRenamer());
        programClassPool.classesAccept(new ClassReferenceFixer(false));
        libraryClassPool.classesAccept(new ClassReferenceFixer(false));
        programClassPool.classesAccept(new MemberReferenceFixer());
        if (this.configuration.repackageClasses != null && this.configuration.allowAccessModification) {
            programClassPool.classesAccept(new AllConstantVisitor(new ClassOpener()));
        }
        if (this.configuration.newSourceFileAttribute != null) {
            programClassPool.classesAccept(new SourceFileRenamer(this.configuration.newSourceFileAttribute));
        }
        programClassPool.classesAccept(new NameAndTypeUsageMarker());
        programClassPool.classesAccept(new NameAndTypeShrinker());
        programClassPool.classesAccept(new Utf8UsageMarker());
        programClassPool.classesAccept(new Utf8Shrinker());
    }

    private boolean isFile(File file) {
        return file.getPath().length() > 0;
    }
}

