/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.info;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryMethod;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.MemberVisitor;

public class ExceptionInstructionChecker
extends SimplifiedVisitor
implements InstructionVisitor,
ConstantVisitor,
MemberVisitor {
    private boolean mayThrowExceptions;

    public boolean mayThrowExceptions(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
        this.mayThrowExceptions = false;
        instruction.accept(clazz, method, codeAttribute, offset, this);
        return this.mayThrowExceptions;
    }

    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
    }

    public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SimpleInstruction simpleInstruction) {
        byte opcode = simpleInstruction.opcode;
        if (opcode == 108 || opcode == 109 || opcode == 112 || opcode == 113 || opcode == 46 || opcode == 47 || opcode == 48 || opcode == 49 || opcode == 50 || opcode == 51 || opcode == 52 || opcode == 53 || opcode == 79 || opcode == 80 || opcode == 81 || opcode == 82 || opcode == 83 || opcode == 84 || opcode == 85 || opcode == 86 || opcode == -68 || opcode == -66 || opcode == -65 || opcode == -62 || opcode == -61) {
            this.mayThrowExceptions = true;
        }
    }

    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
        byte opcode = constantInstruction.opcode;
        if (opcode == -78 || opcode == -77 || opcode == -76 || opcode == -75 || opcode == -74 || opcode == -73 || opcode == -72 || opcode == -71 || opcode == -69 || opcode == -67 || opcode == -64 || opcode == -59) {
            this.mayThrowExceptions = true;
        }
    }

    public void visitAnyMethodrefConstant(Clazz clazz, RefConstant refConstant) {
        Member referencedMember = refConstant.referencedMember;
        if (referencedMember == null) {
            this.mayThrowExceptions = true;
        } else {
            refConstant.referencedMemberAccept(this);
            if (!this.mayThrowExceptions) {
                Clazz referencedClass = refConstant.referencedClass;
                Method referencedMethod = (Method)referencedMember;
                referencedClass.methodImplementationsAccept(referencedMethod, false, this);
            }
        }
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
    }

    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
    }
}

