/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.info;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryMethod;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.optimize.info.MethodOptimizationInfo;
import proguard.optimize.info.VariableUsageMarker;

public class ParameterUsageMarker
extends SimplifiedVisitor
implements MemberVisitor {
    private static final boolean DEBUG = false;
    private final VariableUsageMarker variableUsageMarker = new VariableUsageMarker();

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        int parameterSize = ClassUtil.internalMethodParameterSize(programMethod.getDescriptor(programClass), programMethod.getAccessFlags());
        if (parameterSize > 0) {
            int accessFlags = programMethod.getAccessFlags();
            if ((accessFlags & 0x100) != 0) {
                ParameterUsageMarker.markUsedParameters(programMethod, -1L);
            } else if ((accessFlags & 0x400) != 0) {
                ParameterUsageMarker.markParameterUsed(programMethod, 0);
            } else {
                if ((accessFlags & 8) == 0 && ((accessFlags & 0x20) != 0 || programClass.mayHaveImplementations(programMethod) || programMethod.getName(programClass).equals("<init>"))) {
                    ParameterUsageMarker.markParameterUsed(programMethod, 0);
                }
                programMethod.attributesAccept(programClass, this.variableUsageMarker);
                for (int index = 0; index < parameterSize; ++index) {
                    if (!this.variableUsageMarker.isVariableUsed(index)) continue;
                    ParameterUsageMarker.markParameterUsed(programMethod, index);
                }
            }
        }
        ParameterUsageMarker.setParameterSize(programMethod, parameterSize);
    }

    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        if (libraryClass.mayHaveImplementations(libraryMethod)) {
            long usedParameters = -1L;
            ParameterUsageMarker.markUsedParameters(libraryMethod, usedParameters);
        }
    }

    private static void setParameterSize(Method method, int parameterSize) {
        MethodOptimizationInfo info = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        if (info != null) {
            info.setParameterSize(parameterSize);
        }
    }

    public static int getParameterSize(Method method) {
        MethodOptimizationInfo info = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        return info != null ? info.getParameterSize() : 0;
    }

    public static void markParameterUsed(Method method, int variableIndex) {
        MethodOptimizationInfo info = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        if (info != null) {
            info.setParameterUsed(variableIndex);
        }
    }

    public static void markUsedParameters(Method method, long usedParameters) {
        MethodOptimizationInfo info = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        if (info != null) {
            info.setUsedParameters(info.getUsedParameters() | usedParameters);
        }
    }

    public static boolean isParameterUsed(Method method, int variableIndex) {
        MethodOptimizationInfo info = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        return info == null || info.isParameterUsed(variableIndex);
    }

    public static long getUsedParameters(Method method) {
        MethodOptimizationInfo info = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        return info != null ? info.getUsedParameters() : -1L;
    }

    private int parameterMask(int parameterSize) {
        return (1 << parameterSize) - 1;
    }

    private int parameterSize(Clazz clazz, Method method) {
        return ClassUtil.internalMethodParameterSize(method.getDescriptor(clazz), method.getAccessFlags());
    }
}

