/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.info;

import proguard.classfile.Clazz;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.VisitorAccepter;
import proguard.classfile.util.AccessUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.optimize.KeepMarker;

public class SingleImplementationMarker
extends SimplifiedVisitor
implements ClassVisitor {
    private static final boolean DEBUG = false;
    private final boolean allowAccessModification;
    private final ClassVisitor extraClassVisitor;

    public SingleImplementationMarker(boolean allowAccessModification) {
        this(allowAccessModification, null);
    }

    public SingleImplementationMarker(boolean allowAccessModification, ClassVisitor extraClassVisitor) {
        this.allowAccessModification = allowAccessModification;
        this.extraClassVisitor = extraClassVisitor;
    }

    public void visitProgramClass(ProgramClass programClass) {
        if ((programClass.getAccessFlags() & 0x200) == 0 || KeepMarker.isKept(programClass)) {
            return;
        }
        Clazz[] subClasses = programClass.subClasses;
        if (subClasses == null || subClasses.length != 1) {
            return;
        }
        Clazz singleImplementationClass = subClasses[0];
        int singleImplementationAccessFlags = singleImplementationClass.getAccessFlags();
        if ((singleImplementationAccessFlags & 0x200) != 0) {
            singleImplementationClass.accept(this);
            singleImplementationClass = SingleImplementationMarker.singleImplementation(singleImplementationClass);
            if (singleImplementationClass == null) {
                return;
            }
            singleImplementationAccessFlags = singleImplementationClass.getAccessFlags();
        }
        for (int index = 0; index < programClass.u2methodsCount; ++index) {
            ProgramMethod method = programClass.methods[index];
            if ((method.getAccessFlags() & 8) != 0 || singleImplementationClass.findMethod(method.getName(programClass), method.getDescriptor(programClass)) != null) continue;
            return;
        }
        if (AccessUtil.accessLevel(singleImplementationAccessFlags) < AccessUtil.accessLevel(programClass.getAccessFlags())) {
            if (this.allowAccessModification) {
                ((ProgramClass)singleImplementationClass).u2accessFlags = AccessUtil.replaceAccessFlags(singleImplementationAccessFlags, programClass.getAccessFlags());
            } else {
                return;
            }
        }
        SingleImplementationMarker.markSingleImplementation(programClass, singleImplementationClass);
        if (this.extraClassVisitor != null) {
            singleImplementationClass.accept(this.extraClassVisitor);
        }
    }

    public static void markSingleImplementation(VisitorAccepter visitorAccepter, Clazz singleImplementation) {
        visitorAccepter.setVisitorInfo(singleImplementation);
    }

    public static Clazz singleImplementation(VisitorAccepter visitorAccepter) {
        return visitorAccepter != null && visitorAccepter.getVisitorInfo() instanceof Clazz ? (Clazz)visitorAccepter.getVisitorInfo() : null;
    }
}

