/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.peephole;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.ExceptionInfo;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.ExceptionInfoVisitor;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.MethodrefConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.SwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;

public class BranchTargetFinder
extends SimplifiedVisitor
implements AttributeVisitor,
InstructionVisitor,
ExceptionInfoVisitor,
ConstantVisitor {
    private static final boolean DEBUG = false;
    public static final int NONE = -2;
    public static final int AT_METHOD_ENTRY = -1;
    private static final short INSTRUCTION = 1;
    private static final short BRANCH_ORIGIN = 2;
    private static final short BRANCH_TARGET = 4;
    private static final short AFTER_BRANCH = 8;
    private static final short EXCEPTION_START = 16;
    private static final short EXCEPTION_END = 32;
    private static final short EXCEPTION_HANDLER = 64;
    private static final short SUBROUTINE_INVOCATION = 128;
    private static final short SUBROUTINE_RETURNING = 256;
    private static final int MAXIMUM_CREATION_OFFSETS = 32;
    private short[] instructionMarks = new short[1025];
    private int[] subroutineStarts = new int[1024];
    private int[] subroutineEnds = new int[1024];
    private int[] creationOffsets = new int[1024];
    private int[] initializationOffsets = new int[1024];
    private int superInitializationOffset;
    private int currentSubroutineStart;
    private int currentSubroutineEnd;
    private final int[] recentCreationOffsets = new int[32];
    private int recentCreationOffsetIndex;
    private boolean isInitializer;

    public boolean isInstruction(int offset) {
        return (this.instructionMarks[offset] & 1) != 0;
    }

    public boolean isTarget(int offset) {
        return offset == 0 || (this.instructionMarks[offset] & 0x74) != 0;
    }

    public boolean isBranchOrigin(int offset) {
        return (this.instructionMarks[offset] & 2) != 0;
    }

    public boolean isBranchTarget(int offset) {
        return (this.instructionMarks[offset] & 4) != 0;
    }

    public boolean isAfterBranch(int offset) {
        return (this.instructionMarks[offset] & 8) != 0;
    }

    public boolean isExceptionStart(int offset) {
        return (this.instructionMarks[offset] & 0x10) != 0;
    }

    public boolean isExceptionEnd(int offset) {
        return (this.instructionMarks[offset] & 0x20) != 0;
    }

    public boolean isExceptionHandler(int offset) {
        return (this.instructionMarks[offset] & 0x40) != 0;
    }

    public boolean isSubroutineInvocation(int offset) {
        return (this.instructionMarks[offset] & 0x80) != 0;
    }

    public boolean isSubroutineStart(int offset) {
        return this.subroutineStarts[offset] == offset;
    }

    public boolean isSubroutine(int offset) {
        return this.subroutineStarts[offset] != -2;
    }

    public boolean isSubroutineReturning(int offset) {
        return (this.instructionMarks[offset] & 0x100) != 0;
    }

    public int subroutineStart(int offset) {
        return this.subroutineStarts[offset];
    }

    public int subroutineEnd(int offset) {
        return this.subroutineEnds[offset];
    }

    public boolean isNew(int offset) {
        return this.initializationOffsets[offset] != -2;
    }

    public int initializationOffset(int offset) {
        return this.initializationOffsets[offset];
    }

    public boolean isInitializer() {
        return this.superInitializationOffset != -2;
    }

    public int superInitializationOffset() {
        return this.superInitializationOffset;
    }

    public boolean isInitializer(int offset) {
        return this.creationOffsets[offset] != -2;
    }

    public int creationOffset(int offset) {
        return this.creationOffsets[offset];
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        int index;
        int codeLength = codeAttribute.u4codeLength;
        if (this.subroutineStarts.length < codeLength) {
            this.instructionMarks = new short[codeLength + 1];
            this.subroutineStarts = new int[codeLength];
            this.subroutineEnds = new int[codeLength];
            this.creationOffsets = new int[codeLength];
            this.initializationOffsets = new int[codeLength];
            for (index = 0; index < codeLength; ++index) {
                this.subroutineStarts[index] = -2;
                this.subroutineEnds[index] = -2;
                this.creationOffsets[index] = -2;
                this.initializationOffsets[index] = -2;
            }
        } else {
            for (index = 0; index < codeLength; ++index) {
                this.instructionMarks[index] = 0;
                this.subroutineStarts[index] = -2;
                this.subroutineEnds[index] = -2;
                this.creationOffsets[index] = -2;
                this.initializationOffsets[index] = -2;
            }
            this.instructionMarks[codeLength] = 0;
        }
        this.superInitializationOffset = -2;
        this.currentSubroutineStart = -2;
        this.currentSubroutineEnd = -2;
        this.recentCreationOffsetIndex = 0;
        if (method.getName(clazz).equals("<init>")) {
            this.recentCreationOffsets[this.recentCreationOffsetIndex++] = -1;
        }
        this.instructionMarks[codeLength] = 4;
        codeAttribute.instructionsAccept(clazz, method, this);
        codeAttribute.exceptionsAccept(clazz, method, this);
        int subroutineStart = -2;
        int subroutineEnd = codeLength;
        boolean subroutineReturning = false;
        for (int index2 = codeLength - 1; index2 >= 0; --index2) {
            if (!this.isInstruction(index2)) continue;
            if (this.subroutineStarts[index2] != -2) {
                subroutineStart = this.subroutineStarts[index2];
            } else if (subroutineStart != -2) {
                this.subroutineStarts[index2] = subroutineStart;
            }
            if (this.isSubroutineStart(index2)) {
                subroutineStart = -2;
            }
            if (this.isSubroutine(index2)) {
                this.subroutineEnds[index2] = subroutineEnd;
                if (this.isSubroutineReturning(index2)) {
                    subroutineReturning = true;
                    continue;
                }
                if (!subroutineReturning) continue;
                int n = index2;
                this.instructionMarks[n] = (short)(this.instructionMarks[n] | 0x100);
                continue;
            }
            subroutineEnd = index2;
            subroutineReturning = false;
        }
    }

    public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SimpleInstruction simpleInstruction) {
        int n = offset;
        this.instructionMarks[n] = (short)(this.instructionMarks[n] | 1);
        this.checkSubroutine(offset);
        byte opcode = simpleInstruction.opcode;
        if (opcode == -84 || opcode == -83 || opcode == -82 || opcode == -81 || opcode == -80 || opcode == -65) {
            this.markBranchOrigin(offset);
            this.markAfterBranchOrigin(offset + simpleInstruction.length(offset));
        }
    }

    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
        int n = offset;
        this.instructionMarks[n] = (short)(this.instructionMarks[n] | 1);
        this.checkSubroutine(offset);
        if (constantInstruction.opcode == -69) {
            this.recentCreationOffsets[this.recentCreationOffsetIndex++] = offset;
        } else {
            this.isInitializer = false;
            clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
            if (this.isInitializer) {
                int recentCreationOffset;
                this.creationOffsets[offset] = recentCreationOffset = this.recentCreationOffsets[--this.recentCreationOffsetIndex];
                if (recentCreationOffset == -1) {
                    this.superInitializationOffset = offset;
                } else {
                    this.initializationOffsets[recentCreationOffset] = offset;
                }
            }
        }
    }

    public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, VariableInstruction variableInstruction) {
        int n = offset;
        this.instructionMarks[n] = (short)(this.instructionMarks[n] | 1);
        this.checkSubroutine(offset);
        if (variableInstruction.opcode == -87) {
            this.markBranchOrigin(offset);
            int n2 = offset;
            this.instructionMarks[n2] = (short)(this.instructionMarks[n2] | 0x100);
            this.markAfterBranchOrigin(offset + variableInstruction.length(offset));
        }
    }

    public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, BranchInstruction branchInstruction) {
        this.markBranchOrigin(offset);
        this.checkSubroutine(offset);
        this.markBranchTarget(offset, branchInstruction.branchOffset);
        byte opcode = branchInstruction.opcode;
        if (opcode == -88 || opcode == -55) {
            int targetOffset;
            int n = offset;
            this.instructionMarks[n] = (short)(this.instructionMarks[n] | 0x80);
            this.subroutineStarts[targetOffset] = targetOffset = offset + branchInstruction.branchOffset;
        } else if (opcode == -89 || opcode == -56) {
            this.markAfterBranchOrigin(offset + branchInstruction.length(offset));
        }
    }

    public void visitAnySwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SwitchInstruction switchInstruction) {
        this.markBranchOrigin(offset);
        this.checkSubroutine(offset);
        this.markBranchTarget(offset, switchInstruction.defaultOffset);
        this.markBranchTargets(offset, switchInstruction.jumpOffsets);
        this.markAfterBranchOrigin(offset + switchInstruction.length(offset));
    }

    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    public void visitMethodrefConstant(Clazz clazz, MethodrefConstant methodrefConstant) {
        this.isInitializer = methodrefConstant.getName(clazz).equals("<init>");
    }

    public void visitExceptionInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, ExceptionInfo exceptionInfo) {
        int n = exceptionInfo.u2startPC;
        this.instructionMarks[n] = (short)(this.instructionMarks[n] | 0x10);
        int n2 = exceptionInfo.u2endPC;
        this.instructionMarks[n2] = (short)(this.instructionMarks[n2] | 0x20);
        int n3 = exceptionInfo.u2handlerPC;
        this.instructionMarks[n3] = (short)(this.instructionMarks[n3] | 0x40);
    }

    private void markBranchTargets(int offset, int[] jumpOffsets) {
        for (int index = 0; index < jumpOffsets.length; ++index) {
            this.markBranchTarget(offset, jumpOffsets[index]);
        }
    }

    private void markBranchOrigin(int offset) {
        int n = offset;
        this.instructionMarks[n] = (short)(this.instructionMarks[n] | 3);
    }

    private void markBranchTarget(int offset, int jumpOffset) {
        int targetOffset;
        int n = targetOffset = offset + jumpOffset;
        this.instructionMarks[n] = (short)(this.instructionMarks[n] | 4);
        if (this.isSubroutine(offset)) {
            this.subroutineStarts[targetOffset] = this.currentSubroutineStart;
            if (this.currentSubroutineEnd < targetOffset) {
                this.currentSubroutineEnd = targetOffset;
            }
        }
    }

    private void markAfterBranchOrigin(int nextOffset) {
        int n = nextOffset;
        this.instructionMarks[n] = (short)(this.instructionMarks[n] | 8);
        if (this.currentSubroutineEnd <= nextOffset) {
            this.currentSubroutineStart = -2;
        }
    }

    private void checkSubroutine(int offset) {
        if (this.isSubroutine(offset)) {
            this.currentSubroutineStart = this.subroutineStarts[offset];
        } else {
            this.subroutineStarts[offset] = this.currentSubroutineStart;
        }
    }
}

