/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.peephole;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.LookUpSwitchInstruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.TableSwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.InstructionSequenceMatcher;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.optimize.peephole.BranchTargetFinder;

public class InstructionSequenceReplacer
extends SimplifiedVisitor
implements InstructionVisitor,
ConstantVisitor {
    private static final boolean DEBUG = false;
    private final InstructionSequenceMatcher instructionSequenceMatcher;
    private final Instruction[] replacementInstructions;
    private final BranchTargetFinder branchTargetFinder;
    private final CodeAttributeEditor codeAttributeEditor;
    private final InstructionVisitor extraInstructionVisitor;
    private final MyReplacementInstructionFactory replacementInstructionFactory = new MyReplacementInstructionFactory();

    public InstructionSequenceReplacer(Constant[] patternConstants, Instruction[] patternInstructions, Instruction[] replacementInstructions, BranchTargetFinder branchTargetFinder, CodeAttributeEditor codeAttributeEditor) {
        this(patternConstants, patternInstructions, replacementInstructions, branchTargetFinder, codeAttributeEditor, null);
    }

    public InstructionSequenceReplacer(Constant[] patternConstants, Instruction[] patternInstructions, Instruction[] replacementInstructions, BranchTargetFinder branchTargetFinder, CodeAttributeEditor codeAttributeEditor, InstructionVisitor extraInstructionVisitor) {
        this.instructionSequenceMatcher = new InstructionSequenceMatcher(patternConstants, patternInstructions);
        this.replacementInstructions = replacementInstructions;
        this.branchTargetFinder = branchTargetFinder;
        this.codeAttributeEditor = codeAttributeEditor;
        this.extraInstructionVisitor = extraInstructionVisitor;
    }

    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
        if (this.branchTargetFinder.isTarget(offset) || this.codeAttributeEditor.isModified(offset)) {
            this.instructionSequenceMatcher.reset();
        }
        instruction.accept(clazz, method, codeAttribute, offset, this.instructionSequenceMatcher);
        if (this.instructionSequenceMatcher.isMatching() && this.matchedInstructionsUnmodified()) {
            int index;
            for (index = 0; index < this.replacementInstructions.length; ++index) {
                this.codeAttributeEditor.replaceInstruction(this.instructionSequenceMatcher.matchedInstructionOffset(index), this.replacementInstructionFactory.create(index).shrink());
            }
            for (index = this.replacementInstructions.length; index < this.instructionSequenceMatcher.instructionCount(); ++index) {
                this.codeAttributeEditor.deleteInstruction(this.instructionSequenceMatcher.matchedInstructionOffset(index));
            }
            if (this.extraInstructionVisitor != null) {
                instruction.accept(clazz, method, codeAttribute, offset, this.extraInstructionVisitor);
            }
        }
    }

    private boolean matchedInstructionsUnmodified() {
        for (int index = 0; index < this.instructionSequenceMatcher.instructionCount(); ++index) {
            if (!this.codeAttributeEditor.isModified(this.instructionSequenceMatcher.matchedInstructionOffset(index))) continue;
            return false;
        }
        return true;
    }

    private class MyReplacementInstructionFactory
    implements InstructionVisitor {
        private Instruction replacementInstruction;

        private MyReplacementInstructionFactory() {
        }

        public Instruction create(int index) {
            InstructionSequenceReplacer.this.replacementInstructions[index].accept(null, null, null, InstructionSequenceReplacer.this.instructionSequenceMatcher.matchedInstructionOffset(index), this);
            return this.replacementInstruction.shrink();
        }

        public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SimpleInstruction simpleInstruction) {
            this.replacementInstruction = new SimpleInstruction(simpleInstruction.opcode, InstructionSequenceReplacer.this.instructionSequenceMatcher.matchedArgument(simpleInstruction.constant));
        }

        public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, VariableInstruction variableInstruction) {
            this.replacementInstruction = new VariableInstruction(variableInstruction.opcode, InstructionSequenceReplacer.this.instructionSequenceMatcher.matchedArgument(variableInstruction.variableIndex), InstructionSequenceReplacer.this.instructionSequenceMatcher.matchedArgument(variableInstruction.constant));
        }

        public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
            this.replacementInstruction = new ConstantInstruction(constantInstruction.opcode, InstructionSequenceReplacer.this.instructionSequenceMatcher.matchedConstantIndex(constantInstruction.constantIndex), InstructionSequenceReplacer.this.instructionSequenceMatcher.matchedArgument(constantInstruction.constant));
        }

        public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, BranchInstruction branchInstruction) {
            this.replacementInstruction = new BranchInstruction(branchInstruction.opcode, InstructionSequenceReplacer.this.instructionSequenceMatcher.matchedBranchOffset(offset, branchInstruction.branchOffset));
        }

        public void visitTableSwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, TableSwitchInstruction tableSwitchInstruction) {
            this.replacementInstruction = new TableSwitchInstruction(tableSwitchInstruction.opcode, InstructionSequenceReplacer.this.instructionSequenceMatcher.matchedBranchOffset(offset, tableSwitchInstruction.defaultOffset), InstructionSequenceReplacer.this.instructionSequenceMatcher.matchedArgument(tableSwitchInstruction.lowCase), InstructionSequenceReplacer.this.instructionSequenceMatcher.matchedArgument(tableSwitchInstruction.highCase), InstructionSequenceReplacer.this.instructionSequenceMatcher.matchedJumpOffsets(offset, tableSwitchInstruction.jumpOffsets));
        }

        public void visitLookUpSwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, LookUpSwitchInstruction lookUpSwitchInstruction) {
            this.replacementInstruction = new LookUpSwitchInstruction(lookUpSwitchInstruction.opcode, InstructionSequenceReplacer.this.instructionSequenceMatcher.matchedBranchOffset(offset, lookUpSwitchInstruction.defaultOffset), InstructionSequenceReplacer.this.instructionSequenceMatcher.matchedArguments(lookUpSwitchInstruction.cases), InstructionSequenceReplacer.this.instructionSequenceMatcher.matchedJumpOffsets(offset, lookUpSwitchInstruction.jumpOffsets));
        }
    }
}

