/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.peephole;

import java.util.Stack;
import proguard.classfile.Clazz;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.ExceptionInfo;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.ExceptionInfoVisitor;
import proguard.classfile.attribute.visitor.StackSizeComputer;
import proguard.classfile.constant.InterfaceMethodrefConstant;
import proguard.classfile.constant.MethodrefConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.CodeAttributeComposer;
import proguard.classfile.editor.ConstantAdder;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.InternalTypeEnumeration;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.optimize.info.AccessMethodMarker;
import proguard.optimize.info.BackwardBranchMarker;
import proguard.optimize.info.CatchExceptionMarker;
import proguard.optimize.info.MethodInvocationMarker;
import proguard.optimize.info.SuperInvocationMarker;

public class MethodInliner
extends SimplifiedVisitor
implements AttributeVisitor,
InstructionVisitor,
ExceptionInfoVisitor,
ConstantVisitor,
MemberVisitor {
    private static final int MAXIMUM_INLINED_CODE_LENGTH = Integer.parseInt(System.getProperty("maximum.inlined.code.length", "8"));
    private static final int MAXIMUM_RESULTING_CODE_LENGTH_JSE = Integer.parseInt(System.getProperty("maximum.resulting.code.length", "8000"));
    private static final int MAXIMUM_RESULTING_CODE_LENGTH_JME = Integer.parseInt(System.getProperty("maximum.resulting.code.length", "2000"));
    private static final int MAXIMUM_CODE_EXPANSION = 2;
    private static final int MAXIMUM_EXTRA_CODE_LENGTH = 128;
    private static final boolean DEBUG = false;
    private final boolean microEdition;
    private final boolean allowAccessModification;
    private final boolean inlineSingleInvocations;
    private final InstructionVisitor extraInlinedInvocationVisitor;
    private final CodeAttributeComposer codeAttributeComposer = new CodeAttributeComposer();
    private final AccessMethodMarker accessMethodMarker = new AccessMethodMarker();
    private final CatchExceptionMarker catchExceptionMarker = new CatchExceptionMarker();
    private final ConstantAdder constantAdder = new ConstantAdder();
    private final StackSizeComputer stackSizeComputer = new StackSizeComputer();
    private ProgramClass targetClass;
    private ProgramMethod targetMethod;
    private int estimatedResultingCodeLength;
    private boolean inlining;
    private Stack inliningMethods = new Stack();
    private boolean emptyInvokingStack;
    private int uninitializedObjectCount;
    private int variableOffset;
    private boolean inlined;
    private boolean inlinedAny;

    public MethodInliner(boolean microEdition, boolean allowAccessModification, boolean inlineSingleInvocations) {
        this(microEdition, allowAccessModification, inlineSingleInvocations, null);
    }

    public MethodInliner(boolean microEdition, boolean allowAccessModification, boolean inlineSingleInvocations, InstructionVisitor extraInlinedInvocationVisitor) {
        this.microEdition = microEdition;
        this.allowAccessModification = allowAccessModification;
        this.inlineSingleInvocations = inlineSingleInvocations;
        this.extraInlinedInvocationVisitor = extraInlinedInvocationVisitor;
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        if (!this.inlining) {
            this.targetClass = (ProgramClass)clazz;
            this.targetMethod = (ProgramMethod)method;
            this.estimatedResultingCodeLength = codeAttribute.u4codeLength;
            this.inliningMethods.clear();
            this.uninitializedObjectCount = method.getName(clazz).equals("<init>") ? 1 : 0;
            this.inlinedAny = false;
            this.codeAttributeComposer.reset();
            this.constantAdder.setTargetClass(this.targetClass);
            this.stackSizeComputer.visitCodeAttribute(clazz, method, codeAttribute);
            this.copyCode(clazz, method, codeAttribute);
            this.targetClass = null;
            this.targetMethod = null;
            this.constantAdder.setTargetClass(null);
            if (this.inlinedAny) {
                this.codeAttributeComposer.visitCodeAttribute(clazz, method, codeAttribute);
                codeAttribute.instructionsAccept(clazz, method, this.accessMethodMarker);
                this.catchExceptionMarker.visitCodeAttribute(clazz, method, codeAttribute);
            }
        } else if ((this.inlineSingleInvocations ? MethodInvocationMarker.getInvocationCount(method) == 1 : codeAttribute.u4codeLength <= MAXIMUM_INLINED_CODE_LENGTH) && this.estimatedResultingCodeLength + codeAttribute.u4codeLength < (this.microEdition ? MAXIMUM_RESULTING_CODE_LENGTH_JME : MAXIMUM_RESULTING_CODE_LENGTH_JSE)) {
            this.estimatedResultingCodeLength += codeAttribute.u4codeLength;
            this.storeParameters(clazz, method);
            this.copyCode(clazz, method, codeAttribute);
            this.inlined = true;
            this.inlinedAny = true;
        }
    }

    private void storeParameters(Clazz clazz, Method method) {
        String parameterType;
        int parameterIndex;
        String descriptor = method.getDescriptor(clazz);
        boolean isStatic = (method.getAccessFlags() & 8) != 0;
        int parameterCount = ClassUtil.internalMethodParameterCount(descriptor);
        int parameterSize = ClassUtil.internalMethodParameterSize(descriptor);
        int parameterOffset = isStatic ? 0 : 1;
        String[] parameterTypes = new String[parameterSize];
        InternalTypeEnumeration internalTypeEnumeration = new InternalTypeEnumeration(descriptor);
        for (parameterIndex = 0; parameterIndex < parameterSize; ++parameterIndex) {
            parameterTypes[parameterIndex] = parameterType = internalTypeEnumeration.nextType();
            if (ClassUtil.internalTypeSize(parameterType) != 2) continue;
            ++parameterIndex;
        }
        this.codeAttributeComposer.beginCodeFragment((parameterOffset + parameterCount) * 4);
        for (parameterIndex = parameterSize - 1; parameterIndex >= 0; --parameterIndex) {
            byte opcode;
            parameterType = parameterTypes[parameterIndex];
            if (parameterType == null) continue;
            switch (parameterType.charAt(0)) {
                case 'B': 
                case 'C': 
                case 'I': 
                case 'S': 
                case 'Z': {
                    opcode = 54;
                    break;
                }
                case 'J': {
                    opcode = 55;
                    break;
                }
                case 'F': {
                    opcode = 56;
                    break;
                }
                case 'D': {
                    opcode = 57;
                    break;
                }
                default: {
                    opcode = 58;
                }
            }
            this.codeAttributeComposer.appendInstruction(parameterSize - parameterIndex - 1, new VariableInstruction(opcode, this.variableOffset + parameterOffset + parameterIndex).shrink());
        }
        if (!isStatic) {
            this.codeAttributeComposer.appendInstruction(parameterSize, new VariableInstruction(58, this.variableOffset).shrink());
        }
        this.codeAttributeComposer.endCodeFragment();
    }

    private void copyCode(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        this.codeAttributeComposer.beginCodeFragment(codeAttribute.u4codeLength * 2 + 128);
        codeAttribute.instructionsAccept(clazz, method, this);
        codeAttribute.exceptionsAccept(clazz, method, this);
        this.codeAttributeComposer.appendLabel(codeAttribute.u4codeLength);
        this.codeAttributeComposer.endCodeFragment();
    }

    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
        this.codeAttributeComposer.appendInstruction(offset, instruction.shrink());
    }

    public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SimpleInstruction simpleInstruction) {
        if (this.inlining) {
            switch (simpleInstruction.opcode) {
                case -84: 
                case -83: 
                case -82: 
                case -81: 
                case -80: 
                case -79: {
                    if (offset < codeAttribute.u4codeLength - 1) {
                        BranchInstruction branchInstruction = new BranchInstruction(-56, codeAttribute.u4codeLength - offset);
                        this.codeAttributeComposer.appendInstruction(offset, ((Instruction)branchInstruction).shrink());
                    } else {
                        this.codeAttributeComposer.appendLabel(offset);
                    }
                    return;
                }
            }
        }
        this.codeAttributeComposer.appendInstruction(offset, simpleInstruction.shrink());
    }

    public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, VariableInstruction variableInstruction) {
        if (this.inlining) {
            variableInstruction.variableIndex += this.variableOffset;
        }
        this.codeAttributeComposer.appendInstruction(offset, variableInstruction.shrink());
    }

    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
        switch (constantInstruction.opcode) {
            case -69: {
                ++this.uninitializedObjectCount;
                break;
            }
            case -74: 
            case -73: 
            case -72: 
            case -71: {
                this.inlined = false;
                this.codeAttributeComposer.appendLabel(offset);
                this.emptyInvokingStack = !this.inlining && this.stackSizeComputer.isReachable(offset) && this.stackSizeComputer.getStackSize(offset) == 0;
                this.variableOffset += codeAttribute.u2maxLocals;
                clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
                this.variableOffset -= codeAttribute.u2maxLocals;
                if (!this.inlined) break;
                if (this.extraInlinedInvocationVisitor != null) {
                    this.extraInlinedInvocationVisitor.visitConstantInstruction(clazz, method, codeAttribute, offset, constantInstruction);
                }
                return;
            }
        }
        if (this.inlining) {
            clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this.constantAdder);
            constantInstruction.constantIndex = this.constantAdder.getConstantIndex();
        }
        this.codeAttributeComposer.appendInstruction(offset, constantInstruction.shrink());
    }

    public void visitExceptionInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, ExceptionInfo exceptionInfo) {
        int catchType = exceptionInfo.u2catchType;
        if (this.inlining && catchType != 0) {
            clazz.constantPoolEntryAccept(catchType, this.constantAdder);
            catchType = this.constantAdder.getConstantIndex();
        }
        this.codeAttributeComposer.appendException(new ExceptionInfo(exceptionInfo.u2startPC, exceptionInfo.u2endPC, exceptionInfo.u2handlerPC, catchType));
    }

    public void visitInterfaceMethodrefConstant(Clazz clazz, InterfaceMethodrefConstant interfaceMethodrefConstant) {
    }

    public void visitMethodrefConstant(Clazz clazz, MethodrefConstant methodrefConstant) {
        methodrefConstant.referencedMemberAccept(this);
    }

    public void visitAnyMember(Clazz Clazz2, Member member) {
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        int accessFlags = programMethod.getAccessFlags();
        if (!((accessFlags & 0x1A) == 0 || (accessFlags & 0x720) != 0 || programMethod.getName(programClass).equals("<init>") || programMethod.equals(this.targetMethod) && programClass.equals(this.targetClass) || this.inliningMethods.contains(programMethod) || this.targetClass.u4version < programClass.u4version || SuperInvocationMarker.invokesSuperMethods(programMethod) && !programClass.equals(this.targetClass) || BackwardBranchMarker.branchesBackward(programMethod) && this.uninitializedObjectCount != 0 || !this.allowAccessModification && (AccessMethodMarker.accessesPrivateCode(programMethod) && !programClass.equals(this.targetClass) || AccessMethodMarker.accessesPackageCode(programMethod) && !ClassUtil.internalPackageName(programClass.getName()).equals(ClassUtil.internalPackageName(this.targetClass.getName()))) || AccessMethodMarker.accessesProtectedCode(programMethod) && !programClass.equals(this.targetClass) || CatchExceptionMarker.catchesExceptions(programMethod) && !this.emptyInvokingStack || !programClass.equals(this.targetClass) && programClass.findMethod("<clinit>", "()V") != null)) {
            boolean oldInlining = this.inlining;
            this.inlining = true;
            this.inliningMethods.push(programMethod);
            programMethod.attributesAccept(programClass, this);
            this.inlining = oldInlining;
            this.inliningMethods.pop();
        } else if (programMethod.getName(programClass).equals("<init>")) {
            --this.uninitializedObjectCount;
        }
    }
}

