/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.peephole;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionFactory;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.optimize.peephole.BranchTargetFinder;

public class PushPopRemover
extends SimplifiedVisitor
implements InstructionVisitor {
    private final BranchTargetFinder branchTargetFinder;
    private final CodeAttributeEditor codeAttributeEditor;
    private final InstructionVisitor extraInstructionVisitor;

    public PushPopRemover(BranchTargetFinder branchTargetFinder, CodeAttributeEditor codeAttributeEditor) {
        this(branchTargetFinder, codeAttributeEditor, null);
    }

    public PushPopRemover(BranchTargetFinder branchTargetFinder, CodeAttributeEditor codeAttributeEditor, InstructionVisitor extraInstructionVisitor) {
        this.branchTargetFinder = branchTargetFinder;
        this.codeAttributeEditor = codeAttributeEditor;
        this.extraInstructionVisitor = extraInstructionVisitor;
    }

    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
    }

    public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SimpleInstruction simpleInstruction) {
        switch (simpleInstruction.opcode) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 89: 
            case 92: {
                this.deleteWithSubsequentPop(clazz, method, codeAttribute, offset, simpleInstruction);
            }
        }
    }

    public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, VariableInstruction variableInstruction) {
        if (variableInstruction.isLoad() && variableInstruction.opcode != -87) {
            this.deleteWithSubsequentPop(clazz, method, codeAttribute, offset, variableInstruction);
        }
    }

    private void deleteWithSubsequentPop(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
        boolean isCategory2 = instruction.isCategory2();
        int nextOffset = offset + instruction.length(offset);
        if (!(this.codeAttributeEditor.isModified(offset) || this.codeAttributeEditor.isModified(nextOffset) || this.branchTargetFinder.isTarget(nextOffset))) {
            Instruction nextInstruction = InstructionFactory.create(codeAttribute.code, nextOffset);
            byte nextOpcode = nextInstruction.opcode;
            if ((nextOpcode == 87 || nextOpcode == 88) && nextInstruction.isCategory2() == isCategory2) {
                this.codeAttributeEditor.deleteInstruction(offset);
                this.codeAttributeEditor.deleteInstruction(nextOffset);
                if (this.extraInstructionVisitor != null) {
                    instruction.accept(clazz, method, codeAttribute, offset, this.extraInstructionVisitor);
                }
            }
        }
    }
}

