/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.peephole;

import proguard.classfile.Clazz;
import proguard.classfile.ProgramClass;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.FieldrefConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.optimize.info.SingleImplementationMarker;

public class SingleImplementationFixer
extends SimplifiedVisitor
implements ClassVisitor,
ConstantVisitor {
    private final ConstantPoolEditor constantPoolEditor = new ConstantPoolEditor();

    public void visitProgramClass(ProgramClass programClass) {
        Clazz singleImplementationClass = SingleImplementationMarker.singleImplementation(programClass);
        if (singleImplementationClass != null) {
            this.fixThisClassReference(programClass);
            this.fixInterfaceReference((ProgramClass)programClass.subClasses[0], programClass);
        }
        programClass.constantPoolEntriesAccept(this);
    }

    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    public void visitFieldrefConstant(Clazz clazz, FieldrefConstant fieldrefConstant) {
        Clazz singleImplementationClass = SingleImplementationMarker.singleImplementation(fieldrefConstant.referencedClass);
        if (singleImplementationClass != null) {
            this.fixFieldrefClassReference((ProgramClass)clazz, fieldrefConstant);
        }
    }

    private void fixThisClassReference(ProgramClass programClass) {
        int nameIndex = this.constantPoolEditor.addUtf8Constant(programClass, programClass.getName());
        programClass.u2thisClass = this.constantPoolEditor.addConstant(programClass, new ClassConstant(nameIndex, programClass));
    }

    private void fixInterfaceReference(ProgramClass programClass, ProgramClass interfaceClass) {
        String interfaceName = interfaceClass.getName();
        int interfacesCount = programClass.u2interfacesCount;
        for (int index = 0; index < interfacesCount; ++index) {
            if (!interfaceName.equals(programClass.getInterfaceName(index))) continue;
            int nameIndex = this.constantPoolEditor.addUtf8Constant(programClass, interfaceName);
            programClass.u2interfaces[index] = this.constantPoolEditor.addConstant(programClass, new ClassConstant(nameIndex, interfaceClass));
            break;
        }
    }

    private void fixFieldrefClassReference(ProgramClass programClass, FieldrefConstant fieldrefConstant) {
        Clazz referencedClass = fieldrefConstant.referencedClass;
        int nameIndex = this.constantPoolEditor.addUtf8Constant(programClass, fieldrefConstant.getClassName(programClass));
        fieldrefConstant.u2classIndex = this.constantPoolEditor.addConstant(programClass, new ClassConstant(nameIndex, referencedClass));
    }
}

