/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.peephole;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.LocalVariableInfo;
import proguard.classfile.attribute.LocalVariableTableAttribute;
import proguard.classfile.attribute.LocalVariableTypeInfo;
import proguard.classfile.attribute.LocalVariableTypeTableAttribute;
import proguard.classfile.attribute.SignatureAttribute;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.AnnotationDefaultAttribute;
import proguard.classfile.attribute.annotation.AnnotationElementValue;
import proguard.classfile.attribute.annotation.AnnotationsAttribute;
import proguard.classfile.attribute.annotation.ArrayElementValue;
import proguard.classfile.attribute.annotation.ClassElementValue;
import proguard.classfile.attribute.annotation.ConstantElementValue;
import proguard.classfile.attribute.annotation.EnumConstantElementValue;
import proguard.classfile.attribute.annotation.ParameterAnnotationsAttribute;
import proguard.classfile.attribute.annotation.visitor.AnnotationVisitor;
import proguard.classfile.attribute.annotation.visitor.ElementValueVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.LocalVariableInfoVisitor;
import proguard.classfile.attribute.visitor.LocalVariableTypeInfoVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.InterfaceMethodrefConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.optimize.info.SingleImplementationMarker;

public class SingleImplementationInliner
extends SimplifiedVisitor
implements ClassVisitor,
ConstantVisitor,
MemberVisitor,
AttributeVisitor,
LocalVariableInfoVisitor,
LocalVariableTypeInfoVisitor,
AnnotationVisitor,
ElementValueVisitor {
    public void visitProgramClass(ProgramClass programClass) {
        programClass.constantPoolEntriesAccept(this);
        programClass.fieldsAccept(this);
        programClass.methodsAccept(this);
        programClass.attributesAccept(this);
    }

    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        Clazz singleImplementationClass;
        if (stringConstant.referencedMember == null && (singleImplementationClass = SingleImplementationMarker.singleImplementation(stringConstant.referencedClass)) != null) {
            stringConstant.referencedClass = singleImplementationClass;
        }
    }

    public void visitInterfaceMethodrefConstant(Clazz clazz, InterfaceMethodrefConstant interfaceMethodrefConstant) {
        Clazz singleImplementationClass = SingleImplementationMarker.singleImplementation(interfaceMethodrefConstant.referencedClass);
        if (singleImplementationClass != null) {
            String name = interfaceMethodrefConstant.getName(clazz);
            String type = interfaceMethodrefConstant.getType(clazz);
            interfaceMethodrefConstant.referencedClass = singleImplementationClass;
            interfaceMethodrefConstant.referencedMember = singleImplementationClass.findMethod(name, type);
        }
    }

    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        Clazz singleImplementationClass = SingleImplementationMarker.singleImplementation(classConstant.referencedClass);
        if (singleImplementationClass != null) {
            classConstant.referencedClass = singleImplementationClass;
        }
    }

    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        Clazz singleImplementationClass = SingleImplementationMarker.singleImplementation(programField.referencedClass);
        if (singleImplementationClass != null) {
            programField.referencedClass = singleImplementationClass;
        }
        programField.attributesAccept(programClass, this);
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        this.updateReferencedClasses(programMethod.referencedClasses);
        programMethod.attributesAccept(programClass, this);
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        codeAttribute.attributesAccept(clazz, method, this);
    }

    public void visitLocalVariableTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTableAttribute localVariableTableAttribute) {
        localVariableTableAttribute.localVariablesAccept(clazz, method, codeAttribute, this);
    }

    public void visitLocalVariableTypeTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeTableAttribute localVariableTypeTableAttribute) {
        localVariableTypeTableAttribute.localVariablesAccept(clazz, method, codeAttribute, this);
    }

    public void visitSignatureAttribute(Clazz clazz, SignatureAttribute signatureAttribute) {
        this.updateReferencedClasses(signatureAttribute.referencedClasses);
    }

    public void visitAnyAnnotationsAttribute(Clazz clazz, AnnotationsAttribute annotationsAttribute) {
        annotationsAttribute.annotationsAccept(clazz, this);
    }

    public void visitAnyParameterAnnotationsAttribute(Clazz clazz, Method method, ParameterAnnotationsAttribute parameterAnnotationsAttribute) {
        parameterAnnotationsAttribute.annotationsAccept(clazz, method, this);
    }

    public void visitAnnotationDefaultAttribute(Clazz clazz, Method method, AnnotationDefaultAttribute annotationDefaultAttribute) {
        annotationDefaultAttribute.defaultValueAccept(clazz, this);
    }

    public void visitLocalVariableInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableInfo localVariableInfo) {
        Clazz singleImplementationClass = SingleImplementationMarker.singleImplementation(localVariableInfo.referencedClass);
        if (singleImplementationClass != null) {
            localVariableInfo.referencedClass = singleImplementationClass;
        }
    }

    public void visitLocalVariableTypeInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeInfo localVariableTypeInfo) {
        this.updateReferencedClasses(localVariableTypeInfo.referencedClasses);
    }

    public void visitAnnotation(Clazz clazz, Annotation annotation) {
        this.updateReferencedClasses(annotation.referencedClasses);
        annotation.elementValuesAccept(clazz, this);
    }

    public void visitConstantElementValue(Clazz clazz, Annotation annotation, ConstantElementValue constantElementValue) {
    }

    public void visitEnumConstantElementValue(Clazz clazz, Annotation annotation, EnumConstantElementValue enumConstantElementValue) {
        this.updateReferencedClasses(enumConstantElementValue.referencedClasses);
    }

    public void visitClassElementValue(Clazz clazz, Annotation annotation, ClassElementValue classElementValue) {
        this.updateReferencedClasses(classElementValue.referencedClasses);
    }

    public void visitAnnotationElementValue(Clazz clazz, Annotation annotation, AnnotationElementValue annotationElementValue) {
        annotationElementValue.annotationAccept(clazz, this);
    }

    public void visitArrayElementValue(Clazz clazz, Annotation annotation, ArrayElementValue arrayElementValue) {
        arrayElementValue.elementValuesAccept(clazz, annotation, this);
    }

    private void updateReferencedClasses(Clazz[] referencedClasses) {
        if (referencedClasses != null) {
            for (int index = 0; index < referencedClasses.length; ++index) {
                Clazz singleImplementationClass = SingleImplementationMarker.singleImplementation(referencedClasses[index]);
                if (singleImplementationClass == null) continue;
                referencedClasses[index] = singleImplementationClass;
            }
        }
    }
}

