/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.peephole;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionFactory;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.optimize.peephole.BranchTargetFinder;

public class StoreLoadReplacer
extends SimplifiedVisitor
implements InstructionVisitor {
    private final Instruction dupInstruction = new SimpleInstruction(89);
    private final Instruction dup2Instruction = new SimpleInstruction(92);
    private final BranchTargetFinder branchTargetFinder;
    private final CodeAttributeEditor codeAttributeEditor;
    private final InstructionVisitor extraInstructionVisitor;

    public StoreLoadReplacer(BranchTargetFinder branchTargetFinder, CodeAttributeEditor codeAttributeEditor) {
        this(branchTargetFinder, codeAttributeEditor, null);
    }

    public StoreLoadReplacer(BranchTargetFinder branchTargetFinder, CodeAttributeEditor codeAttributeEditor, InstructionVisitor extraInstructionVisitor) {
        this.branchTargetFinder = branchTargetFinder;
        this.codeAttributeEditor = codeAttributeEditor;
        this.extraInstructionVisitor = extraInstructionVisitor;
    }

    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
    }

    public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, VariableInstruction variableInstruction) {
        if (!variableInstruction.isLoad() && variableInstruction.opcode != -124) {
            Instruction nextInstruction;
            byte opcode = variableInstruction.opcode;
            int variableIndex = variableInstruction.variableIndex;
            int nextOffset = offset + variableInstruction.length(offset);
            if (!this.codeAttributeEditor.isModified(offset) && !this.codeAttributeEditor.isModified(nextOffset) && !this.branchTargetFinder.isTarget(nextOffset) && (nextInstruction = InstructionFactory.create(codeAttribute.code, nextOffset)) instanceof VariableInstruction && (variableInstruction = (VariableInstruction)nextInstruction).isLoad() && variableInstruction.opcode != -87 && variableInstruction.variableIndex == variableIndex) {
                Instruction matchingDupInstruction = variableInstruction.isCategory2() ? this.dup2Instruction : this.dupInstruction;
                this.codeAttributeEditor.replaceInstruction(offset, matchingDupInstruction);
                Instruction storeInstruction = new VariableInstruction(opcode, variableInstruction.variableIndex).shrink();
                this.codeAttributeEditor.replaceInstruction(nextOffset, storeInstruction);
                if (this.extraInstructionVisitor != null) {
                    this.extraInstructionVisitor.visitVariableInstruction(clazz, method, codeAttribute, offset, variableInstruction);
                }
            }
        }
    }
}

