/*
 * Decompiled with CFR 0.152.
 */
package proguard.shrink;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Utf8Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.shrink.UsageMarker;

public class InterfaceUsageMarker
extends SimplifiedVisitor
implements ClassVisitor,
ConstantVisitor {
    private final UsageMarker usageMarker;
    private boolean used;

    public InterfaceUsageMarker(UsageMarker usageMarker) {
        this.usageMarker = usageMarker;
    }

    public void visitProgramClass(ProgramClass programClass) {
        boolean classUsed = this.usageMarker.isUsed(programClass);
        boolean classPossiblyUsed = this.usageMarker.isPossiblyUsed(programClass);
        if (classUsed || classPossiblyUsed) {
            for (int index = 0; index < programClass.u2interfacesCount; ++index) {
                this.markConstant(programClass, programClass.u2interfaces[index]);
                classUsed |= this.used;
            }
            if (classPossiblyUsed) {
                if (classUsed) {
                    this.usageMarker.markAsUsed(programClass);
                    this.markConstant(programClass, programClass.u2thisClass);
                    if (programClass.u2superClass != 0) {
                        this.markConstant(programClass, programClass.u2superClass);
                    }
                } else {
                    this.usageMarker.markAsUnused(programClass);
                }
            }
        }
        this.used = classUsed;
    }

    public void visitLibraryClass(LibraryClass libraryClass) {
        this.used = true;
    }

    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        boolean classUsed = this.usageMarker.isUsed(classConstant);
        if (!classUsed) {
            classConstant.referencedClassAccept(this);
            classUsed = this.used;
            if (classUsed) {
                this.usageMarker.markAsUsed(classConstant);
                this.markConstant(clazz, classConstant.u2nameIndex);
            }
        }
        this.used = classUsed;
    }

    public void visitUtf8Constant(Clazz clazz, Utf8Constant utf8Constant) {
        if (!this.usageMarker.isUsed(utf8Constant)) {
            this.usageMarker.markAsUsed(utf8Constant);
        }
    }

    private void markConstant(Clazz clazz, int index) {
        clazz.constantPoolEntryAccept(index, this);
    }
}

