/*
 * Decompiled with CFR 0.152.
 */
package proguard.shrink;

import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.VisitorAccepter;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.ConstantValueAttribute;
import proguard.classfile.attribute.DeprecatedAttribute;
import proguard.classfile.attribute.EnclosingMethodAttribute;
import proguard.classfile.attribute.ExceptionInfo;
import proguard.classfile.attribute.ExceptionsAttribute;
import proguard.classfile.attribute.InnerClassesAttribute;
import proguard.classfile.attribute.InnerClassesInfo;
import proguard.classfile.attribute.LineNumberTableAttribute;
import proguard.classfile.attribute.LocalVariableInfo;
import proguard.classfile.attribute.LocalVariableTableAttribute;
import proguard.classfile.attribute.LocalVariableTypeInfo;
import proguard.classfile.attribute.LocalVariableTypeTableAttribute;
import proguard.classfile.attribute.SignatureAttribute;
import proguard.classfile.attribute.SourceDirAttribute;
import proguard.classfile.attribute.SourceFileAttribute;
import proguard.classfile.attribute.SyntheticAttribute;
import proguard.classfile.attribute.UnknownAttribute;
import proguard.classfile.attribute.annotation.AnnotationDefaultAttribute;
import proguard.classfile.attribute.annotation.AnnotationsAttribute;
import proguard.classfile.attribute.annotation.ParameterAnnotationsAttribute;
import proguard.classfile.attribute.preverification.FullFrame;
import proguard.classfile.attribute.preverification.MoreZeroFrame;
import proguard.classfile.attribute.preverification.ObjectType;
import proguard.classfile.attribute.preverification.SameOneFrame;
import proguard.classfile.attribute.preverification.StackMapAttribute;
import proguard.classfile.attribute.preverification.StackMapFrame;
import proguard.classfile.attribute.preverification.StackMapTableAttribute;
import proguard.classfile.attribute.preverification.VerificationType;
import proguard.classfile.attribute.preverification.visitor.StackMapFrameVisitor;
import proguard.classfile.attribute.preverification.visitor.VerificationTypeVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.ExceptionInfoVisitor;
import proguard.classfile.attribute.visitor.InnerClassesInfoVisitor;
import proguard.classfile.attribute.visitor.LocalVariableInfoVisitor;
import proguard.classfile.attribute.visitor.LocalVariableTypeInfoVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.DoubleConstant;
import proguard.classfile.constant.FieldrefConstant;
import proguard.classfile.constant.FloatConstant;
import proguard.classfile.constant.IntegerConstant;
import proguard.classfile.constant.InterfaceMethodrefConstant;
import proguard.classfile.constant.LongConstant;
import proguard.classfile.constant.MethodrefConstant;
import proguard.classfile.constant.NameAndTypeConstant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.Utf8Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;

class UsageMarker
extends SimplifiedVisitor
implements ClassVisitor,
MemberVisitor,
ConstantVisitor,
AttributeVisitor,
InnerClassesInfoVisitor,
ExceptionInfoVisitor,
StackMapFrameVisitor,
VerificationTypeVisitor,
LocalVariableInfoVisitor,
LocalVariableTypeInfoVisitor,
InstructionVisitor {
    private static final Object POSSIBLY_USED = new Object();
    private static final Object USED = new Object();
    private final MyInterfaceUsageMarker interfaceUsageMarker = new MyInterfaceUsageMarker();
    private final MyPossiblyUsedMethodUsageMarker possiblyUsedMethodUsageMarker = new MyPossiblyUsedMethodUsageMarker();

    UsageMarker() {
    }

    public void visitProgramClass(ProgramClass programClass) {
        if (this.shouldBeMarkedAsUsed(programClass)) {
            this.markAsUsed(programClass);
            this.markProgramClassBody(programClass);
        }
    }

    protected void markProgramClassBody(ProgramClass programClass) {
        this.markConstant(programClass, programClass.u2thisClass);
        if (programClass.u2superClass != 0) {
            this.markConstant(programClass, programClass.u2superClass);
        }
        programClass.hierarchyAccept(false, false, true, false, this.interfaceUsageMarker);
        programClass.methodAccept("<clinit>", "()V", this);
        programClass.methodAccept("<init>", "()V", this);
        programClass.methodsAccept(this.possiblyUsedMethodUsageMarker);
        programClass.attributesAccept(this);
    }

    public void visitLibraryClass(LibraryClass libraryClass) {
        if (this.shouldBeMarkedAsUsed(libraryClass)) {
            Clazz[] interfaceClasses;
            this.markAsUsed(libraryClass);
            Clazz superClass = libraryClass.superClass;
            if (superClass != null) {
                superClass.accept(this);
            }
            if ((interfaceClasses = libraryClass.interfaceClasses) != null) {
                for (int index = 0; index < interfaceClasses.length; ++index) {
                    if (interfaceClasses[index] == null) continue;
                    interfaceClasses[index].accept(this);
                }
            }
            libraryClass.methodsAccept(this);
        }
    }

    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        if (this.shouldBeMarkedAsUsed(programField)) {
            this.markAsUsed(programField);
            this.markConstant(programClass, programField.u2nameIndex);
            this.markConstant(programClass, programField.u2descriptorIndex);
            programField.attributesAccept(programClass, this);
            programField.referencedClassesAccept(this);
        }
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        if (this.shouldBeMarkedAsUsed(programMethod)) {
            if (this.isUsed(programClass)) {
                this.markAsUsed(programMethod);
                this.markProgramMethodBody(programClass, programMethod);
                this.markMethodHierarchy(programClass, programMethod);
            } else if (this.shouldBeMarkedAsPossiblyUsed(programMethod)) {
                this.markAsPossiblyUsed(programMethod);
                this.markMethodHierarchy(programClass, programMethod);
            }
        }
    }

    public void visitLibraryField(LibraryClass programClass, LibraryField programField) {
    }

    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        if (this.shouldBeMarkedAsUsed(libraryMethod)) {
            this.markAsUsed(libraryMethod);
            this.markMethodHierarchy(libraryClass, libraryMethod);
        }
    }

    protected void markProgramMethodBody(ProgramClass programClass, ProgramMethod programMethod) {
        this.markConstant(programClass, programMethod.u2nameIndex);
        this.markConstant(programClass, programMethod.u2descriptorIndex);
        programMethod.attributesAccept(programClass, this);
        programMethod.referencedClassesAccept(this);
    }

    protected void markMethodHierarchy(Clazz clazz, Method method) {
        clazz.methodImplementationsAccept(method, false, this);
    }

    public void visitIntegerConstant(Clazz clazz, IntegerConstant integerConstant) {
        if (this.shouldBeMarkedAsUsed(integerConstant)) {
            this.markAsUsed(integerConstant);
        }
    }

    public void visitLongConstant(Clazz clazz, LongConstant longConstant) {
        if (this.shouldBeMarkedAsUsed(longConstant)) {
            this.markAsUsed(longConstant);
        }
    }

    public void visitFloatConstant(Clazz clazz, FloatConstant floatConstant) {
        if (this.shouldBeMarkedAsUsed(floatConstant)) {
            this.markAsUsed(floatConstant);
        }
    }

    public void visitDoubleConstant(Clazz clazz, DoubleConstant doubleConstant) {
        if (this.shouldBeMarkedAsUsed(doubleConstant)) {
            this.markAsUsed(doubleConstant);
        }
    }

    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        if (this.shouldBeMarkedAsUsed(stringConstant)) {
            this.markAsUsed(stringConstant);
            this.markConstant(clazz, stringConstant.u2stringIndex);
            stringConstant.referencedClassAccept(this);
            stringConstant.referencedMemberAccept(this);
        }
    }

    public void visitUtf8Constant(Clazz clazz, Utf8Constant utf8Constant) {
        if (this.shouldBeMarkedAsUsed(utf8Constant)) {
            this.markAsUsed(utf8Constant);
        }
    }

    public void visitFieldrefConstant(Clazz clazz, FieldrefConstant fieldrefConstant) {
        this.visitRefConstant(clazz, fieldrefConstant);
    }

    public void visitInterfaceMethodrefConstant(Clazz clazz, InterfaceMethodrefConstant interfaceMethodrefConstant) {
        this.visitRefConstant(clazz, interfaceMethodrefConstant);
    }

    public void visitMethodrefConstant(Clazz clazz, MethodrefConstant methodrefConstant) {
        this.visitRefConstant(clazz, methodrefConstant);
    }

    private void visitRefConstant(Clazz clazz, RefConstant methodrefConstant) {
        if (this.shouldBeMarkedAsUsed(methodrefConstant)) {
            this.markAsUsed(methodrefConstant);
            this.markConstant(clazz, methodrefConstant.u2classIndex);
            this.markConstant(clazz, methodrefConstant.u2nameAndTypeIndex);
            methodrefConstant.referencedClassAccept(this);
            methodrefConstant.referencedMemberAccept(this);
        }
    }

    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        if (this.shouldBeMarkedAsUsed(classConstant)) {
            this.markAsUsed(classConstant);
            this.markConstant(clazz, classConstant.u2nameIndex);
            classConstant.referencedClassAccept(this);
        }
    }

    public void visitNameAndTypeConstant(Clazz clazz, NameAndTypeConstant nameAndTypeConstant) {
        if (this.shouldBeMarkedAsUsed(nameAndTypeConstant)) {
            this.markAsUsed(nameAndTypeConstant);
            this.markConstant(clazz, nameAndTypeConstant.u2nameIndex);
            this.markConstant(clazz, nameAndTypeConstant.u2descriptorIndex);
        }
    }

    public void visitUnknownAttribute(Clazz clazz, UnknownAttribute unknownAttribute) {
        this.markAsUsed(unknownAttribute);
        this.markConstant(clazz, unknownAttribute.u2attributeNameIndex);
    }

    public void visitSourceFileAttribute(Clazz clazz, SourceFileAttribute sourceFileAttribute) {
        this.markAsUsed(sourceFileAttribute);
        this.markConstant(clazz, sourceFileAttribute.u2attributeNameIndex);
        this.markConstant(clazz, sourceFileAttribute.u2sourceFileIndex);
    }

    public void visitSourceDirAttribute(Clazz clazz, SourceDirAttribute sourceDirAttribute) {
        this.markAsUsed(sourceDirAttribute);
        this.markConstant(clazz, sourceDirAttribute.u2attributeNameIndex);
        this.markConstant(clazz, sourceDirAttribute.u2sourceDirIndex);
    }

    public void visitInnerClassesAttribute(Clazz clazz, InnerClassesAttribute innerClassesAttribute) {
        innerClassesAttribute.innerClassEntriesAccept(clazz, this);
    }

    public void visitEnclosingMethodAttribute(Clazz clazz, EnclosingMethodAttribute enclosingMethodAttribute) {
        this.markAsUsed(enclosingMethodAttribute);
        this.markConstant(clazz, enclosingMethodAttribute.u2attributeNameIndex);
        this.markConstant(clazz, enclosingMethodAttribute.u2classIndex);
        if (enclosingMethodAttribute.u2nameAndTypeIndex != 0) {
            this.markConstant(clazz, enclosingMethodAttribute.u2nameAndTypeIndex);
        }
    }

    public void visitDeprecatedAttribute(Clazz clazz, DeprecatedAttribute deprecatedAttribute) {
        this.markAsUsed(deprecatedAttribute);
        this.markConstant(clazz, deprecatedAttribute.u2attributeNameIndex);
    }

    public void visitSyntheticAttribute(Clazz clazz, SyntheticAttribute syntheticAttribute) {
        this.markAsUsed(syntheticAttribute);
        this.markConstant(clazz, syntheticAttribute.u2attributeNameIndex);
    }

    public void visitSignatureAttribute(Clazz clazz, SignatureAttribute signatureAttribute) {
        this.markAsUsed(signatureAttribute);
        this.markConstant(clazz, signatureAttribute.u2attributeNameIndex);
        this.markConstant(clazz, signatureAttribute.u2signatureIndex);
    }

    public void visitConstantValueAttribute(Clazz clazz, Field field, ConstantValueAttribute constantValueAttribute) {
        this.markAsUsed(constantValueAttribute);
        this.markConstant(clazz, constantValueAttribute.u2attributeNameIndex);
        this.markConstant(clazz, constantValueAttribute.u2constantValueIndex);
    }

    public void visitExceptionsAttribute(Clazz clazz, Method method, ExceptionsAttribute exceptionsAttribute) {
        this.markAsUsed(exceptionsAttribute);
        this.markConstant(clazz, exceptionsAttribute.u2attributeNameIndex);
        exceptionsAttribute.exceptionEntriesAccept((ProgramClass)clazz, this);
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        this.markAsUsed(codeAttribute);
        this.markConstant(clazz, codeAttribute.u2attributeNameIndex);
        codeAttribute.instructionsAccept(clazz, method, this);
        codeAttribute.exceptionsAccept(clazz, method, this);
        codeAttribute.attributesAccept(clazz, method, this);
    }

    public void visitStackMapAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, StackMapAttribute stackMapAttribute) {
        this.markAsUsed(stackMapAttribute);
        this.markConstant(clazz, stackMapAttribute.u2attributeNameIndex);
        stackMapAttribute.stackMapFramesAccept(clazz, method, codeAttribute, this);
    }

    public void visitStackMapTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, StackMapTableAttribute stackMapTableAttribute) {
        this.markAsUsed(stackMapTableAttribute);
        this.markConstant(clazz, stackMapTableAttribute.u2attributeNameIndex);
        stackMapTableAttribute.stackMapFramesAccept(clazz, method, codeAttribute, this);
    }

    public void visitLineNumberTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LineNumberTableAttribute lineNumberTableAttribute) {
        this.markAsUsed(lineNumberTableAttribute);
        this.markConstant(clazz, lineNumberTableAttribute.u2attributeNameIndex);
    }

    public void visitLocalVariableTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTableAttribute localVariableTableAttribute) {
        this.markAsUsed(localVariableTableAttribute);
        this.markConstant(clazz, localVariableTableAttribute.u2attributeNameIndex);
        localVariableTableAttribute.localVariablesAccept(clazz, method, codeAttribute, this);
    }

    public void visitLocalVariableTypeTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeTableAttribute localVariableTypeTableAttribute) {
        this.markAsUsed(localVariableTypeTableAttribute);
        this.markConstant(clazz, localVariableTypeTableAttribute.u2attributeNameIndex);
        localVariableTypeTableAttribute.localVariablesAccept(clazz, method, codeAttribute, this);
    }

    public void visitAnyAnnotationsAttribute(Clazz clazz, AnnotationsAttribute annotationsAttribute) {
    }

    public void visitAnyParameterAnnotationsAttribute(Clazz clazz, Method method, ParameterAnnotationsAttribute parameterAnnotationsAttribute) {
    }

    public void visitAnnotationDefaultAttribute(Clazz clazz, Method method, AnnotationDefaultAttribute annotationDefaultAttribute) {
    }

    public void visitExceptionInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, ExceptionInfo exceptionInfo) {
        this.markAsUsed(exceptionInfo);
        if (exceptionInfo.u2catchType != 0) {
            this.markConstant(clazz, exceptionInfo.u2catchType);
        }
    }

    public void visitInnerClassesInfo(Clazz clazz, InnerClassesInfo innerClassesInfo) {
        if (innerClassesInfo.u2innerClassIndex == 0 && clazz.getName().equals(clazz.getClassName(innerClassesInfo.u2innerClassIndex))) {
            this.markAsUsed(innerClassesInfo);
            if (innerClassesInfo.u2innerClassIndex != 0) {
                this.markConstant(clazz, innerClassesInfo.u2innerClassIndex);
            }
            if (innerClassesInfo.u2outerClassIndex != 0) {
                this.markConstant(clazz, innerClassesInfo.u2outerClassIndex);
            }
            if (innerClassesInfo.u2innerNameIndex != 0) {
                this.markConstant(clazz, innerClassesInfo.u2innerNameIndex);
            }
        }
    }

    public void visitAnyStackMapFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, StackMapFrame stackMapFrame) {
    }

    public void visitSameOneFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SameOneFrame sameOneFrame) {
        sameOneFrame.stackItemAccept(clazz, method, codeAttribute, offset, this);
    }

    public void visitMoreZeroFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, MoreZeroFrame moreZeroFrame) {
        moreZeroFrame.additionalVariablesAccept(clazz, method, codeAttribute, offset, this);
    }

    public void visitFullFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, FullFrame fullFrame) {
        fullFrame.variablesAccept(clazz, method, codeAttribute, offset, this);
        fullFrame.stackAccept(clazz, method, codeAttribute, offset, this);
    }

    public void visitAnyVerificationType(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, VerificationType verificationType) {
    }

    public void visitObjectType(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ObjectType objectType) {
        this.markConstant(clazz, objectType.u2classIndex);
    }

    public void visitLocalVariableInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableInfo localVariableInfo) {
        this.markConstant(clazz, localVariableInfo.u2nameIndex);
        this.markConstant(clazz, localVariableInfo.u2descriptorIndex);
    }

    public void visitLocalVariableTypeInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeInfo localVariableTypeInfo) {
        this.markConstant(clazz, localVariableTypeInfo.u2nameIndex);
        this.markConstant(clazz, localVariableTypeInfo.u2signatureIndex);
    }

    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
    }

    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
        this.markConstant(clazz, constantInstruction.constantIndex);
    }

    protected void markAsUsed(VisitorAccepter visitorAccepter) {
        visitorAccepter.setVisitorInfo(USED);
    }

    protected boolean shouldBeMarkedAsUsed(VisitorAccepter visitorAccepter) {
        return visitorAccepter.getVisitorInfo() != USED;
    }

    protected boolean isUsed(VisitorAccepter visitorAccepter) {
        return visitorAccepter.getVisitorInfo() == USED;
    }

    protected void markAsPossiblyUsed(VisitorAccepter visitorAccepter) {
        visitorAccepter.setVisitorInfo(POSSIBLY_USED);
    }

    protected boolean shouldBeMarkedAsPossiblyUsed(VisitorAccepter visitorAccepter) {
        return visitorAccepter.getVisitorInfo() != USED && visitorAccepter.getVisitorInfo() != POSSIBLY_USED;
    }

    protected boolean isPossiblyUsed(VisitorAccepter visitorAccepter) {
        return visitorAccepter.getVisitorInfo() == POSSIBLY_USED;
    }

    protected void markAsUnused(VisitorAccepter visitorAccepter) {
        visitorAccepter.setVisitorInfo(null);
    }

    private void markConstant(Clazz clazz, int index) {
        clazz.constantPoolEntryAccept(index, this);
    }

    private class MyPossiblyUsedMethodUsageMarker
    extends SimplifiedVisitor
    implements MemberVisitor {
        private MyPossiblyUsedMethodUsageMarker() {
        }

        public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
            if (UsageMarker.this.isPossiblyUsed(programMethod)) {
                UsageMarker.this.markAsUsed(programMethod);
                UsageMarker.this.markProgramMethodBody(programClass, programMethod);
            }
        }
    }

    private class MyInterfaceUsageMarker
    implements ClassVisitor {
        private MyInterfaceUsageMarker() {
        }

        public void visitProgramClass(ProgramClass programClass) {
            if (UsageMarker.this.shouldBeMarkedAsPossiblyUsed(programClass)) {
                UsageMarker.this.markAsPossiblyUsed(programClass);
            }
        }

        public void visitLibraryClass(LibraryClass libraryClass) {
            UsageMarker.this.visitLibraryClass(libraryClass);
        }
    }
}

