/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import proguard.ClassPathEntry;
import proguard.io.DataEntryNameFilter;
import proguard.io.DataEntryReader;
import proguard.io.FilteredDataEntryReader;
import proguard.io.JarReader;
import proguard.util.ExtensionMatcher;
import proguard.util.FileNameParser;
import proguard.util.ListParser;

public class DataEntryReaderFactory {
    public static DataEntryReader createDataEntryReader(String messagePrefix, ClassPathEntry classPathEntry, DataEntryReader reader) {
        String entryName = classPathEntry.getName();
        boolean isJar = DataEntryReaderFactory.endsWithIgnoreCase(entryName, ".jar");
        boolean isWar = DataEntryReaderFactory.endsWithIgnoreCase(entryName, ".war");
        boolean isEar = DataEntryReaderFactory.endsWithIgnoreCase(entryName, ".ear");
        boolean isZip = DataEntryReaderFactory.endsWithIgnoreCase(entryName, ".zip");
        String filter = classPathEntry.getFilter();
        String jarFilter = classPathEntry.getJarFilter();
        String warFilter = classPathEntry.getWarFilter();
        String earFilter = classPathEntry.getEarFilter();
        String zipFilter = classPathEntry.getZipFilter();
        System.out.println(messagePrefix + (isJar ? "jar" : (isWar ? "war" : (isEar ? "ear" : (isZip ? "zip" : "directory")))) + " [" + classPathEntry.getName() + "]" + (filter != null || jarFilter != null || warFilter != null || earFilter != null || zipFilter != null ? " (filtered)" : ""));
        if (filter != null) {
            reader = new FilteredDataEntryReader(new DataEntryNameFilter(new ListParser(new FileNameParser()).parse(filter)), reader);
        }
        reader = DataEntryReaderFactory.wrapInJarReader(reader, isJar, jarFilter, ".jar");
        if (!isJar) {
            reader = DataEntryReaderFactory.wrapInJarReader(reader, isWar, warFilter, ".war");
            if (!isWar) {
                reader = DataEntryReaderFactory.wrapInJarReader(reader, isEar, earFilter, ".ear");
                if (!isEar) {
                    reader = DataEntryReaderFactory.wrapInJarReader(reader, isZip, zipFilter, ".zip");
                }
            }
        }
        return reader;
    }

    private static DataEntryReader wrapInJarReader(DataEntryReader reader, boolean isJar, String jarFilter, String jarExtension) {
        DataEntryReader jarReader = new JarReader(reader);
        if (isJar) {
            return jarReader;
        }
        if (jarFilter != null) {
            jarReader = new FilteredDataEntryReader(new DataEntryNameFilter(new ListParser(new FileNameParser()).parse(jarFilter)), jarReader);
        }
        return new FilteredDataEntryReader(new DataEntryNameFilter(new ExtensionMatcher(jarExtension)), jarReader, reader);
    }

    private static boolean endsWithIgnoreCase(String string, String suffix) {
        int stringLength = string.length();
        int suffixLength = suffix.length();
        return string.regionMatches(true, stringLength - suffixLength, suffix, 0, suffixLength);
    }
}

