/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.io.File;
import java.io.IOException;

public abstract class WordReader {
    private static final char COMMENT_CHARACTER = '#';
    private File baseDir;
    private WordReader includeWordReader;
    private String currentLine;
    private int currentLineLength;
    private int currentIndex;
    private String currentWord;
    private String currentComments;

    protected WordReader(File baseDir) {
        this.baseDir = baseDir;
    }

    public void setBaseDir(File baseDir) {
        if (this.includeWordReader != null) {
            this.includeWordReader.setBaseDir(baseDir);
        } else {
            this.baseDir = baseDir;
        }
    }

    public File getBaseDir() {
        return this.includeWordReader != null ? this.includeWordReader.getBaseDir() : this.baseDir;
    }

    public void includeWordReader(WordReader newIncludeWordReader) {
        if (this.includeWordReader == null) {
            this.includeWordReader = newIncludeWordReader;
        } else {
            this.includeWordReader.includeWordReader(newIncludeWordReader);
        }
    }

    public String nextWord() throws IOException {
        int endIndex;
        int startIndex;
        char startChar;
        this.currentWord = null;
        if (this.includeWordReader != null) {
            this.currentWord = this.includeWordReader.nextWord();
            if (this.currentWord != null) {
                return this.currentWord;
            }
            this.includeWordReader.close();
            this.includeWordReader = null;
        }
        while (this.currentLine != null && this.currentIndex < this.currentLineLength && Character.isWhitespace(this.currentLine.charAt(this.currentIndex))) {
            ++this.currentIndex;
        }
        while (this.currentLine == null || this.currentIndex == this.currentLineLength) {
            this.currentLine = this.nextLine();
            if (this.currentLine == null) {
                return null;
            }
            int comments_start = this.currentLine.indexOf(35);
            if (comments_start >= 0) {
                this.currentLineLength = comments_start;
                String comment = this.currentLine.substring(comments_start + 1);
                this.currentComments = this.currentComments == null ? comment : this.currentComments + '\n' + comment;
            } else {
                this.currentLineLength = this.currentLine.length();
            }
            this.currentIndex = 0;
            while (this.currentIndex < this.currentLineLength && Character.isWhitespace(this.currentLine.charAt(this.currentIndex))) {
                ++this.currentIndex;
            }
        }
        if (this.isDelimiter(startChar = this.currentLine.charAt(startIndex = this.currentIndex++))) {
            endIndex = this.currentIndex;
        } else if (this.isQuote(startChar)) {
            ++startIndex;
            do {
                ++this.currentIndex;
                if (this.currentIndex != this.currentLineLength) continue;
                this.currentWord = this.currentLine.substring(startIndex - 1, this.currentIndex);
                throw new IOException("Missing closing quote for " + this.locationDescription());
            } while (this.currentLine.charAt(this.currentIndex) != startChar);
            endIndex = this.currentIndex++;
        } else {
            char currentCharacter;
            while (this.currentIndex < this.currentLineLength && !this.isDelimiter(currentCharacter = this.currentLine.charAt(this.currentIndex)) && !Character.isWhitespace(currentCharacter)) {
                ++this.currentIndex;
            }
            endIndex = this.currentIndex;
        }
        this.currentWord = this.currentLine.substring(startIndex, endIndex);
        return this.currentWord;
    }

    public String lastComments() throws IOException {
        if (this.includeWordReader == null) {
            String comments = this.currentComments;
            this.currentComments = null;
            return comments;
        }
        return this.includeWordReader.lastComments();
    }

    public String locationDescription() {
        return (this.includeWordReader == null ? (this.currentWord == null ? "end of " : "'" + this.currentWord + "' in ") : this.includeWordReader.locationDescription() + ",\n" + "  included from ") + this.lineLocationDescription();
    }

    protected abstract String nextLine() throws IOException;

    protected abstract String lineLocationDescription();

    public void close() throws IOException {
        if (this.includeWordReader != null) {
            this.includeWordReader.close();
            this.includeWordReader = null;
        }
    }

    private boolean isDelimiter(char character) {
        return character == '@' || character == '{' || character == '}' || character == '(' || character == ')' || character == ',' || character == ';' || character == File.pathSeparatorChar;
    }

    private boolean isQuote(char character) {
        return character == '\'' || character == '\"';
    }
}

