/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.constant;

import java.io.UnsupportedEncodingException;
import proguard.classfile.Clazz;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;

public class Utf8Constant
extends Constant {
    private static final String ENCODING = "UTF-8";
    private static final char TWO_BYTE_LIMIT = '\u0080';
    private static final byte TWO_BYTE_CONSTANT1 = -64;
    private static final byte TWO_BYTE_CONSTANT2 = -128;
    private static final int TWO_BYTE_SHIFT1 = 6;
    private static final byte TWO_BYTE_MASK1 = 31;
    private static final byte TWO_BYTE_MASK2 = 63;
    private static final char THREE_BYTE_LIMIT = '\u0800';
    private static final byte THREE_BYTE_CONSTANT1 = -32;
    private static final byte THREE_BYTE_CONSTANT2 = -128;
    private static final byte THREE_BYTE_CONSTANT3 = -128;
    private static final int THREE_BYTE_SHIFT1 = 12;
    private static final int THREE_BYTE_SHIFT2 = 6;
    private static final byte THREE_BYTE_MASK1 = 15;
    private static final byte THREE_BYTE_MASK2 = 63;
    private static final byte THREE_BYTE_MASK3 = 63;
    private byte[] bytes;
    private String utf8string;

    public Utf8Constant() {
    }

    public Utf8Constant(String utf8string) {
        this.bytes = null;
        this.utf8string = utf8string;
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
        this.utf8string = null;
    }

    public byte[] getBytes() {
        try {
            return this.getByteArrayRepresentation();
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    public void setString(String utf8String) {
        this.bytes = null;
        this.utf8string = utf8String;
    }

    public String getString() {
        try {
            this.switchToStringRepresentation();
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex.getMessage());
        }
        return this.utf8string;
    }

    public int getTag() {
        return 1;
    }

    public void accept(Clazz clazz, ConstantVisitor constantVisitor) {
        constantVisitor.visitUtf8Constant(clazz, this);
    }

    private void switchToStringRepresentation() throws UnsupportedEncodingException {
        if (this.utf8string == null) {
            this.utf8string = new String(this.bytes, ENCODING);
            this.bytes = null;
        }
    }

    private byte[] getByteArrayRepresentation() throws UnsupportedEncodingException {
        if (this.bytes != null) {
            return this.bytes;
        }
        int byteLength = 0;
        int stringLength = this.utf8string.length();
        for (int stringIndex = 0; stringIndex < stringLength; ++stringIndex) {
            char c = this.utf8string.charAt(stringIndex);
            byteLength += c == '\u0000' ? 2 : (c < '\u0080' ? 1 : (c < '\u0800' ? 2 : 3));
        }
        byte[] bytes = new byte[byteLength];
        int byteIndex = 0;
        for (int stringIndex = 0; stringIndex < stringLength; ++stringIndex) {
            char c = this.utf8string.charAt(stringIndex);
            if (c == '\u0000') {
                bytes[byteIndex++] = -64;
                bytes[byteIndex++] = -128;
                continue;
            }
            if (c < '\u0080') {
                bytes[byteIndex++] = (byte)c;
                continue;
            }
            if (c < '\u0800') {
                bytes[byteIndex++] = (byte)(0xFFFFFFC0 | c >>> 6 & 0x1F);
                bytes[byteIndex++] = (byte)(0xFFFFFF80 | c & 0x3F);
                continue;
            }
            bytes[byteIndex++] = (byte)(0xFFFFFFE0 | c >>> 12 & 0xF);
            bytes[byteIndex++] = (byte)(0xFFFFFF80 | c >>> 6 & 0x3F);
            bytes[byteIndex++] = (byte)(0xFFFFFF80 | c & 0x3F);
        }
        return bytes;
    }
}

