/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util;

public class DescriptorClassEnumeration {
    private String descriptor;
    private int index;
    private int nestingLevel;
    private boolean isInnerClassName;
    private String accumulatedClassName;

    public DescriptorClassEnumeration(String descriptor) {
        this.descriptor = descriptor;
    }

    public int classCount() {
        int count = 0;
        this.nextFluff();
        while (this.hasMoreClassNames()) {
            ++count;
            this.nextClassName();
            this.nextFluff();
        }
        this.index = 0;
        return count;
    }

    public boolean hasMoreClassNames() {
        return this.index < this.descriptor.length();
    }

    /*
     * Unable to fully structure code
     */
    public String nextFluff() {
        fluffStartIndex = this.index;
        block9: while (this.index < this.descriptor.length()) {
            switch (this.descriptor.charAt(this.index++)) {
                case '<': {
                    ++this.nestingLevel;
                    ** GOTO lbl25
                }
                case '>': {
                    --this.nestingLevel;
                    continue block9;
                }
                case ':': {
                    continue block9;
                }
                case 'L': {
                    this.nestingLevel += 2;
                    this.isInnerClassName = false;
                    break block9;
                }
                case ';': {
                    this.nestingLevel -= 2;
                    ** GOTO lbl25
                }
                case '.': {
                    this.isInnerClassName = true;
                    break block9;
                }
                case 'T': {
                    while (this.descriptor.charAt(this.index++) != ';') {
                    }
                }
lbl25:
                // 4 sources

                default: {
                    if (this.nestingLevel != 1 || this.descriptor.charAt(this.index) == '>') continue block9;
                    while (this.descriptor.charAt(this.index++) != ':') {
                    }
                    continue block9;
                }
            }
        }
        return this.descriptor.substring(fluffStartIndex, this.index);
    }

    public String nextClassName() {
        int classNameStartIndex = this.index;
        block3: while (true) {
            switch (this.descriptor.charAt(this.index)) {
                case '.': 
                case ';': 
                case '<': {
                    break block3;
                }
                default: {
                    ++this.index;
                    continue block3;
                }
            }
            break;
        }
        String className = this.descriptor.substring(classNameStartIndex, this.index);
        this.accumulatedClassName = this.isInnerClassName ? this.accumulatedClassName + '$' + className : className;
        return this.accumulatedClassName;
    }

    public boolean isInnerClassName() {
        return this.isInnerClassName;
    }

    public static void main(String[] args) {
        try {
            for (int index = 0; index < args.length; ++index) {
                String descriptor = args[index];
                System.out.println("Descriptor [" + descriptor + "]");
                DescriptorClassEnumeration enumeration = new DescriptorClassEnumeration(descriptor);
                System.out.println("  Fluff: [" + enumeration.nextFluff() + "]");
                while (enumeration.hasMoreClassNames()) {
                    System.out.println("  Name:  [" + enumeration.nextClassName() + "]");
                    System.out.println("  Fluff: [" + enumeration.nextFluff() + "]");
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

