/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.visitor.ClassVisitor;
import proguard.util.ClassNameParser;
import proguard.util.ListParser;
import proguard.util.StringMatcher;

public class ClassNameFilter
implements ClassVisitor {
    private final StringMatcher regularExpressionMatcher;
    private final ClassVisitor classVisitor;

    public ClassNameFilter(String regularExpression, ClassVisitor classVisitor) {
        this(new ListParser(new ClassNameParser()).parse(regularExpression), classVisitor);
    }

    public ClassNameFilter(StringMatcher regularExpressionMatcher, ClassVisitor classVisitor) {
        this.regularExpressionMatcher = regularExpressionMatcher;
        this.classVisitor = classVisitor;
    }

    public void visitProgramClass(ProgramClass programClass) {
        if (this.accepted(programClass.getName())) {
            this.classVisitor.visitProgramClass(programClass);
        }
    }

    public void visitLibraryClass(LibraryClass libraryClass) {
        if (this.accepted(libraryClass.getName())) {
            this.classVisitor.visitLibraryClass(libraryClass);
        }
    }

    private boolean accepted(String name) {
        return this.regularExpressionMatcher.matches(name);
    }
}

