/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.IOException;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.io.DataEntry;
import proguard.io.DataEntryReader;
import proguard.io.RenamedDataEntry;

public class DataEntryRenamer
implements DataEntryReader {
    private final ClassPool classPool;
    private final DataEntryReader dataEntryReader;

    public DataEntryRenamer(ClassPool classPool, DataEntryReader dataEntryReader) {
        this.classPool = classPool;
        this.dataEntryReader = dataEntryReader;
    }

    public void read(DataEntry dataEntry) throws IOException {
        this.dataEntryReader.read(this.renamedDataEntry(dataEntry));
    }

    private DataEntry renamedDataEntry(DataEntry dataEntry) {
        String dataEntryName = dataEntry.getName();
        for (int suffixIndex = dataEntryName.length() - 1; suffixIndex > 0; --suffixIndex) {
            char c = dataEntryName.charAt(suffixIndex);
            if (Character.isLetterOrDigit(c)) continue;
            if (c == '/') break;
            String className = dataEntryName.substring(0, suffixIndex);
            Clazz clazz = this.classPool.getClass(className);
            if (clazz == null) continue;
            String newClassName = clazz.getName();
            if (className.equals(newClassName)) break;
            String newDataEntryName = suffixIndex > 0 ? newClassName + dataEntryName.substring(suffixIndex) : newClassName;
            return new RenamedDataEntry(dataEntry, newDataEntryName);
        }
        return dataEntry;
    }
}

