/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.File;
import java.io.IOException;
import proguard.io.DataEntryPump;
import proguard.io.DataEntryReader;
import proguard.io.FileDataEntry;

public class DirectoryPump
implements DataEntryPump {
    private final File directory;

    public DirectoryPump(File directory) {
        this.directory = directory;
    }

    public void pumpDataEntries(DataEntryReader dataEntryReader) throws IOException {
        if (!this.directory.exists()) {
            throw new IOException("No such file or directory");
        }
        this.readFiles(this.directory, dataEntryReader);
    }

    private void readFiles(File file, DataEntryReader dataEntryReader) throws IOException {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int index = 0; index < files.length; ++index) {
                this.readFiles(files[index], dataEntryReader);
            }
        } else {
            dataEntryReader.read(new FileDataEntry(this.directory, file));
        }
    }
}

