/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import java.util.Map;
import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.Member;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.MemberVisitor;
import proguard.obfuscate.MemberObfuscator;

public class MemberNameConflictFixer
implements MemberVisitor {
    private final boolean allowAggressiveOverloading;
    private final Map descriptorMap;
    private final WarningPrinter warningPrinter;
    private final MemberObfuscator memberObfuscator;

    public MemberNameConflictFixer(boolean allowAggressiveOverloading, Map descriptorMap, WarningPrinter warningPrinter, MemberObfuscator memberObfuscator) {
        this.allowAggressiveOverloading = allowAggressiveOverloading;
        this.descriptorMap = descriptorMap;
        this.warningPrinter = warningPrinter;
        this.memberObfuscator = memberObfuscator;
    }

    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        this.visitMember(programClass, programField, true);
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        String name = programMethod.getName(programClass);
        if (name.equals("<clinit>") || name.equals("<init>")) {
            return;
        }
        this.visitMember(programClass, programMethod, false);
    }

    public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
    }

    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
    }

    private void visitMember(Clazz clazz, Member member, boolean isField) {
        String newName;
        Map nameMap;
        String previousName;
        String name = member.getName(clazz);
        String descriptor = member.getDescriptor(clazz);
        if (!this.allowAggressiveOverloading) {
            descriptor = descriptor.substring(0, descriptor.indexOf(41) + 1);
        }
        if ((previousName = (String)(nameMap = MemberObfuscator.retrieveNameMap(this.descriptorMap, descriptor)).get(newName = MemberObfuscator.newMemberName(member))) != null && !name.equals(previousName)) {
            if (MemberObfuscator.hasFixedNewMemberName(member) && this.warningPrinter != null) {
                descriptor = member.getDescriptor(clazz);
                this.warningPrinter.print("Warning: " + ClassUtil.externalClassName(clazz.getName()) + (isField ? ": field '" + ClassUtil.externalFullFieldDescription(0, name, descriptor) : ": method '" + ClassUtil.externalFullMethodDescription(clazz.getName(), 0, name, descriptor)) + "' can't be mapped to '" + newName + "' because it would conflict with " + (isField ? "field '" : "method '") + previousName + "', which is already being mapped to '" + newName + "'");
            }
            MemberObfuscator.setNewMemberName(member, null);
            member.accept(clazz, this.memberObfuscator);
        }
    }
}

