/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize;

import java.io.IOException;
import proguard.ClassSpecificationVisitorFactory;
import proguard.Configuration;
import proguard.classfile.ClassPool;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.MultiAttributeVisitor;
import proguard.classfile.constant.visitor.AllConstantVisitor;
import proguard.classfile.editor.AccessFixer;
import proguard.classfile.editor.ClassReferenceFixer;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.editor.MemberReferenceFixer;
import proguard.classfile.editor.MethodInvocationFixer;
import proguard.classfile.instruction.visitor.AllInstructionVisitor;
import proguard.classfile.instruction.visitor.InstructionCounter;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.instruction.visitor.MultiInstructionVisitor;
import proguard.classfile.util.MethodLinker;
import proguard.classfile.visitor.AllFieldVisitor;
import proguard.classfile.visitor.AllMemberVisitor;
import proguard.classfile.visitor.AllMethodVisitor;
import proguard.classfile.visitor.BottomClassFilter;
import proguard.classfile.visitor.ClassAccessFilter;
import proguard.classfile.visitor.ClassCleaner;
import proguard.classfile.visitor.ClassCounter;
import proguard.classfile.visitor.ClassForNameClassVisitor;
import proguard.classfile.visitor.ClassPoolVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.DotClassClassVisitor;
import proguard.classfile.visitor.ExceptionCounter;
import proguard.classfile.visitor.MemberAccessFilter;
import proguard.classfile.visitor.MemberCounter;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.MultiClassVisitor;
import proguard.classfile.visitor.MultiMemberVisitor;
import proguard.evaluation.value.IdentifiedValueFactory;
import proguard.optimize.ConstantMemberFilter;
import proguard.optimize.DuplicateInitializerFixer;
import proguard.optimize.DuplicateInitializerInvocationFixer;
import proguard.optimize.KeepMarker;
import proguard.optimize.MethodDescriptorShrinker;
import proguard.optimize.MethodStaticizer;
import proguard.optimize.OptimizationInfoMemberFilter;
import proguard.optimize.ParameterShrinker;
import proguard.optimize.TailRecursionSimplifier;
import proguard.optimize.WriteOnlyFieldFilter;
import proguard.optimize.evaluation.EvaluationSimplifier;
import proguard.optimize.evaluation.LoadingInvocationUnit;
import proguard.optimize.evaluation.PartialEvaluator;
import proguard.optimize.evaluation.StoringInvocationUnit;
import proguard.optimize.evaluation.VariableOptimizer;
import proguard.optimize.info.AccessMethodMarker;
import proguard.optimize.info.BackwardBranchMarker;
import proguard.optimize.info.CatchExceptionMarker;
import proguard.optimize.info.ClassOptimizationInfoSetter;
import proguard.optimize.info.DotClassMarker;
import proguard.optimize.info.InstanceofClassMarker;
import proguard.optimize.info.InstantiationClassMarker;
import proguard.optimize.info.MemberOptimizationInfoSetter;
import proguard.optimize.info.MethodInvocationMarker;
import proguard.optimize.info.NoSideEffectMethodMarker;
import proguard.optimize.info.NonPrivateMemberMarker;
import proguard.optimize.info.PackageVisibleMemberContainingClassMarker;
import proguard.optimize.info.PackageVisibleMemberInvokingClassMarker;
import proguard.optimize.info.ParameterUsageMarker;
import proguard.optimize.info.ReadWriteFieldMarker;
import proguard.optimize.info.SideEffectMethodMarker;
import proguard.optimize.info.SuperInvocationMarker;
import proguard.optimize.peephole.BranchTargetFinder;
import proguard.optimize.peephole.ClassFinalizer;
import proguard.optimize.peephole.GotoCommonCodeReplacer;
import proguard.optimize.peephole.GotoGotoReplacer;
import proguard.optimize.peephole.GotoReturnReplacer;
import proguard.optimize.peephole.HorizontalClassMerger;
import proguard.optimize.peephole.InstructionSequenceConstants;
import proguard.optimize.peephole.InstructionSequencesReplacer;
import proguard.optimize.peephole.MemberPrivatizer;
import proguard.optimize.peephole.MethodInliner;
import proguard.optimize.peephole.PeepholeOptimizer;
import proguard.optimize.peephole.RetargetedInnerClassAttributeRemover;
import proguard.optimize.peephole.TargetClassChanger;
import proguard.optimize.peephole.UnreachableCodeRemover;
import proguard.optimize.peephole.UnreachableExceptionRemover;
import proguard.optimize.peephole.VariableShrinker;
import proguard.optimize.peephole.VerticalClassMerger;

public class Optimizer {
    private final Configuration configuration;

    public Optimizer(Configuration configuration) {
        this.configuration = configuration;
    }

    public boolean execute(ClassPool programClassPool, ClassPool libraryClassPool) throws IOException {
        if (this.configuration.keep == null && this.configuration.applyMapping == null && this.configuration.printMapping == null) {
            throw new IOException("You have to specify '-keep' options for the optimization step.");
        }
        ClassCounter classMergeCounter = new ClassCounter();
        ClassCounter finalClassCounter = new ClassCounter();
        MemberCounter finalMethodCounter = new MemberCounter();
        MemberCounter privateFieldCounter = new MemberCounter();
        MemberCounter privateMethodCounter = new MemberCounter();
        MemberCounter staticMethodCounter = new MemberCounter();
        MemberCounter writeOnlyFieldCounter = new MemberCounter();
        MemberCounter constantFieldCounter = new MemberCounter();
        MemberCounter constantMethodCounter = new MemberCounter();
        MemberCounter descriptorShrinkCounter = new MemberCounter();
        MemberCounter initializerFixCounter = new MemberCounter();
        MemberCounter parameterShrinkCounter = new MemberCounter();
        MemberCounter variableShrinkCounter = new MemberCounter();
        ExceptionCounter exceptionCounter = new ExceptionCounter();
        InstructionCounter inliningCounter = new InstructionCounter();
        InstructionCounter tailRecursionCounter = new InstructionCounter();
        InstructionCounter commonCodeCounter = new InstructionCounter();
        InstructionCounter pushCounter = new InstructionCounter();
        InstructionCounter branchCounter = new InstructionCounter();
        InstructionCounter deletedCounter = new InstructionCounter();
        InstructionCounter addedCounter = new InstructionCounter();
        InstructionCounter peepholeCounter = new InstructionCounter();
        programClassPool.classesAccept(new ClassCleaner());
        libraryClassPool.classesAccept(new ClassCleaner());
        programClassPool.classesAccept(new BottomClassFilter(new MethodLinker()));
        libraryClassPool.classesAccept(new BottomClassFilter(new MethodLinker()));
        KeepMarker keepMarker = new KeepMarker();
        ClassPoolVisitor classPoolvisitor = ClassSpecificationVisitorFactory.createClassPoolVisitor(this.configuration.keep, keepMarker, keepMarker, false, true, false);
        programClassPool.accept(classPoolvisitor);
        libraryClassPool.accept(classPoolvisitor);
        libraryClassPool.classesAccept(keepMarker);
        libraryClassPool.classesAccept(new AllMemberVisitor(keepMarker));
        programClassPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new AllInstructionVisitor(new DotClassClassVisitor(keepMarker)))));
        programClassPool.classesAccept(new AllConstantVisitor(new ClassForNameClassVisitor(keepMarker)));
        programClassPool.classesAccept(new ClassOptimizationInfoSetter());
        programClassPool.classesAccept(new AllMemberVisitor(new MemberOptimizationInfoSetter()));
        if (this.configuration.assumeNoSideEffects != null) {
            NoSideEffectMethodMarker noSideEffectMethodMarker = new NoSideEffectMethodMarker();
            ClassPoolVisitor noClassPoolvisitor = ClassSpecificationVisitorFactory.createClassPoolVisitor(this.configuration.assumeNoSideEffects, null, (MemberVisitor)noSideEffectMethodMarker);
            programClassPool.accept(noClassPoolvisitor);
            libraryClassPool.accept(noClassPoolvisitor);
        }
        programClassPool.classesAccept(new ClassFinalizer(finalClassCounter, finalMethodCounter));
        programClassPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new AllInstructionVisitor(new ReadWriteFieldMarker()))));
        programClassPool.classesAccept(new AllMethodVisitor(new OptimizationInfoMemberFilter(new ParameterUsageMarker())));
        programClassPool.accept(new SideEffectMethodMarker());
        IdentifiedValueFactory valueFactory = new IdentifiedValueFactory();
        programClassPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new PartialEvaluator(valueFactory, new StoringInvocationUnit(valueFactory), false))));
        programClassPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new EvaluationSimplifier(new PartialEvaluator(valueFactory, new LoadingInvocationUnit(valueFactory), false), pushCounter, branchCounter, deletedCounter, addedCounter))));
        programClassPool.classesAccept(new AllMethodVisitor(new OptimizationInfoMemberFilter(new MethodDescriptorShrinker(descriptorShrinkCounter))));
        programClassPool.classesAccept(new AllMethodVisitor(new OptimizationInfoMemberFilter(new MemberAccessFilter(0, 8, new MethodStaticizer(staticMethodCounter)))));
        programClassPool.classesAccept(new MemberReferenceFixer());
        programClassPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new ParameterShrinker(parameterShrinkCounter))));
        programClassPool.classesAccept(new MultiClassVisitor(new ClassVisitor[]{new AllFieldVisitor(new WriteOnlyFieldFilter(writeOnlyFieldCounter)), new AllFieldVisitor(new ConstantMemberFilter(constantFieldCounter)), new AllMethodVisitor(new ConstantMemberFilter(constantMethodCounter))}));
        if (this.configuration.allowAccessModification) {
            programClassPool.classesAccept(new AllConstantVisitor(new AccessFixer()));
        }
        programClassPool.classesAccept(new MultiClassVisitor(new ClassVisitor[]{new AllConstantVisitor(new PackageVisibleMemberInvokingClassMarker()), new AllMethodVisitor(new MultiMemberVisitor(new MemberVisitor[]{new PackageVisibleMemberContainingClassMarker(), new AllAttributeVisitor(new MultiAttributeVisitor(new AttributeVisitor[]{new CatchExceptionMarker(), new AllInstructionVisitor(new MultiInstructionVisitor(new InstructionVisitor[]{new InstantiationClassMarker(), new InstanceofClassMarker(), new DotClassMarker(), new MethodInvocationMarker(), new SuperInvocationMarker(), new BackwardBranchMarker(), new AccessMethodMarker()}))}))}))}));
        programClassPool.classesAccept(new AllMethodVisitor(new DuplicateInitializerFixer(initializerFixCounter)));
        if (initializerFixCounter.getCount() > 0) {
            programClassPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new DuplicateInitializerInvocationFixer(addedCounter))));
            programClassPool.classesAccept(new MemberReferenceFixer());
        }
        programClassPool.classesAccept(new VerticalClassMerger(this.configuration.allowAccessModification, this.configuration.mergeInterfacesAggressively, classMergeCounter));
        programClassPool.classesAccept(new HorizontalClassMerger(this.configuration.allowAccessModification, this.configuration.mergeInterfacesAggressively, classMergeCounter));
        programClassPool.classesAccept(new RetargetedInnerClassAttributeRemover());
        programClassPool.classesAccept(new TargetClassChanger());
        programClassPool.classesAccept(new ClassReferenceFixer(true));
        programClassPool.classesAccept(new MemberReferenceFixer());
        if (this.configuration.allowAccessModification) {
            programClassPool.classesAccept(new AllConstantVisitor(new AccessFixer()));
        }
        programClassPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new MethodInliner(this.configuration.microEdition, this.configuration.allowAccessModification, true, inliningCounter))));
        programClassPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new MethodInliner(this.configuration.microEdition, this.configuration.allowAccessModification, false, inliningCounter))));
        programClassPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new TailRecursionSimplifier(tailRecursionCounter))));
        programClassPool.classesAccept(new NonPrivateMemberMarker());
        programClassPool.classesAccept(new ClassAccessFilter(0, 512, new AllMemberVisitor(new MemberAccessFilter(0, 2, new MemberPrivatizer(privateFieldCounter, privateMethodCounter)))));
        if (this.configuration.allowAccessModification) {
            programClassPool.classesAccept(new AllConstantVisitor(new AccessFixer()));
        }
        programClassPool.classesAccept(new AllMemberVisitor(new AllAttributeVisitor(new MethodInvocationFixer())));
        BranchTargetFinder branchTargetFinder = new BranchTargetFinder();
        CodeAttributeEditor codeAttributeEditor = new CodeAttributeEditor();
        programClassPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new GotoCommonCodeReplacer(commonCodeCounter))));
        programClassPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new PeepholeOptimizer(branchTargetFinder, codeAttributeEditor, new MultiInstructionVisitor(new InstructionVisitor[]{new InstructionSequencesReplacer(InstructionSequenceConstants.PATTERN_CONSTANTS, InstructionSequenceConstants.INSTRUCTION_SEQUENCES, branchTargetFinder, codeAttributeEditor, peepholeCounter), new GotoGotoReplacer(codeAttributeEditor, peepholeCounter), new GotoReturnReplacer(codeAttributeEditor, peepholeCounter)})))));
        programClassPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new UnreachableExceptionRemover(exceptionCounter))));
        programClassPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new UnreachableCodeRemover(deletedCounter))));
        programClassPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new VariableShrinker(variableShrinkCounter))));
        programClassPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new VariableOptimizer(!this.configuration.microEdition))));
        int classMergeCound = classMergeCounter.getCount();
        int finalClassCount = finalClassCounter.getCount();
        int privateFieldCount = privateFieldCounter.getCount();
        int privateMethodCount = privateMethodCounter.getCount();
        int staticMethodCount = staticMethodCounter.getCount();
        int finalMethodCount = finalMethodCounter.getCount();
        int writeOnlyFieldCount = writeOnlyFieldCounter.getCount();
        int constantFieldCount = constantFieldCounter.getCount();
        int constantMethodCount = constantMethodCounter.getCount();
        int descriptorShrinkCount = descriptorShrinkCounter.getCount() - initializerFixCounter.getCount();
        int parameterShrinkCount = parameterShrinkCounter.getCount() - initializerFixCounter.getCount();
        int variableShrinkCount = variableShrinkCounter.getCount();
        int exceptionCount = exceptionCounter.getCount();
        int tailRecursionCount = tailRecursionCounter.getCount();
        int inliningCount = inliningCounter.getCount();
        int commonCodeCount = commonCodeCounter.getCount();
        int pushCount = pushCounter.getCount();
        int branchCount = branchCounter.getCount();
        int removedCount = deletedCounter.getCount() - addedCounter.getCount();
        int peepholeCount = peepholeCounter.getCount();
        if (this.configuration.verbose) {
            System.out.println("  Number of merged classes:                  " + classMergeCound);
            System.out.println("  Number of finalized classes:               " + finalClassCount);
            System.out.println("  Number of privatized fields:               " + privateFieldCount);
            System.out.println("  Number of privatized methods:              " + privateMethodCount);
            System.out.println("  Number of staticized methods:              " + staticMethodCount);
            System.out.println("  Number of finalized methods:               " + finalMethodCount);
            System.out.println("  Number of removed write-only fields:       " + writeOnlyFieldCount);
            System.out.println("  Number of inlined constant fields:         " + constantFieldCount);
            System.out.println("  Number of inlined constant methods:        " + constantMethodCount);
            System.out.println("  Number of simplified method declarations:  " + descriptorShrinkCount);
            System.out.println("  Number of removed parameters:              " + parameterShrinkCount);
            System.out.println("  Number of removed local variables:         " + variableShrinkCount);
            System.out.println("  Number of inlined method calls:            " + inliningCount);
            System.out.println("  Number of simplified tail recursion calls: " + tailRecursionCount);
            System.out.println("  Number of removed exception blocks:        " + exceptionCount);
            System.out.println("  Number of merged code blocks:              " + commonCodeCount);
            System.out.println("  Number of simplified push instructions:    " + pushCount);
            System.out.println("  Number of simplified branches:             " + branchCount);
            System.out.println("  Number of removed instructions:            " + removedCount);
            System.out.println("  Number of peephole optimizations:          " + peepholeCount);
        }
        return classMergeCound > 0 || finalClassCount > 0 || privateFieldCount > 0 || privateMethodCount > 0 || staticMethodCount > 0 || finalMethodCount > 0 || writeOnlyFieldCount > 0 || constantFieldCount > 0 || constantMethodCount > 0 || descriptorShrinkCount > 0 || parameterShrinkCount > 0 || variableShrinkCount > 0 || inliningCount > 0 || tailRecursionCount > 0 || exceptionCount > 0 || commonCodeCount > 0 || pushCount > 0 || branchCount > 0 || removedCount > 0 || peepholeCount > 0;
    }
}

