/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.editor.VariableEditor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.optimize.info.ParameterUsageMarker;

public class ParameterShrinker
extends SimplifiedVisitor
implements AttributeVisitor {
    private static final boolean DEBUG = false;
    private final MemberVisitor extraVariableMemberVisitor;
    private final VariableEditor variableEditor = new VariableEditor();

    public ParameterShrinker() {
        this(null);
    }

    public ParameterShrinker(MemberVisitor extraVariableMemberVisitor) {
        this.extraVariableMemberVisitor = extraVariableMemberVisitor;
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        int newParameterSize;
        int oldParameterSize = ParameterUsageMarker.getParameterSize(method);
        if (oldParameterSize > (newParameterSize = ClassUtil.internalMethodParameterSize(method.getDescriptor(clazz), method.getAccessFlags()))) {
            int maxLocals = codeAttribute.u2maxLocals;
            this.variableEditor.reset(maxLocals);
            for (int parameterIndex = 0; parameterIndex < oldParameterSize; ++parameterIndex) {
                if (ParameterUsageMarker.isParameterUsed(method, parameterIndex)) continue;
                this.variableEditor.deleteVariable(parameterIndex);
                if (this.extraVariableMemberVisitor == null) continue;
                method.accept(clazz, this.extraVariableMemberVisitor);
            }
            this.variableEditor.visitCodeAttribute(clazz, method, codeAttribute);
        }
    }
}

