/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.ExceptionInfo;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.ExceptionInfoVisitor;
import proguard.classfile.constant.MethodrefConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.CodeAttributeComposer;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionFactory;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.InternalTypeEnumeration;
import proguard.classfile.util.SimplifiedVisitor;

public class TailRecursionSimplifier
extends SimplifiedVisitor
implements AttributeVisitor,
InstructionVisitor,
ConstantVisitor,
ExceptionInfoVisitor {
    private static final int MAXIMUM_CODE_EXPANSION = 2;
    private static final int MAXIMUM_EXTRA_CODE_LENGTH = 128;
    private static final boolean DEBUG = false;
    private final InstructionVisitor extraTailRecursionVisitor;
    private final CodeAttributeComposer codeAttributeComposer = new CodeAttributeComposer();
    private Method targetMethod;
    private boolean recursive;
    private boolean inlinedAny;

    public TailRecursionSimplifier() {
        this(null);
    }

    public TailRecursionSimplifier(InstructionVisitor extraTailRecursionVisitor) {
        this.extraTailRecursionVisitor = extraTailRecursionVisitor;
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        int accessFlags = method.getAccessFlags();
        if ((accessFlags & 0x1A) != 0 && (accessFlags & 0x720) == 0) {
            this.targetMethod = method;
            this.inlinedAny = false;
            this.codeAttributeComposer.reset();
            this.copyCode(clazz, method, codeAttribute);
            if (this.inlinedAny) {
                this.codeAttributeComposer.visitCodeAttribute(clazz, method, codeAttribute);
            }
        }
    }

    private void copyCode(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        this.codeAttributeComposer.beginCodeFragment(codeAttribute.u4codeLength * 2 + 128);
        codeAttribute.instructionsAccept(clazz, method, this);
        this.codeAttributeComposer.appendLabel(codeAttribute.u4codeLength);
        this.codeAttributeComposer.endCodeFragment();
    }

    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
        this.codeAttributeComposer.appendInstruction(offset, instruction.shrink());
    }

    /*
     * Enabled aggressive block sorting
     */
    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
        switch (constantInstruction.opcode) {
            case -74: 
            case -73: 
            case -72: {
                clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
                if (!this.recursive) break;
                int nextOffset = offset + constantInstruction.length(offset);
                Instruction nextInstruction = InstructionFactory.create(codeAttribute.code, nextOffset);
                switch (nextInstruction.opcode) {
                    case -84: 
                    case -83: 
                    case -82: 
                    case -81: 
                    case -80: 
                    case -79: {
                        codeAttribute.exceptionsAccept(clazz, method, offset, this);
                        if (!this.recursive) break;
                        this.codeAttributeComposer.appendLabel(offset);
                        this.storeParameters(clazz, method);
                        int gotoOffset = offset + 1;
                        this.codeAttributeComposer.appendInstruction(gotoOffset, new BranchInstruction(-89, -gotoOffset));
                        this.inlinedAny = true;
                        if (this.extraTailRecursionVisitor != null) {
                            this.extraTailRecursionVisitor.visitConstantInstruction(clazz, method, codeAttribute, offset, constantInstruction);
                        }
                        return;
                    }
                }
                break;
            }
        }
        this.codeAttributeComposer.appendInstruction(offset, constantInstruction.shrink());
    }

    public void visitMethodrefConstant(Clazz clazz, MethodrefConstant methodrefConstant) {
        this.recursive = this.targetMethod.equals(methodrefConstant.referencedMember);
    }

    public void visitExceptionInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, ExceptionInfo exceptionInfo) {
        this.recursive = false;
    }

    private void storeParameters(Clazz clazz, Method method) {
        String parameterType;
        int parameterIndex;
        String descriptor = method.getDescriptor(clazz);
        boolean isStatic = (method.getAccessFlags() & 8) != 0;
        int parameterCount = ClassUtil.internalMethodParameterCount(descriptor);
        int parameterSize = ClassUtil.internalMethodParameterSize(descriptor);
        int parameterOffset = isStatic ? 0 : 1;
        String[] parameterTypes = new String[parameterSize];
        InternalTypeEnumeration internalTypeEnumeration = new InternalTypeEnumeration(descriptor);
        for (parameterIndex = 0; parameterIndex < parameterSize; ++parameterIndex) {
            parameterTypes[parameterIndex] = parameterType = internalTypeEnumeration.nextType();
            if (ClassUtil.internalTypeSize(parameterType) != 2) continue;
            ++parameterIndex;
        }
        this.codeAttributeComposer.beginCodeFragment((parameterOffset + parameterCount) * 4);
        for (parameterIndex = parameterSize - 1; parameterIndex >= 0; --parameterIndex) {
            byte opcode;
            parameterType = parameterTypes[parameterIndex];
            if (parameterType == null) continue;
            switch (parameterType.charAt(0)) {
                case 'B': 
                case 'C': 
                case 'I': 
                case 'S': 
                case 'Z': {
                    opcode = 54;
                    break;
                }
                case 'J': {
                    opcode = 55;
                    break;
                }
                case 'F': {
                    opcode = 56;
                    break;
                }
                case 'D': {
                    opcode = 57;
                    break;
                }
                default: {
                    opcode = 58;
                }
            }
            this.codeAttributeComposer.appendInstruction(parameterSize - parameterIndex - 1, new VariableInstruction(opcode, parameterOffset + parameterIndex).shrink());
        }
        if (!isStatic) {
            this.codeAttributeComposer.appendInstruction(parameterSize, new VariableInstruction(58, 0).shrink());
        }
        this.codeAttributeComposer.endCodeFragment();
    }
}

