/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.evaluation;

import proguard.classfile.Clazz;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionFactory;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.SwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.ReferencedMemberVisitor;
import proguard.evaluation.TracedStack;
import proguard.evaluation.TracedVariables;
import proguard.evaluation.value.InstructionOffsetValue;
import proguard.evaluation.value.Value;
import proguard.optimize.evaluation.PartialEvaluator;
import proguard.optimize.info.ParameterUsageMarker;
import proguard.optimize.info.SideEffectInstructionChecker;

public class EvaluationSimplifier
extends SimplifiedVisitor
implements AttributeVisitor {
    private static final boolean DEBUG_RESULTS = false;
    private static final boolean DEBUG_ANALYSIS = false;
    private static final boolean DEBUG = false;
    private final InstructionVisitor extraPushInstructionVisitor;
    private final InstructionVisitor extraBranchInstructionVisitor;
    private final InstructionVisitor extraDeletedInstructionVisitor;
    private final InstructionVisitor extraAddedInstructionVisitor;
    private final PartialEvaluator partialEvaluator;
    private final PartialEvaluator simplePartialEvaluator = new PartialEvaluator();
    private final SideEffectInstructionChecker sideEffectInstructionChecker = new SideEffectInstructionChecker(true);
    private final MyInstructionSimplifier instructionSimplifier = new MyInstructionSimplifier();
    private final MyProducerMarker producerMarker = new MyProducerMarker();
    private final MyStackConsistencyFixer stackConsistencyFixer = new MyStackConsistencyFixer();
    private final CodeAttributeEditor codeAttributeEditor = new CodeAttributeEditor(false);
    private boolean[][] variablesNecessaryAfter = new boolean[1024][64];
    private boolean[][] stacksNecessaryAfter = new boolean[1024][16];
    private boolean[][] stacksSimplifiedBefore = new boolean[1024][16];
    private boolean[] instructionsNecessary = new boolean[1024];
    private boolean[] instructionsSimplified = new boolean[1024];
    private int[] aliasingVariables = new int[1024];
    private int maxMarkedOffset;

    public EvaluationSimplifier() {
        this(new PartialEvaluator(), null, null, null, null);
    }

    public EvaluationSimplifier(PartialEvaluator partialEvaluator, InstructionVisitor extraPushInstructionVisitor, InstructionVisitor extraBranchInstructionVisitor, InstructionVisitor extraDeletedInstructionVisitor, InstructionVisitor extraAddedInstructionVisitor) {
        this.partialEvaluator = partialEvaluator;
        this.extraPushInstructionVisitor = extraPushInstructionVisitor;
        this.extraBranchInstructionVisitor = extraBranchInstructionVisitor;
        this.extraDeletedInstructionVisitor = extraDeletedInstructionVisitor;
        this.extraAddedInstructionVisitor = extraAddedInstructionVisitor;
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        try {
            this.visitCodeAttribute0(clazz, method, codeAttribute);
        }
        catch (RuntimeException ex) {
            System.err.println("Unexpected error while optimizing after partial evaluation:");
            System.err.println("  Class       = [" + clazz.getName() + "]");
            System.err.println("  Method      = [" + method.getName(clazz) + method.getDescriptor(clazz) + "]");
            System.err.println("  Exception   = [" + ex.getClass().getName() + "] (" + ex.getMessage() + ")");
            System.err.println("Not optimizing this method");
        }
    }

    public void visitCodeAttribute0(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        Instruction instruction;
        int offset;
        this.initializeNecessary(codeAttribute);
        this.partialEvaluator.visitCodeAttribute(clazz, method, codeAttribute);
        int codeLength = codeAttribute.u4codeLength;
        this.codeAttributeEditor.reset(codeLength);
        for (int offset2 = 0; offset2 < codeLength; ++offset2) {
            if (!this.partialEvaluator.isTraced(offset2)) continue;
            Instruction instruction2 = InstructionFactory.create(codeAttribute.code, offset2);
            instruction2.accept(clazz, method, codeAttribute, offset2, this.instructionSimplifier);
        }
        this.maxMarkedOffset = -1;
        int superInitializationOffset = this.partialEvaluator.superInitializationOffset();
        if (superInitializationOffset != -2) {
            this.markInstruction(superInitializationOffset);
        }
        for (offset = 0; offset < codeLength; ++offset) {
            if (!this.partialEvaluator.isTraced(offset)) continue;
            Instruction instruction3 = InstructionFactory.create(codeAttribute.code, offset);
            if (instruction3.opcode == -89 && ((BranchInstruction)instruction3).branchOffset == 0) {
                this.markInstruction(offset);
                continue;
            }
            if (!this.sideEffectInstructionChecker.hasSideEffects(clazz, method, codeAttribute, offset, instruction3)) continue;
            this.markInstruction(offset);
        }
        while (this.maxMarkedOffset >= 0) {
            offset = this.maxMarkedOffset;
            this.maxMarkedOffset = offset - 1;
            if (!this.partialEvaluator.isTraced(offset)) continue;
            if (this.isInstructionNecessary(offset)) {
                if (this.isInstructionSimplified(offset)) {
                    int variableIndex = this.getAliasingVariable(offset);
                    if (variableIndex >= 0) {
                        this.markVariableProducers(offset, variableIndex);
                    }
                } else {
                    Instruction instruction4 = InstructionFactory.create(codeAttribute.code, offset);
                    instruction4.accept(clazz, method, codeAttribute, offset, this.producerMarker);
                }
            }
            this.markStraddlingBranches(offset, this.partialEvaluator.branchTargets(offset), true);
            this.markStraddlingBranches(offset, this.partialEvaluator.branchOrigins(offset), false);
        }
        for (offset = 0; offset < codeLength; ++offset) {
            int variableIndex;
            if (!this.partialEvaluator.isTraced(offset) || this.isInstructionNecessary(offset) || (variableIndex = this.partialEvaluator.initializedVariable(offset)) < 0 || !this.isVariableInitializationNecessary(clazz, method, codeAttribute, offset, variableIndex)) continue;
            this.markInstruction(offset);
        }
        this.maxMarkedOffset = codeLength - 1;
        while (this.maxMarkedOffset >= 0) {
            offset = this.maxMarkedOffset;
            this.maxMarkedOffset = offset - 1;
            if (!this.partialEvaluator.isTraced(offset)) continue;
            Instruction instruction5 = InstructionFactory.create(codeAttribute.code, offset);
            instruction5.accept(clazz, method, codeAttribute, offset, this.stackConsistencyFixer);
            this.markStraddlingBranches(offset, this.partialEvaluator.branchTargets(offset), true);
            this.markStraddlingBranches(offset, this.partialEvaluator.branchOrigins(offset), false);
        }
        for (offset = 0; offset < codeLength; ++offset) {
            if (!this.partialEvaluator.isTraced(offset) || this.isInstructionNecessary(offset) || !this.isAllSmallerThanOrEqual(this.partialEvaluator.branchTargets(offset), offset) || this.isAnyUnnecessaryInstructionBranchingOver(this.lastNecessaryInstructionOffset(offset), offset)) continue;
            Instruction instruction6 = InstructionFactory.create(codeAttribute.code, offset);
            this.replaceByInfiniteLoop(clazz, offset, instruction6);
        }
        offset = 0;
        do {
            instruction = InstructionFactory.create(codeAttribute.code, offset);
            if (this.isInstructionNecessary(offset)) continue;
            this.codeAttributeEditor.deleteInstruction(offset);
            this.codeAttributeEditor.insertBeforeInstruction(offset, null);
            this.codeAttributeEditor.replaceInstruction(offset, null);
            this.codeAttributeEditor.insertAfterInstruction(offset, null);
            if (this.extraDeletedInstructionVisitor == null) continue;
            instruction.accept(clazz, method, codeAttribute, offset, this.extraDeletedInstructionVisitor);
        } while ((offset += instruction.length(offset)) < codeLength);
        this.codeAttributeEditor.visitCodeAttribute(clazz, method, codeAttribute);
    }

    private void markVariableProducers(int consumerOffset, int variableIndex) {
        TracedVariables tracedVariables = this.partialEvaluator.getVariablesBefore(consumerOffset);
        this.markVariableProducers(tracedVariables.getProducerValue(variableIndex).instructionOffsetValue(), variableIndex);
    }

    private void markVariableProducers(InstructionOffsetValue producerOffsets, int variableIndex) {
        if (producerOffsets != null) {
            int offsetCount = producerOffsets.instructionOffsetCount();
            for (int offsetIndex = 0; offsetIndex < offsetCount; ++offsetIndex) {
                int offset = producerOffsets.instructionOffset(offsetIndex);
                this.markVariableAfter(offset, variableIndex);
                this.markInstruction(offset);
            }
        }
    }

    private void markStackProducers(Clazz clazz, int consumerOffset, Instruction consumer) {
        int popCount = consumer.stackPopCount(clazz);
        for (int stackIndex = 0; stackIndex < popCount; ++stackIndex) {
            this.markStackEntryProducers(consumerOffset, stackIndex);
        }
    }

    private void conditionallyMarkStackEntryProducers(int consumerOffset, int consumerStackIndex, int producerStackIndex) {
        int top = this.partialEvaluator.getStackAfter(consumerOffset).size() - 1;
        if (this.isStackEntryNecessaryAfter(consumerOffset, top - consumerStackIndex)) {
            this.markStackEntryProducers(consumerOffset, producerStackIndex);
        }
    }

    private void markStackEntryProducers(int consumerOffset, int stackIndex) {
        TracedStack tracedStack = this.partialEvaluator.getStackBefore(consumerOffset);
        int stackBottomIndex = tracedStack.size() - 1 - stackIndex;
        if (!this.isStackSimplifiedBefore(consumerOffset, stackBottomIndex)) {
            this.markStackEntryProducers(tracedStack.getTopProducerValue(stackIndex).instructionOffsetValue(), stackBottomIndex);
        }
    }

    private void markStackEntryProducers(InstructionOffsetValue producerOffsets, int stackIndex) {
        if (producerOffsets != null) {
            int offsetCount = producerOffsets.instructionOffsetCount();
            for (int offsetIndex = 0; offsetIndex < offsetCount; ++offsetIndex) {
                int offset = producerOffsets.instructionOffset(offsetIndex);
                this.markStackEntryAfter(offset, stackIndex);
                this.markInstruction(offset);
            }
        }
    }

    private void markInitialization(int newInstructionOffset) {
        int initializationOffset = this.partialEvaluator.initializationOffset(newInstructionOffset);
        TracedStack tracedStack = this.partialEvaluator.getStackAfter(newInstructionOffset);
        this.markStackEntryAfter(initializationOffset, tracedStack.size() - 1);
        this.markInstruction(initializationOffset);
    }

    private void markStraddlingBranches(int instructionOffset, InstructionOffsetValue branchOffsets, boolean isPointingToTargets) {
        if (branchOffsets != null) {
            int branchCount = branchOffsets.instructionOffsetCount();
            for (int branchIndex = 0; branchIndex < branchCount; ++branchIndex) {
                int branchOffset = branchOffsets.instructionOffset(branchIndex);
                if (isPointingToTargets) {
                    this.markStraddlingBranch(instructionOffset, branchOffset, instructionOffset, branchOffset);
                    continue;
                }
                this.markStraddlingBranch(instructionOffset, branchOffset, branchOffset, instructionOffset);
            }
        }
    }

    private void markStraddlingBranch(int instructionOffsetStart, int instructionOffsetEnd, int branchOrigin, int branchTarget) {
        if (!this.isInstructionNecessary(branchOrigin) && this.isAnyInstructionNecessary(instructionOffsetStart, instructionOffsetEnd)) {
            this.markInstruction(branchOrigin);
        }
    }

    private void fixDupInstruction(Clazz clazz, CodeAttribute codeAttribute, int dupOffset, Instruction instruction) {
        int top = this.partialEvaluator.getStackAfter(dupOffset).size() - 1;
        int oldOpcode = instruction.opcode;
        int newOpcode = 0;
        switch (oldOpcode) {
            case 89: {
                boolean stackEntryPresent0 = this.isStackEntryNecessaryAfter(dupOffset, top - 0);
                boolean stackEntryPresent1 = this.isStackEntryNecessaryAfter(dupOffset, top - 1);
                if (!stackEntryPresent0 && !stackEntryPresent1 || !stackEntryPresent0 || !stackEntryPresent1) break;
                newOpcode = 89;
                break;
            }
            case 90: {
                int skipCount;
                boolean stackEntryPresent0 = this.isStackEntryNecessaryAfter(dupOffset, top - 0);
                boolean stackEntryPresent1 = this.isStackEntryNecessaryAfter(dupOffset, top - 1);
                boolean stackEntryPresent2 = this.isStackEntryNecessaryAfter(dupOffset, top - 2);
                if (!stackEntryPresent0 && !stackEntryPresent2 || !stackEntryPresent2) break;
                int n = skipCount = stackEntryPresent1 ? 1 : 0;
                if (stackEntryPresent0) {
                    newOpcode = (byte)(89 + skipCount);
                    break;
                }
                if (skipCount != 1) break;
                newOpcode = 95;
                break;
            }
            case 91: {
                boolean stackEntryPresent0 = this.isStackEntryNecessaryAfter(dupOffset, top - 0);
                boolean stackEntryPresent1 = this.isStackEntryNecessaryAfter(dupOffset, top - 1);
                boolean stackEntryPresent2 = this.isStackEntryNecessaryAfter(dupOffset, top - 2);
                boolean stackEntryPresent3 = this.isStackEntryNecessaryAfter(dupOffset, top - 3);
                if (!stackEntryPresent0 && !stackEntryPresent3 || !stackEntryPresent3) break;
                int skipCount = (stackEntryPresent1 ? 1 : 0) + (stackEntryPresent2 ? 1 : 0);
                if (stackEntryPresent0) {
                    newOpcode = (byte)(89 + skipCount);
                    break;
                }
                if (skipCount == 1) {
                    newOpcode = 95;
                    break;
                }
                if (skipCount != 2) break;
                throw new UnsupportedOperationException("Can't handle dup_x2 instruction moving original element across two elements at [" + dupOffset + "]");
            }
            case 92: {
                boolean stackEntriesPresent01 = this.isStackEntriesNecessaryAfter(dupOffset, top - 0, top - 1);
                boolean stackEntriesPresent23 = this.isStackEntriesNecessaryAfter(dupOffset, top - 2, top - 3);
                if (!stackEntriesPresent01 && !stackEntriesPresent23 || !stackEntriesPresent01 || !stackEntriesPresent23) break;
                newOpcode = 92;
                break;
            }
            case 93: {
                int skipCount;
                boolean stackEntriesPresent01 = this.isStackEntriesNecessaryAfter(dupOffset, top - 0, top - 1);
                boolean stackEntryPresent2 = this.isStackEntryNecessaryAfter(dupOffset, top - 2);
                boolean stackEntriesPresent34 = this.isStackEntriesNecessaryAfter(dupOffset, top - 3, top - 4);
                if (!stackEntriesPresent01 && !stackEntriesPresent34 || !stackEntriesPresent34) break;
                int n = skipCount = stackEntryPresent2 ? 1 : 0;
                if (stackEntriesPresent01) {
                    newOpcode = (byte)(92 + skipCount);
                    break;
                }
                if (skipCount <= 0) break;
                throw new UnsupportedOperationException("Can't handle dup2_x1 instruction moving original element across " + skipCount + " elements at [" + dupOffset + "]");
            }
            case 94: {
                boolean stackEntriesPresent01 = this.isStackEntriesNecessaryAfter(dupOffset, top - 0, top - 1);
                boolean stackEntryPresent2 = this.isStackEntryNecessaryAfter(dupOffset, top - 2);
                boolean stackEntryPresent3 = this.isStackEntryNecessaryAfter(dupOffset, top - 3);
                boolean stackEntriesPresent45 = this.isStackEntriesNecessaryAfter(dupOffset, top - 4, top - 5);
                if (!stackEntriesPresent01 && !stackEntriesPresent45 || !stackEntriesPresent45) break;
                int skipCount = (stackEntryPresent2 ? 1 : 0) + (stackEntryPresent3 ? 1 : 0);
                if (stackEntriesPresent01) {
                    newOpcode = (byte)(92 + skipCount);
                    break;
                }
                if (skipCount <= 0) break;
                throw new UnsupportedOperationException("Can't handle dup2_x2 instruction moving original element across " + skipCount + " elements at [" + dupOffset + "]");
            }
            case 95: {
                boolean stackEntryPresent0 = this.isStackEntryNecessaryAfter(dupOffset, top - 0);
                boolean stackEntryPresent1 = this.isStackEntryNecessaryAfter(dupOffset, top - 1);
                if (!stackEntryPresent0 && !stackEntryPresent1 || !stackEntryPresent0 || !stackEntryPresent1) break;
                newOpcode = 95;
                break;
            }
        }
        if (newOpcode == 0) {
            this.codeAttributeEditor.deleteInstruction(dupOffset);
            if (this.extraDeletedInstructionVisitor != null) {
                this.extraDeletedInstructionVisitor.visitSimpleInstruction(null, null, null, dupOffset, null);
            }
        } else if (newOpcode == oldOpcode) {
            this.codeAttributeEditor.undeleteInstruction(dupOffset);
        } else {
            SimpleInstruction replacementInstruction = new SimpleInstruction((byte)newOpcode);
            this.codeAttributeEditor.replaceInstruction(dupOffset, replacementInstruction);
        }
    }

    private void increaseStackSize(int offset, int computationalType, boolean delete) {
        this.markInstruction(offset);
        SimpleInstruction replacementInstruction = new SimpleInstruction(this.pushOpcode(computationalType));
        if (delete) {
            this.codeAttributeEditor.replaceInstruction(offset, replacementInstruction);
        } else {
            this.codeAttributeEditor.insertBeforeInstruction(offset, replacementInstruction);
            if (this.extraAddedInstructionVisitor != null) {
                ((Instruction)replacementInstruction).accept(null, null, null, offset, this.extraAddedInstructionVisitor);
            }
        }
    }

    private byte pushOpcode(int computationalType) {
        switch (computationalType) {
            case 1: {
                return 3;
            }
            case 2: {
                return 9;
            }
            case 3: {
                return 11;
            }
            case 4: {
                return 14;
            }
            case 5: 
            case 6: {
                return 1;
            }
        }
        throw new IllegalArgumentException("No push opcode for computational type [" + computationalType + "]");
    }

    private void decreaseStackSize(int offset, int popCount, boolean before, boolean delete) {
        SimpleInstruction replacementInstruction;
        byte replacementOpcode;
        int count;
        this.markInstruction(offset);
        boolean after = !before;
        int remainingPopCount = popCount;
        if (delete) {
            count = remainingPopCount == 1 ? 1 : 2;
            replacementOpcode = count == 1 ? (byte)87 : 88;
            replacementInstruction = new SimpleInstruction(replacementOpcode);
            this.codeAttributeEditor.replaceInstruction(offset, replacementInstruction);
            remainingPopCount -= count;
            before = true;
            after = true;
        }
        if (before && remainingPopCount > 0) {
            count = remainingPopCount == 1 ? 1 : 2;
            replacementOpcode = count == 1 ? (byte)87 : 88;
            replacementInstruction = new SimpleInstruction(replacementOpcode);
            this.codeAttributeEditor.insertBeforeInstruction(offset, replacementInstruction);
            remainingPopCount -= count;
            if (this.extraAddedInstructionVisitor != null) {
                ((Instruction)replacementInstruction).accept(null, null, null, offset, this.extraAddedInstructionVisitor);
            }
        }
        if (after && remainingPopCount > 0) {
            count = remainingPopCount == 1 ? 1 : 2;
            replacementOpcode = count == 1 ? (byte)87 : 88;
            replacementInstruction = new SimpleInstruction(replacementOpcode);
            this.codeAttributeEditor.insertAfterInstruction(offset, replacementInstruction);
            remainingPopCount -= count;
            if (this.extraAddedInstructionVisitor != null) {
                ((Instruction)replacementInstruction).accept(null, null, null, offset, this.extraAddedInstructionVisitor);
            }
        }
        if (remainingPopCount > 0) {
            throw new UnsupportedOperationException("Unsupported stack size reduction [" + popCount + "]");
        }
    }

    private void replaceAnyPushInstruction(Clazz clazz, int offset, Instruction instruction) {
        Value pushedValue = this.partialEvaluator.getStackAfter(offset).getTop(0);
        if (pushedValue.isParticular()) {
            switch (pushedValue.computationalType()) {
                case 1: {
                    this.replaceIntegerPushInstruction(clazz, offset, instruction);
                    break;
                }
                case 2: {
                    this.replaceLongPushInstruction(clazz, offset, instruction);
                    break;
                }
                case 3: {
                    this.replaceFloatPushInstruction(clazz, offset, instruction);
                    break;
                }
                case 4: {
                    this.replaceDoublePushInstruction(clazz, offset, instruction);
                    break;
                }
                case 5: {
                    this.replaceReferencePushInstruction(clazz, offset, instruction);
                }
            }
        }
    }

    private void replaceIntegerPushInstruction(Clazz clazz, int offset, Instruction instruction) {
        this.replaceIntegerPushInstruction(clazz, offset, instruction, this.partialEvaluator.getVariablesBefore(offset).size());
    }

    private void replaceIntegerPushInstruction(Clazz clazz, int offset, Instruction instruction, int maxVariableIndex) {
        Value pushedValue = this.partialEvaluator.getStackAfter(offset).getTop(0);
        if (pushedValue.isParticular()) {
            int value = pushedValue.integerValue().value();
            if (value << 16 >> 16 == value) {
                this.replaceConstantPushInstruction(clazz, offset, instruction, (byte)17, value);
            }
        } else if (pushedValue.isSpecific()) {
            TracedVariables variables = this.partialEvaluator.getVariablesBefore(offset);
            for (int variableIndex = 0; variableIndex < maxVariableIndex; ++variableIndex) {
                if (!pushedValue.equals(variables.load(variableIndex))) continue;
                this.replaceVariablePushInstruction(clazz, offset, instruction, (byte)21, variableIndex);
            }
        }
    }

    private void replaceLongPushInstruction(Clazz clazz, int offset, Instruction instruction) {
        this.replaceLongPushInstruction(clazz, offset, instruction, this.partialEvaluator.getVariablesBefore(offset).size());
    }

    private void replaceLongPushInstruction(Clazz clazz, int offset, Instruction instruction, int maxVariableIndex) {
        Value pushedValue = this.partialEvaluator.getStackAfter(offset).getTop(0);
        if (pushedValue.isParticular()) {
            long value = pushedValue.longValue().value();
            if (value == 0L || value == 1L) {
                this.replaceConstantPushInstruction(clazz, offset, instruction, (byte)9, (int)value);
            }
        } else if (pushedValue.isSpecific()) {
            TracedVariables variables = this.partialEvaluator.getVariablesBefore(offset);
            for (int variableIndex = 0; variableIndex < maxVariableIndex; ++variableIndex) {
                if (!pushedValue.equals(variables.load(variableIndex))) continue;
                this.replaceVariablePushInstruction(clazz, offset, instruction, (byte)22, variableIndex);
            }
        }
    }

    private void replaceFloatPushInstruction(Clazz clazz, int offset, Instruction instruction) {
        this.replaceFloatPushInstruction(clazz, offset, instruction, this.partialEvaluator.getVariablesBefore(offset).size());
    }

    private void replaceFloatPushInstruction(Clazz clazz, int offset, Instruction instruction, int maxVariableIndex) {
        Value pushedValue = this.partialEvaluator.getStackAfter(offset).getTop(0);
        if (pushedValue.isParticular()) {
            float value = pushedValue.floatValue().value();
            if (value == 0.0f || value == 1.0f || value == 2.0f) {
                this.replaceConstantPushInstruction(clazz, offset, instruction, (byte)11, (int)value);
            }
        } else if (pushedValue.isSpecific()) {
            TracedVariables variables = this.partialEvaluator.getVariablesBefore(offset);
            for (int variableIndex = 0; variableIndex < maxVariableIndex; ++variableIndex) {
                if (!pushedValue.equals(variables.load(variableIndex))) continue;
                this.replaceVariablePushInstruction(clazz, offset, instruction, (byte)23, variableIndex);
            }
        }
    }

    private void replaceDoublePushInstruction(Clazz clazz, int offset, Instruction instruction) {
        this.replaceDoublePushInstruction(clazz, offset, instruction, this.partialEvaluator.getVariablesBefore(offset).size());
    }

    private void replaceDoublePushInstruction(Clazz clazz, int offset, Instruction instruction, int maxVariableIndex) {
        Value pushedValue = this.partialEvaluator.getStackAfter(offset).getTop(0);
        if (pushedValue.isParticular()) {
            double value = pushedValue.doubleValue().value();
            if (value == 0.0 || value == 1.0) {
                this.replaceConstantPushInstruction(clazz, offset, instruction, (byte)14, (int)value);
            }
        } else if (pushedValue.isSpecific()) {
            TracedVariables variables = this.partialEvaluator.getVariablesBefore(offset);
            for (int variableIndex = 0; variableIndex < maxVariableIndex; ++variableIndex) {
                if (!pushedValue.equals(variables.load(variableIndex))) continue;
                this.replaceVariablePushInstruction(clazz, offset, instruction, (byte)24, variableIndex);
            }
        }
    }

    private void replaceReferencePushInstruction(Clazz clazz, int offset, Instruction instruction) {
        Value pushedValue = this.partialEvaluator.getStackAfter(offset).getTop(0);
        if (pushedValue.isParticular()) {
            this.replaceConstantPushInstruction(clazz, offset, instruction, (byte)1, 0);
        }
    }

    private void replaceConstantPushInstruction(Clazz clazz, int offset, Instruction instruction, byte replacementOpcode, int value) {
        this.replacePushInstruction(clazz, offset, instruction, new SimpleInstruction(replacementOpcode, value).shrink());
    }

    private void replaceVariablePushInstruction(Clazz clazz, int offset, Instruction instruction, byte replacementOpcode, int variableIndex) {
        this.replacePushInstruction(clazz, offset, instruction, new VariableInstruction(replacementOpcode, variableIndex).shrink());
        this.setAliasingVariable(offset, variableIndex);
    }

    private void replacePushInstruction(Clazz clazz, int offset, Instruction instruction, Instruction replacementInstruction) {
        this.codeAttributeEditor.replaceInstruction(offset, replacementInstruction);
        this.markSimplification(clazz, offset, instruction);
        if (this.extraPushInstructionVisitor != null) {
            this.extraPushInstructionVisitor.visitSimpleInstruction(null, null, null, offset, null);
        }
    }

    private void replaceInvocationInstruction(Clazz clazz, int offset, ConstantInstruction constantInstruction) {
        Instruction replacementInstruction = new ConstantInstruction(-72, constantInstruction.constantIndex).shrink();
        this.codeAttributeEditor.replaceInstruction(offset, replacementInstruction);
    }

    private void replaceJsrInstruction(Clazz clazz, int offset, BranchInstruction branchInstruction) {
        if (!this.partialEvaluator.isSubroutineReturning(offset + branchInstruction.branchOffset)) {
            this.replaceBranchInstruction(clazz, offset, branchInstruction);
        } else if (!this.partialEvaluator.isTraced(offset + branchInstruction.length(offset))) {
            this.replaceByInfiniteLoop(clazz, offset + branchInstruction.length(offset), branchInstruction);
        }
    }

    private void replaceBranchInstruction(Clazz clazz, int offset, Instruction instruction) {
        int branchOffset;
        InstructionOffsetValue branchTargets = this.partialEvaluator.branchTargets(offset);
        if (branchTargets != null && branchTargets.instructionOffsetCount() == 1 && (branchOffset = branchTargets.instructionOffset(0) - offset) != instruction.length(offset)) {
            Instruction replacementInstruction = new BranchInstruction(-56, branchOffset).shrink();
            this.codeAttributeEditor.replaceInstruction(offset, replacementInstruction);
            this.markSimplification(clazz, offset, instruction);
            if (this.extraBranchInstructionVisitor != null) {
                this.extraBranchInstructionVisitor.visitBranchInstruction(null, null, null, offset, null);
            }
        }
    }

    private void replaceSwitchInstruction(Clazz clazz, int offset, SwitchInstruction switchInstruction) {
        InstructionOffsetValue branchTargets = this.partialEvaluator.branchTargets(offset);
        int defaultOffset = branchTargets.instructionOffset(branchTargets.instructionOffsetCount() - 1) - offset;
        SwitchInstruction replacementInstruction = null;
        int[] jumpOffsets = switchInstruction.jumpOffsets;
        for (int index = 0; index < jumpOffsets.length; ++index) {
            if (branchTargets.contains(offset + jumpOffsets[index])) continue;
            jumpOffsets[index] = defaultOffset;
            replacementInstruction = switchInstruction;
        }
        if (!branchTargets.contains(offset + switchInstruction.defaultOffset)) {
            switchInstruction.defaultOffset = defaultOffset;
            replacementInstruction = switchInstruction;
        }
        if (replacementInstruction != null) {
            this.codeAttributeEditor.replaceInstruction(offset, replacementInstruction);
            if (this.extraBranchInstructionVisitor != null) {
                this.extraBranchInstructionVisitor.visitBranchInstruction(null, null, null, offset, null);
            }
        }
    }

    private void replaceByInfiniteLoop(Clazz clazz, int offset, Instruction instruction) {
        BranchInstruction replacementInstruction = new BranchInstruction(-89, 0);
        this.codeAttributeEditor.replaceInstruction(offset, replacementInstruction);
        this.markInstruction(offset);
        this.markSimplification(clazz, offset, instruction);
    }

    private boolean isDupOrSwap(Instruction instruction) {
        return instruction.opcode >= 89 && instruction.opcode <= 95;
    }

    private boolean isPop(Instruction instruction) {
        return instruction.opcode == 87 || instruction.opcode == 88;
    }

    private boolean isAnyUnnecessaryInstructionBranchingOver(int instructionOffset1, int instructionOffset2) {
        for (int offset = instructionOffset1; offset < instructionOffset2; ++offset) {
            if (!this.partialEvaluator.isTraced(offset) || this.isInstructionNecessary(offset) || !this.isAnyLargerThan(this.partialEvaluator.branchTargets(offset), instructionOffset2)) continue;
            return true;
        }
        return false;
    }

    private boolean isAllSmallerThanOrEqual(InstructionOffsetValue instructionOffsets, int instructionOffset) {
        int branchCount;
        if (instructionOffsets != null && (branchCount = instructionOffsets.instructionOffsetCount()) > 0) {
            for (int branchIndex = 0; branchIndex < branchCount; ++branchIndex) {
                if (instructionOffsets.instructionOffset(branchIndex) <= instructionOffset) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isAnyLargerThan(InstructionOffsetValue instructionOffsets, int instructionOffset) {
        int branchCount;
        if (instructionOffsets != null && (branchCount = instructionOffsets.instructionOffsetCount()) > 0) {
            for (int branchIndex = 0; branchIndex < branchCount; ++branchIndex) {
                if (instructionOffsets.instructionOffset(branchIndex) <= instructionOffset) continue;
                return true;
            }
        }
        return false;
    }

    private void initializeNecessary(CodeAttribute codeAttribute) {
        int index;
        int index2;
        int offset;
        int codeLength = codeAttribute.u4codeLength;
        int maxLocals = codeAttribute.u2maxLocals;
        int maxStack = codeAttribute.u2maxStack;
        if (this.variablesNecessaryAfter.length < codeLength || this.variablesNecessaryAfter[0].length < maxLocals) {
            this.variablesNecessaryAfter = new boolean[codeLength][maxLocals];
        } else {
            for (offset = 0; offset < codeLength; ++offset) {
                for (index2 = 0; index2 < maxLocals; ++index2) {
                    this.variablesNecessaryAfter[offset][index2] = false;
                }
            }
        }
        if (this.stacksNecessaryAfter.length < codeLength || this.stacksNecessaryAfter[0].length < maxStack) {
            this.stacksNecessaryAfter = new boolean[codeLength][maxStack];
        } else {
            for (offset = 0; offset < codeLength; ++offset) {
                for (index2 = 0; index2 < maxStack; ++index2) {
                    this.stacksNecessaryAfter[offset][index2] = false;
                }
            }
        }
        if (this.stacksSimplifiedBefore.length < codeLength || this.stacksSimplifiedBefore[0].length < maxStack) {
            this.stacksSimplifiedBefore = new boolean[codeLength][maxStack];
        } else {
            for (offset = 0; offset < codeLength; ++offset) {
                for (index2 = 0; index2 < maxStack; ++index2) {
                    this.stacksSimplifiedBefore[offset][index2] = false;
                }
            }
        }
        if (this.instructionsNecessary.length < codeLength) {
            this.instructionsNecessary = new boolean[codeLength];
            this.instructionsSimplified = new boolean[codeLength];
            this.aliasingVariables = new int[codeLength];
        } else {
            for (index = 0; index < codeLength; ++index) {
                this.instructionsNecessary[index] = false;
                this.instructionsSimplified[index] = false;
            }
        }
        for (index = 0; index < codeLength; ++index) {
            this.aliasingVariables[index] = -1;
        }
    }

    private boolean isStackEntriesNecessaryAfter(int instructionOffset, int stackIndex1, int stackIndex2) {
        boolean present1 = this.isStackEntryNecessaryAfter(instructionOffset, stackIndex1);
        boolean present2 = this.isStackEntryNecessaryAfter(instructionOffset, stackIndex2);
        return present1 || present2;
    }

    private boolean isVariableInitializationNecessary(Clazz clazz, Method method, CodeAttribute codeAttribute, int initializationOffset, int variableIndex) {
        int codeLength = codeAttribute.u4codeLength;
        if (this.isVariableNecessaryAfterAny(0, codeLength, variableIndex)) {
            this.simplePartialEvaluator.visitCodeAttribute(clazz, method, codeAttribute);
            for (int offset = 0; offset < codeLength; ++offset) {
                Value simpleProducer;
                Value producer;
                if (!this.isInstructionNecessary(offset) || (producer = this.partialEvaluator.getVariablesBefore(offset).getProducerValue(variableIndex)) == null || (simpleProducer = this.simplePartialEvaluator.getVariablesBefore(offset).getProducerValue(variableIndex)) == null) continue;
                InstructionOffsetValue producerOffsets = producer.instructionOffsetValue();
                InstructionOffsetValue simpleProducerOffsets = simpleProducer.instructionOffsetValue();
                if (producerOffsets.instructionOffsetCount() >= simpleProducerOffsets.instructionOffsetCount() || !this.isVariableNecessaryAfterAny(producerOffsets, variableIndex) || !simpleProducerOffsets.contains(initializationOffset)) continue;
                return true;
            }
        }
        return false;
    }

    private void markVariableAfter(int instructionOffset, int variableIndex) {
        if (!this.isVariableNecessaryAfter(instructionOffset, variableIndex)) {
            this.variablesNecessaryAfter[instructionOffset][variableIndex] = true;
            if (this.maxMarkedOffset < instructionOffset) {
                this.maxMarkedOffset = instructionOffset;
            }
        }
    }

    private boolean isVariableNecessaryAfterAny(int startOffset, int endOffset, int variableIndex) {
        for (int offset = startOffset; offset < endOffset; ++offset) {
            if (!this.isVariableNecessaryAfter(offset, variableIndex)) continue;
            return true;
        }
        return false;
    }

    private boolean isVariableNecessaryAfterAny(InstructionOffsetValue instructionOffsetValue, int variableIndex) {
        int count = instructionOffsetValue.instructionOffsetCount();
        for (int index = 0; index < count; ++index) {
            if (!this.isVariableNecessaryAfter(instructionOffsetValue.instructionOffset(index), variableIndex)) continue;
            return true;
        }
        return false;
    }

    private boolean isVariableNecessaryAfter(int instructionOffset, int variableIndex) {
        return instructionOffset == -1 || this.variablesNecessaryAfter[instructionOffset][variableIndex];
    }

    private void markStackEntryAfter(int instructionOffset, int stackIndex) {
        if (!this.isStackEntryNecessaryAfter(instructionOffset, stackIndex)) {
            this.stacksNecessaryAfter[instructionOffset][stackIndex] = true;
            if (this.maxMarkedOffset < instructionOffset) {
                this.maxMarkedOffset = instructionOffset;
            }
        }
    }

    private boolean isAnyStackEntryNecessaryAfter(InstructionOffsetValue instructionOffsets, int stackIndex) {
        int offsetCount = instructionOffsets.instructionOffsetCount();
        for (int offsetIndex = 0; offsetIndex < offsetCount; ++offsetIndex) {
            if (!this.isStackEntryNecessaryAfter(instructionOffsets.instructionOffset(offsetIndex), stackIndex)) continue;
            return true;
        }
        return false;
    }

    private boolean isStackEntryNecessaryAfter(int instructionOffset, int stackIndex) {
        return instructionOffset == -1 || this.stacksNecessaryAfter[instructionOffset][stackIndex];
    }

    private void markStackSimplificationBefore(int instructionOffset, int stackIndex) {
        this.stacksSimplifiedBefore[instructionOffset][stackIndex] = true;
    }

    private boolean isStackSimplifiedBefore(int instructionOffset, int stackIndex) {
        return this.stacksSimplifiedBefore[instructionOffset][stackIndex];
    }

    private void markSimplification(Clazz clazz, int instructionOffset, Instruction instruction) {
        this.instructionsSimplified[instructionOffset] = true;
        TracedStack tracedStack = this.partialEvaluator.getStackBefore(instructionOffset);
        int top = tracedStack.size() - 1;
        int popCount = instruction.stackPopCount(clazz);
        for (int stackIndex = 0; stackIndex < popCount; ++stackIndex) {
            this.markStackSimplificationBefore(instructionOffset, top - stackIndex);
        }
    }

    private boolean isInstructionSimplified(int instructionOffset) {
        return this.instructionsSimplified[instructionOffset];
    }

    private void setAliasingVariable(int instructionOffset, int variableIndex) {
        this.aliasingVariables[instructionOffset] = variableIndex;
    }

    private int getAliasingVariable(int instructionOffset) {
        return this.aliasingVariables[instructionOffset];
    }

    private void markInstruction(int instructionOffset) {
        if (!this.isInstructionNecessary(instructionOffset)) {
            this.instructionsNecessary[instructionOffset] = true;
            if (this.maxMarkedOffset < instructionOffset) {
                this.maxMarkedOffset = instructionOffset;
            }
        }
    }

    private boolean isAnyInstructionNecessary(int instructionOffset1, int instructionOffset2) {
        for (int instructionOffset = instructionOffset1; instructionOffset < instructionOffset2; ++instructionOffset) {
            if (!this.isInstructionNecessary(instructionOffset)) continue;
            return true;
        }
        return false;
    }

    private int lastNecessaryInstructionOffset(int instructionOffset) {
        for (int offset = instructionOffset - 1; offset >= 0; --offset) {
            if (!this.isInstructionNecessary(instructionOffset)) continue;
            return offset;
        }
        return 0;
    }

    private boolean isInstructionNecessary(int instructionOffset) {
        return instructionOffset == -1 || this.instructionsNecessary[instructionOffset];
    }

    private class MyStackConsistencyFixer
    extends SimplifiedVisitor
    implements InstructionVisitor {
        private MyStackConsistencyFixer() {
        }

        public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
            if (EvaluationSimplifier.this.isInstructionNecessary(offset)) {
                int pushCount;
                int popCount = instruction.stackPopCount(clazz);
                if (popCount > 0) {
                    TracedStack tracedStack = EvaluationSimplifier.this.partialEvaluator.getStackBefore(offset);
                    int top = tracedStack.size() - 1;
                    int requiredPushCount = 0;
                    for (int stackIndex = 0; stackIndex < popCount; ++stackIndex) {
                        if (EvaluationSimplifier.this.isStackSimplifiedBefore(offset, top - stackIndex) || EvaluationSimplifier.this.isAnyStackEntryNecessaryAfter(tracedStack.getTopProducerValue(stackIndex).instructionOffsetValue(), top - stackIndex)) continue;
                        ++requiredPushCount;
                    }
                    if (requiredPushCount > 0) {
                        if (requiredPushCount > (instruction.isCategory2() ? 2 : 1)) {
                            throw new IllegalArgumentException("Unsupported stack size increment [" + requiredPushCount + "]");
                        }
                        EvaluationSimplifier.this.increaseStackSize(offset, tracedStack.getTop(0).computationalType(), false);
                    }
                }
                if ((pushCount = instruction.stackPushCount(clazz)) > 0) {
                    TracedStack tracedStack = EvaluationSimplifier.this.partialEvaluator.getStackAfter(offset);
                    int top = tracedStack.size() - 1;
                    int requiredPopCount = 0;
                    for (int stackIndex = 0; stackIndex < pushCount; ++stackIndex) {
                        if (EvaluationSimplifier.this.isStackEntryNecessaryAfter(offset, top - stackIndex)) continue;
                        ++requiredPopCount;
                    }
                    if (requiredPopCount > 0) {
                        EvaluationSimplifier.this.decreaseStackSize(offset, requiredPopCount, false, false);
                    }
                }
            } else {
                int pushCount;
                int popCount = instruction.stackPopCount(clazz);
                if (popCount > 0) {
                    TracedStack tracedStack = EvaluationSimplifier.this.partialEvaluator.getStackBefore(offset);
                    int top = tracedStack.size() - 1;
                    int expectedPopCount = 0;
                    for (int stackIndex = 0; stackIndex < popCount; ++stackIndex) {
                        if (!EvaluationSimplifier.this.isAnyStackEntryNecessaryAfter(tracedStack.getTopProducerValue(stackIndex).instructionOffsetValue(), top - stackIndex)) continue;
                        ++expectedPopCount;
                    }
                    if (expectedPopCount > 0) {
                        EvaluationSimplifier.this.decreaseStackSize(offset, expectedPopCount, true, true);
                    }
                }
                if ((pushCount = instruction.stackPushCount(clazz)) > 0) {
                    TracedStack tracedStack = EvaluationSimplifier.this.partialEvaluator.getStackAfter(offset);
                    int top = tracedStack.size() - 1;
                    int expectedPushCount = 0;
                    for (int stackIndex = 0; stackIndex < pushCount; ++stackIndex) {
                        if (!EvaluationSimplifier.this.isStackEntryNecessaryAfter(offset, top - stackIndex)) continue;
                        ++expectedPushCount;
                    }
                    if (expectedPushCount > 0) {
                        EvaluationSimplifier.this.increaseStackSize(offset, tracedStack.getTop(0).computationalType(), true);
                    }
                }
            }
        }

        public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SimpleInstruction simpleInstruction) {
            if (EvaluationSimplifier.this.isInstructionNecessary(offset) && EvaluationSimplifier.this.isDupOrSwap(simpleInstruction)) {
                EvaluationSimplifier.this.fixDupInstruction(clazz, codeAttribute, offset, simpleInstruction);
            } else {
                this.visitAnyInstruction(clazz, method, codeAttribute, offset, simpleInstruction);
            }
        }
    }

    private class MyProducerMarker
    extends SimplifiedVisitor
    implements InstructionVisitor {
        private MyProducerMarker() {
        }

        public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
            EvaluationSimplifier.this.markStackProducers(clazz, offset, instruction);
        }

        public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SimpleInstruction simpleInstruction) {
            switch (simpleInstruction.opcode) {
                case 89: {
                    EvaluationSimplifier.this.conditionallyMarkStackEntryProducers(offset, 0, 0);
                    EvaluationSimplifier.this.conditionallyMarkStackEntryProducers(offset, 1, 0);
                    break;
                }
                case 90: {
                    EvaluationSimplifier.this.conditionallyMarkStackEntryProducers(offset, 0, 0);
                    EvaluationSimplifier.this.conditionallyMarkStackEntryProducers(offset, 1, 1);
                    EvaluationSimplifier.this.conditionallyMarkStackEntryProducers(offset, 2, 0);
                    break;
                }
                case 91: {
                    EvaluationSimplifier.this.conditionallyMarkStackEntryProducers(offset, 0, 0);
                    EvaluationSimplifier.this.conditionallyMarkStackEntryProducers(offset, 1, 1);
                    EvaluationSimplifier.this.conditionallyMarkStackEntryProducers(offset, 2, 2);
                    EvaluationSimplifier.this.conditionallyMarkStackEntryProducers(offset, 3, 0);
                    break;
                }
                case 92: {
                    EvaluationSimplifier.this.conditionallyMarkStackEntryProducers(offset, 0, 0);
                    EvaluationSimplifier.this.conditionallyMarkStackEntryProducers(offset, 1, 1);
                    EvaluationSimplifier.this.conditionallyMarkStackEntryProducers(offset, 2, 0);
                    EvaluationSimplifier.this.conditionallyMarkStackEntryProducers(offset, 3, 1);
                    break;
                }
                case 93: {
                    EvaluationSimplifier.this.conditionallyMarkStackEntryProducers(offset, 0, 0);
                    EvaluationSimplifier.this.conditionallyMarkStackEntryProducers(offset, 1, 1);
                    EvaluationSimplifier.this.conditionallyMarkStackEntryProducers(offset, 2, 2);
                    EvaluationSimplifier.this.conditionallyMarkStackEntryProducers(offset, 3, 0);
                    EvaluationSimplifier.this.conditionallyMarkStackEntryProducers(offset, 4, 1);
                    break;
                }
                case 94: {
                    EvaluationSimplifier.this.conditionallyMarkStackEntryProducers(offset, 0, 0);
                    EvaluationSimplifier.this.conditionallyMarkStackEntryProducers(offset, 1, 1);
                    EvaluationSimplifier.this.conditionallyMarkStackEntryProducers(offset, 2, 2);
                    EvaluationSimplifier.this.conditionallyMarkStackEntryProducers(offset, 3, 3);
                    EvaluationSimplifier.this.conditionallyMarkStackEntryProducers(offset, 4, 0);
                    EvaluationSimplifier.this.conditionallyMarkStackEntryProducers(offset, 5, 1);
                    break;
                }
                case 95: {
                    EvaluationSimplifier.this.conditionallyMarkStackEntryProducers(offset, 0, 1);
                    EvaluationSimplifier.this.conditionallyMarkStackEntryProducers(offset, 1, 0);
                    break;
                }
                default: {
                    EvaluationSimplifier.this.markStackProducers(clazz, offset, simpleInstruction);
                }
            }
        }

        public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, VariableInstruction variableInstruction) {
            if (variableInstruction.opcode < 54) {
                EvaluationSimplifier.this.markVariableProducers(offset, variableInstruction.variableIndex);
            } else {
                EvaluationSimplifier.this.markStackProducers(clazz, offset, variableInstruction);
            }
        }

        public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
            if (constantInstruction.opcode == -69) {
                EvaluationSimplifier.this.markInitialization(offset);
            }
            EvaluationSimplifier.this.markStackProducers(clazz, offset, constantInstruction);
        }

        public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, BranchInstruction branchInstruction) {
            if (branchInstruction.opcode == -88 || branchInstruction.opcode == -55) {
                EvaluationSimplifier.this.markStackEntryAfter(offset, 0);
            } else {
                EvaluationSimplifier.this.markStackProducers(clazz, offset, branchInstruction);
            }
        }
    }

    private class MyUnusedParameterSimplifier
    extends SimplifiedVisitor
    implements MemberVisitor {
        private int invocationOffset;
        private ConstantInstruction invocationInstruction;

        private MyUnusedParameterSimplifier(int invocationOffset, ConstantInstruction invocationInstruction) {
            this.invocationOffset = invocationOffset;
            this.invocationInstruction = invocationInstruction;
        }

        public void visitAnyMember(Clazz clazz, Member member) {
        }

        public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
            int parameterSize = ParameterUsageMarker.getParameterSize(programMethod);
            if ((programMethod.getAccessFlags() & 8) == 0 && !ParameterUsageMarker.isParameterUsed(programMethod, 0)) {
                EvaluationSimplifier.this.replaceInvocationInstruction(programClass, this.invocationOffset, this.invocationInstruction);
            }
            for (int index = 0; index < parameterSize; ++index) {
                if (ParameterUsageMarker.isParameterUsed(programMethod, index)) continue;
                TracedStack stack = EvaluationSimplifier.this.partialEvaluator.getStackBefore(this.invocationOffset);
                int stackIndex = stack.size() - parameterSize + index;
                EvaluationSimplifier.this.markStackSimplificationBefore(this.invocationOffset, stackIndex);
            }
        }
    }

    private class MyInstructionSimplifier
    extends SimplifiedVisitor
    implements InstructionVisitor {
        private MyInstructionSimplifier() {
        }

        public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SimpleInstruction simpleInstruction) {
            switch (simpleInstruction.opcode) {
                case -128: 
                case -126: 
                case -120: 
                case -117: 
                case -114: 
                case -111: 
                case -110: 
                case -109: 
                case 46: 
                case 51: 
                case 52: 
                case 53: 
                case 96: 
                case 100: 
                case 104: 
                case 108: 
                case 112: 
                case 116: 
                case 120: 
                case 122: 
                case 124: 
                case 126: {
                    EvaluationSimplifier.this.replaceIntegerPushInstruction(clazz, offset, simpleInstruction);
                    break;
                }
                case -127: 
                case -125: 
                case -123: 
                case -116: 
                case -113: 
                case 47: 
                case 97: 
                case 101: 
                case 105: 
                case 109: 
                case 113: 
                case 117: 
                case 121: 
                case 123: 
                case 125: 
                case 127: {
                    EvaluationSimplifier.this.replaceLongPushInstruction(clazz, offset, simpleInstruction);
                    break;
                }
                case -122: 
                case -119: 
                case -112: 
                case 48: 
                case 98: 
                case 102: 
                case 106: 
                case 110: 
                case 114: 
                case 118: {
                    EvaluationSimplifier.this.replaceFloatPushInstruction(clazz, offset, simpleInstruction);
                    break;
                }
                case -121: 
                case -118: 
                case -115: 
                case 49: 
                case 99: 
                case 103: 
                case 107: 
                case 111: 
                case 115: 
                case 119: {
                    EvaluationSimplifier.this.replaceDoublePushInstruction(clazz, offset, simpleInstruction);
                    break;
                }
                case 50: {
                    EvaluationSimplifier.this.replaceReferencePushInstruction(clazz, offset, simpleInstruction);
                }
            }
        }

        public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, VariableInstruction variableInstruction) {
            int variableIndex = variableInstruction.variableIndex;
            switch (variableInstruction.opcode) {
                case 21: 
                case 26: 
                case 27: 
                case 28: 
                case 29: {
                    EvaluationSimplifier.this.replaceIntegerPushInstruction(clazz, offset, variableInstruction, variableIndex);
                    break;
                }
                case 22: 
                case 30: 
                case 31: 
                case 32: 
                case 33: {
                    EvaluationSimplifier.this.replaceLongPushInstruction(clazz, offset, variableInstruction, variableIndex);
                    break;
                }
                case 23: 
                case 34: 
                case 35: 
                case 36: 
                case 37: {
                    EvaluationSimplifier.this.replaceFloatPushInstruction(clazz, offset, variableInstruction, variableIndex);
                    break;
                }
                case 24: 
                case 38: 
                case 39: 
                case 40: 
                case 41: {
                    EvaluationSimplifier.this.replaceDoublePushInstruction(clazz, offset, variableInstruction, variableIndex);
                    break;
                }
                case 25: 
                case 42: 
                case 43: 
                case 44: 
                case 45: {
                    EvaluationSimplifier.this.replaceReferencePushInstruction(clazz, offset, variableInstruction);
                }
            }
        }

        public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
            switch (constantInstruction.opcode) {
                case -78: 
                case -76: {
                    EvaluationSimplifier.this.replaceAnyPushInstruction(clazz, offset, constantInstruction);
                    break;
                }
                case -74: 
                case -73: 
                case -72: 
                case -71: {
                    clazz.constantPoolEntryAccept(constantInstruction.constantIndex, new ReferencedMemberVisitor(new MyUnusedParameterSimplifier(offset, constantInstruction)));
                    if (constantInstruction.stackPushCount(clazz) <= 0 || EvaluationSimplifier.this.sideEffectInstructionChecker.hasSideEffects(clazz, method, codeAttribute, offset, constantInstruction)) break;
                    EvaluationSimplifier.this.replaceAnyPushInstruction(clazz, offset, constantInstruction);
                    break;
                }
                case -64: {
                    EvaluationSimplifier.this.replaceReferencePushInstruction(clazz, offset, constantInstruction);
                }
            }
        }

        public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, BranchInstruction branchInstruction) {
            switch (branchInstruction.opcode) {
                case -89: 
                case -56: {
                    break;
                }
                case -88: 
                case -55: {
                    EvaluationSimplifier.this.replaceJsrInstruction(clazz, offset, branchInstruction);
                    break;
                }
                default: {
                    EvaluationSimplifier.this.replaceBranchInstruction(clazz, offset, branchInstruction);
                }
            }
        }

        public void visitAnySwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SwitchInstruction switchInstruction) {
            EvaluationSimplifier.this.replaceBranchInstruction(clazz, offset, switchInstruction);
            if (!EvaluationSimplifier.this.isInstructionSimplified(offset)) {
                EvaluationSimplifier.this.replaceSwitchInstruction(clazz, offset, switchInstruction);
            }
        }
    }
}

