/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.evaluation;

import java.util.Stack;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.ExceptionInfo;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.ExceptionInfoVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionFactory;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.evaluation.BasicBranchUnit;
import proguard.evaluation.BasicInvocationUnit;
import proguard.evaluation.InvocationUnit;
import proguard.evaluation.Processor;
import proguard.evaluation.TracedStack;
import proguard.evaluation.TracedVariables;
import proguard.evaluation.value.InstructionOffsetValue;
import proguard.evaluation.value.ValueFactory;
import proguard.optimize.evaluation.TracedBranchUnit;
import proguard.optimize.peephole.BranchTargetFinder;

public class PartialEvaluator
extends SimplifiedVisitor
implements AttributeVisitor,
ExceptionInfoVisitor {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_RESULTS = false;
    private static final int MAXIMUM_EVALUATION_COUNT = 5;
    public static final int NONE = -2;
    public static final int AT_METHOD_ENTRY = -1;
    public static final int AT_CATCH_ENTRY = -1;
    private final ValueFactory valueFactory;
    private final InvocationUnit invocationUnit;
    private final boolean evaluateAllCode;
    private InstructionOffsetValue[] branchOriginValues = new InstructionOffsetValue[1024];
    private InstructionOffsetValue[] branchTargetValues = new InstructionOffsetValue[1024];
    private TracedVariables[] variablesBefore = new TracedVariables[1024];
    private TracedStack[] stacksBefore = new TracedStack[1024];
    private TracedVariables[] variablesAfter = new TracedVariables[1024];
    private TracedStack[] stacksAfter = new TracedStack[1024];
    private boolean[] generalizedContexts = new boolean[1024];
    private int[] evaluationCounts = new int[1024];
    private int[] initializedVariables = new int[1024];
    private boolean evaluateExceptions;
    private final BasicBranchUnit branchUnit;
    private final BranchTargetFinder branchTargetFinder = new BranchTargetFinder();

    public PartialEvaluator() {
        this(new ValueFactory(), new BasicInvocationUnit(new ValueFactory()), true);
    }

    public PartialEvaluator(ValueFactory valueFactory, InvocationUnit invocationUnit, boolean evaluateAllCode) {
        this.valueFactory = valueFactory;
        this.invocationUnit = invocationUnit;
        this.evaluateAllCode = evaluateAllCode;
        this.branchUnit = evaluateAllCode ? new BasicBranchUnit() : new TracedBranchUnit();
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        try {
            this.visitCodeAttribute0(clazz, method, codeAttribute);
        }
        catch (RuntimeException ex) {
            System.err.println("Unexpected error while performing partial evaluation:");
            System.err.println("  Class       = [" + clazz.getName() + "]");
            System.err.println("  Method      = [" + method.getName(clazz) + method.getDescriptor(clazz) + "]");
            System.err.println("  Exception   = [" + ex.getClass().getName() + "] (" + ex.getMessage() + ")");
            throw ex;
        }
    }

    public void visitCodeAttribute0(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        TracedVariables variables = new TracedVariables(codeAttribute.u2maxLocals);
        TracedStack stack = new TracedStack(codeAttribute.u2maxStack);
        this.initializeVariables(clazz, method, codeAttribute, variables, stack);
        codeAttribute.accept(clazz, method, (AttributeVisitor)this.branchTargetFinder);
        this.evaluateInstructionBlock(clazz, method, codeAttribute, variables, stack, 0);
        do {
            this.evaluateExceptions = false;
            codeAttribute.exceptionsAccept(clazz, method, this);
        } while (this.evaluateExceptions);
    }

    public boolean isTraced(int startOffset, int endOffset) {
        for (int index = startOffset; index < endOffset; ++index) {
            if (!this.isTraced(index)) continue;
            return true;
        }
        return false;
    }

    public boolean isTraced(int instructionOffset) {
        return this.evaluationCounts[instructionOffset] > 0;
    }

    public boolean isBranchOrExceptionTarget(int instructionOffset) {
        return this.branchTargetFinder.isBranchTarget(instructionOffset) || this.branchTargetFinder.isExceptionHandler(instructionOffset);
    }

    public boolean isSubroutineStart(int instructionOffset) {
        return this.branchTargetFinder.isSubroutineStart(instructionOffset);
    }

    public boolean isSubroutine(int instructionOffset) {
        return this.branchTargetFinder.isSubroutine(instructionOffset);
    }

    public boolean isSubroutineReturning(int instructionOffset) {
        return this.branchTargetFinder.isSubroutineReturning(instructionOffset);
    }

    public int subroutineEnd(int instructionOffset) {
        return this.branchTargetFinder.subroutineEnd(instructionOffset);
    }

    public int initializationOffset(int instructionOffset) {
        return this.branchTargetFinder.initializationOffset(instructionOffset);
    }

    public boolean isInitializer() {
        return this.branchTargetFinder.isInitializer();
    }

    public int superInitializationOffset() {
        return this.branchTargetFinder.superInitializationOffset();
    }

    public int creationOffset(int offset) {
        return this.branchTargetFinder.creationOffset(offset);
    }

    public TracedVariables getVariablesBefore(int instructionOffset) {
        return this.variablesBefore[instructionOffset];
    }

    public TracedVariables getVariablesAfter(int instructionOffset) {
        return this.variablesAfter[instructionOffset];
    }

    public TracedStack getStackBefore(int instructionOffset) {
        return this.stacksBefore[instructionOffset];
    }

    public TracedStack getStackAfter(int instructionOffset) {
        return this.stacksAfter[instructionOffset];
    }

    public InstructionOffsetValue branchOrigins(int instructionOffset) {
        return this.branchOriginValues[instructionOffset];
    }

    public InstructionOffsetValue branchTargets(int instructionOffset) {
        return this.branchTargetValues[instructionOffset];
    }

    public int initializedVariable(int instructionOffset) {
        return this.initializedVariables[instructionOffset];
    }

    public void visitExceptionInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, ExceptionInfo exceptionInfo) {
        int startPC = exceptionInfo.u2startPC;
        int endPC = exceptionInfo.u2endPC;
        if (this.isTraced(startPC, endPC)) {
            int handlerPC = exceptionInfo.u2handlerPC;
            int catchType = exceptionInfo.u2catchType;
            TracedVariables variables = new TracedVariables(codeAttribute.u2maxLocals);
            TracedStack stack = new TracedStack(codeAttribute.u2maxStack);
            InstructionOffsetValue storeValue = new InstructionOffsetValue(-1);
            variables.setProducerValue(storeValue);
            stack.setProducerValue(storeValue);
            this.generalizeVariables(startPC, endPC, this.evaluateAllCode, variables);
            String catchClassName = catchType != 0 ? clazz.getClassName(catchType) : "java/lang/Throwable";
            Clazz catchClass = catchType != 0 ? ((ClassConstant)((ProgramClass)clazz).getConstant((int)catchType)).referencedClass : null;
            stack.push(this.valueFactory.createReferenceValue(catchClassName, catchClass, false));
            int evaluationCount = this.evaluationCounts[handlerPC];
            this.evaluateInstructionBlock(clazz, method, codeAttribute, variables, stack, handlerPC);
            if (!this.evaluateExceptions) {
                this.evaluateExceptions = evaluationCount < this.evaluationCounts[handlerPC];
            }
        } else if (this.evaluateAllCode) {
            this.evaluateExceptions = true;
        }
    }

    private void pushInstructionBlock(TracedVariables variables, TracedStack stack, int startOffset, Stack instructionBlocKStack) {
        instructionBlocKStack.push(new MyInstructionBlock(variables, stack, startOffset));
    }

    private void evaluateInstructionBlock(Clazz clazz, Method method, CodeAttribute codeAttribute, TracedVariables variables, TracedStack stack, int startOffset) {
        Stack instructionBlockStack = new Stack();
        this.evaluateInstructionBlock(clazz, method, codeAttribute, variables, stack, startOffset, instructionBlockStack);
        while (!instructionBlockStack.empty()) {
            MyInstructionBlock instructionBlock = (MyInstructionBlock)instructionBlockStack.pop();
            this.evaluateInstructionBlock(clazz, method, codeAttribute, instructionBlock.variables, instructionBlock.stack, instructionBlock.startOffset, instructionBlockStack);
        }
    }

    private void evaluateInstructionBlock(Clazz clazz, Method method, CodeAttribute codeAttribute, TracedVariables variables, TracedStack stack, int startOffset, Stack instructionBlockStack) {
        block19: {
            Instruction instruction;
            byte[] code = codeAttribute.code;
            Processor processor = new Processor(variables, stack, this.valueFactory, this.branchUnit, this.invocationUnit);
            int instructionOffset = startOffset;
            int maxOffset = startOffset;
            do {
                int evaluationCount;
                if (maxOffset < instructionOffset) {
                    maxOffset = instructionOffset;
                }
                if ((evaluationCount = this.evaluationCounts[instructionOffset]) == 0) {
                    if (this.variablesBefore[instructionOffset] == null) {
                        this.variablesBefore[instructionOffset] = new TracedVariables(variables);
                        this.stacksBefore[instructionOffset] = new TracedStack(stack);
                    } else {
                        this.variablesBefore[instructionOffset].initialize(variables);
                        this.stacksBefore[instructionOffset].copy(stack);
                    }
                    this.generalizedContexts[instructionOffset] = true;
                } else {
                    boolean variablesChanged = this.variablesBefore[instructionOffset].generalize(variables, true);
                    boolean stackChanged = this.stacksBefore[instructionOffset].generalize(stack);
                    if (!variablesChanged && !stackChanged && this.generalizedContexts[instructionOffset]) break block19;
                    if (evaluationCount >= 5) {
                        variables.generalize(this.variablesBefore[instructionOffset], false);
                        stack.generalize(this.stacksBefore[instructionOffset]);
                        this.generalizedContexts[instructionOffset] = true;
                    } else {
                        this.generalizedContexts[instructionOffset] = false;
                    }
                }
                int n = instructionOffset;
                this.evaluationCounts[n] = this.evaluationCounts[n] + 1;
                InstructionOffsetValue storeValue = new InstructionOffsetValue(instructionOffset);
                variables.setProducerValue(storeValue);
                stack.setProducerValue(storeValue);
                InstructionOffsetValue traceValue = InstructionOffsetValue.EMPTY_VALUE;
                variables.resetInitialization();
                instruction = InstructionFactory.create(code, instructionOffset);
                int nextInstructionOffset = instructionOffset + instruction.length(instructionOffset);
                InstructionOffsetValue nextInstructionOffsetValue = new InstructionOffsetValue(nextInstructionOffset);
                this.branchUnit.resetCalled();
                this.branchUnit.setTraceBranchTargets(nextInstructionOffsetValue);
                try {
                    instruction.accept(clazz, method, codeAttribute, instructionOffset, processor);
                }
                catch (RuntimeException ex) {
                    System.err.println("Unexpected error while evaluating instruction:");
                    System.err.println("  Class       = [" + clazz.getName() + "]");
                    System.err.println("  Method      = [" + method.getName(clazz) + method.getDescriptor(clazz) + "]");
                    System.err.println("  Instruction = " + instruction.toString(instructionOffset));
                    System.err.println("  Exception   = [" + ex.getClass().getName() + "] (" + ex.getMessage() + ")");
                    throw ex;
                }
                this.initializedVariables[instructionOffset] = variables.getInitializationIndex();
                InstructionOffsetValue branchTargets = this.branchUnit.getTraceBranchTargets();
                int branchTargetCount = branchTargets.instructionOffsetCount();
                this.branchUnit.setTraceBranchTargets(traceValue);
                if (evaluationCount == 0) {
                    if (this.variablesAfter[instructionOffset] == null) {
                        this.variablesAfter[instructionOffset] = new TracedVariables(variables);
                        this.stacksAfter[instructionOffset] = new TracedStack(stack);
                    } else {
                        this.variablesAfter[instructionOffset].initialize(variables);
                        this.stacksAfter[instructionOffset].copy(stack);
                    }
                } else {
                    this.variablesAfter[instructionOffset].generalize(variables, true);
                    this.stacksAfter[instructionOffset].generalize(stack);
                }
                if (this.branchUnit.wasCalled()) {
                    int index;
                    InstructionOffsetValue instructionOffsetValue = this.branchTargetValues[instructionOffset] = this.branchTargetValues[instructionOffset] == null ? branchTargets : this.branchTargetValues[instructionOffset].generalize(branchTargets).instructionOffsetValue();
                    if (branchTargetCount == 0) break block19;
                    InstructionOffsetValue instructionOffsetValue2 = new InstructionOffsetValue(instructionOffset);
                    for (index = 0; index < branchTargetCount; ++index) {
                        int branchTarget = branchTargets.instructionOffset(index);
                        this.branchOriginValues[branchTarget] = this.branchOriginValues[branchTarget] == null ? instructionOffsetValue2 : this.branchOriginValues[branchTarget].generalize(instructionOffsetValue2).instructionOffsetValue();
                    }
                    if (branchTargetCount > 1) {
                        for (index = 0; index < branchTargetCount; ++index) {
                            this.pushInstructionBlock(new TracedVariables(variables), new TracedStack(stack), branchTargets.instructionOffset(index), instructionBlockStack);
                        }
                        break block19;
                    }
                }
                instructionOffset = branchTargets.instructionOffset(0);
            } while (instruction.opcode != -88 && instruction.opcode != -55);
            int subroutineEnd = this.branchTargetFinder.subroutineEnd(instructionOffset);
            for (int offset = instructionOffset; offset < subroutineEnd; ++offset) {
                if (!this.branchTargetFinder.isInstruction(offset)) continue;
                this.evaluationCounts[offset] = 0;
            }
            this.evaluateInstructionBlock(clazz, method, codeAttribute, new TracedVariables(variables), new TracedStack(stack), instructionOffset);
            codeAttribute.exceptionsAccept(clazz, method, instructionOffset, subroutineEnd, this);
        }
    }

    private void initializeVariables(Clazz clazz, Method method, CodeAttribute codeAttribute, TracedVariables variables, TracedStack stack) {
        int index;
        int codeLength = codeAttribute.u4codeLength;
        if (this.variablesAfter.length < codeLength) {
            this.branchOriginValues = new InstructionOffsetValue[codeLength];
            this.branchTargetValues = new InstructionOffsetValue[codeLength];
            this.variablesBefore = new TracedVariables[codeLength];
            this.stacksBefore = new TracedStack[codeLength];
            this.variablesAfter = new TracedVariables[codeLength];
            this.stacksAfter = new TracedStack[codeLength];
            this.generalizedContexts = new boolean[codeLength];
            this.evaluationCounts = new int[codeLength];
            this.initializedVariables = new int[codeLength];
            for (index = 0; index < codeLength; ++index) {
                this.initializedVariables[index] = -2;
            }
        } else {
            for (index = 0; index < codeLength; ++index) {
                this.branchOriginValues[index] = null;
                this.branchTargetValues[index] = null;
                this.generalizedContexts[index] = false;
                this.evaluationCounts[index] = 0;
                this.initializedVariables[index] = -2;
                if (this.variablesBefore[index] != null) {
                    this.variablesBefore[index].reset(codeAttribute.u2maxLocals);
                }
                if (this.stacksBefore[index] != null) {
                    this.stacksBefore[index].reset(codeAttribute.u2maxStack);
                }
                if (this.variablesAfter[index] != null) {
                    this.variablesAfter[index].reset(codeAttribute.u2maxLocals);
                }
                if (this.stacksAfter[index] == null) continue;
                this.stacksAfter[index].reset(codeAttribute.u2maxStack);
            }
        }
        TracedVariables parameters = new TracedVariables(codeAttribute.u2maxLocals);
        InstructionOffsetValue storeValue = new InstructionOffsetValue(-1);
        parameters.setProducerValue(storeValue);
        this.invocationUnit.enterMethod(clazz, method, parameters);
        variables.initialize(parameters);
        InstructionOffsetValue atMethodEntry = new InstructionOffsetValue(-1);
        for (int index2 = 0; index2 < parameters.size(); ++index2) {
            variables.setProducerValue(index2, atMethodEntry);
        }
    }

    private void generalizeVariables(int startOffset, int endOffset, boolean includeAfterLastInstruction, TracedVariables generalizedVariables) {
        boolean first = true;
        int lastIndex = -1;
        for (int index = startOffset; index < endOffset; ++index) {
            if (!this.isTraced(index)) continue;
            TracedVariables tracedVariables = this.variablesBefore[index];
            if (first) {
                generalizedVariables.initialize(tracedVariables);
                first = false;
            } else {
                generalizedVariables.generalize(tracedVariables, false);
            }
            lastIndex = index;
        }
        if (includeAfterLastInstruction && lastIndex >= 0) {
            TracedVariables tracedVariables = this.variablesAfter[lastIndex];
            if (first) {
                generalizedVariables.initialize(tracedVariables);
            } else {
                generalizedVariables.generalize(tracedVariables, false);
            }
        }
        if (first) {
            generalizedVariables.reset(generalizedVariables.size());
        }
    }

    private static class MyInstructionBlock {
        private TracedVariables variables;
        private TracedStack stack;
        private int startOffset;

        private MyInstructionBlock(TracedVariables variables, TracedStack stack, int startOffset) {
            this.variables = variables;
            this.stack = stack;
            this.startOffset = startOffset;
        }
    }
}

