/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.info;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.optimize.info.ClassOptimizationInfo;

public class DotClassMarker
extends SimplifiedVisitor
implements InstructionVisitor,
ConstantVisitor,
ClassVisitor {
    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
    }

    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
        if (constantInstruction.opcode == 18 || constantInstruction.opcode == 19) {
            clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
        }
    }

    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        classConstant.referencedClassAccept(this);
    }

    public void visitLibraryClass(LibraryClass libraryClass) {
    }

    public void visitProgramClass(ProgramClass programClass) {
        DotClassMarker.setDotClassed(programClass);
    }

    public static void setDotClassed(Clazz clazz) {
        ClassOptimizationInfo info = ClassOptimizationInfo.getClassOptimizationInfo(clazz);
        if (info != null) {
            info.setDotClassed();
        }
    }

    public static boolean isDotClassed(Clazz clazz) {
        ClassOptimizationInfo info = ClassOptimizationInfo.getClassOptimizationInfo(clazz);
        return info == null || info.isDotClassed();
    }
}

