/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.info;

import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.util.MethodLinker;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.SpecificValueFactory;
import proguard.evaluation.value.Value;

public class FieldOptimizationInfo {
    private static final SpecificValueFactory VALUE_FACTORY = new SpecificValueFactory();
    private boolean isWritten;
    private boolean isRead;
    private boolean canBeMadePrivate = true;
    private ReferenceValue referencedClass;
    private Value value;

    public FieldOptimizationInfo(Clazz clazz, Field field) {
        this.isRead = (field.getAccessFlags() & 0x40) != 0;
        this.isWritten = this.isRead;
        this.value = this.initialValue(field.getDescriptor(clazz));
    }

    public void setWritten() {
        this.isWritten = true;
    }

    public boolean isWritten() {
        return this.isWritten;
    }

    public void setRead() {
        this.isRead = true;
    }

    public boolean isRead() {
        return this.isRead;
    }

    public void setCanNotBeMadePrivate() {
        this.canBeMadePrivate = false;
    }

    public boolean canBeMadePrivate() {
        return this.canBeMadePrivate;
    }

    public void generalizeReferencedClass(ReferenceValue referencedClass) {
        this.referencedClass = this.referencedClass != null ? this.referencedClass.generalize(referencedClass) : referencedClass;
    }

    public ReferenceValue getReferencedClass() {
        return this.referencedClass;
    }

    public void generalizeValue(Value value) {
        this.value = this.value != null ? this.value.generalize(value) : value;
    }

    public Value getValue() {
        return this.value;
    }

    private Value initialValue(String type) {
        switch (type.charAt(0)) {
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                return VALUE_FACTORY.createIntegerValue(0);
            }
            case 'J': {
                return VALUE_FACTORY.createLongValue(0L);
            }
            case 'F': {
                return VALUE_FACTORY.createFloatValue(0.0f);
            }
            case 'D': {
                return VALUE_FACTORY.createDoubleValue(0.0);
            }
            case 'L': 
            case '[': {
                return VALUE_FACTORY.createReferenceValueNull();
            }
        }
        throw new IllegalArgumentException("Invalid type [" + type + "]");
    }

    public static void setFieldOptimizationInfo(Clazz clazz, Field field) {
        MethodLinker.lastMember(field).setVisitorInfo(new FieldOptimizationInfo(clazz, field));
    }

    public static FieldOptimizationInfo getFieldOptimizationInfo(Field field) {
        Object visitorInfo = MethodLinker.lastMember(field).getVisitorInfo();
        return visitorInfo instanceof FieldOptimizationInfo ? (FieldOptimizationInfo)visitorInfo : null;
    }
}

