/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.peephole;

import java.util.HashSet;
import java.util.Set;
import proguard.classfile.Clazz;
import proguard.classfile.ProgramClass;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.constant.visitor.ExceptClassConstantFilter;
import proguard.classfile.editor.AttributeAdder;
import proguard.classfile.editor.InterfaceAdder;
import proguard.classfile.editor.MemberAdder;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.AllMethodVisitor;
import proguard.classfile.visitor.ClassCollector;
import proguard.classfile.visitor.ClassHierarchyTraveler;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.ImplementedClassConstantFilter;
import proguard.classfile.visitor.ImplementingClassConstantFilter;
import proguard.classfile.visitor.MemberAccessFilter;
import proguard.classfile.visitor.MemberCollector;
import proguard.classfile.visitor.MemberCounter;
import proguard.classfile.visitor.MemberNameFilter;
import proguard.classfile.visitor.MemberToClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.MultiMemberVisitor;
import proguard.classfile.visitor.NamedMethodVisitor;
import proguard.classfile.visitor.ReferencedClassVisitor;
import proguard.classfile.visitor.SimilarMemberVisitor;
import proguard.optimize.KeepMarker;
import proguard.optimize.info.ClassOptimizationInfo;
import proguard.optimize.info.DotClassMarker;
import proguard.optimize.info.InstanceofClassFilter;
import proguard.optimize.info.InstanceofClassMarker;
import proguard.optimize.info.InstantiationClassMarker;
import proguard.optimize.info.PackageVisibleMemberContainingClassMarker;
import proguard.optimize.info.PackageVisibleMemberInvokingClassMarker;
import proguard.util.FixedStringMatcher;
import proguard.util.NotMatcher;

public class ClassMerger
extends SimplifiedVisitor
implements ClassVisitor,
ConstantVisitor {
    private static final boolean DEBUG = false;
    private final ProgramClass targetClass;
    private final boolean allowAccessModification;
    private final boolean mergeInterfacesAggressively;
    private final ClassVisitor extraClassVisitor;

    public ClassMerger(ProgramClass targetClass, boolean allowAccessModification, boolean mergeInterfacesAggressively) {
        this(targetClass, allowAccessModification, mergeInterfacesAggressively, null);
    }

    public ClassMerger(ProgramClass targetClass, boolean allowAccessModification, boolean mergeInterfacesAggressively, ClassVisitor extraClassVisitor) {
        this.targetClass = targetClass;
        this.allowAccessModification = allowAccessModification;
        this.mergeInterfacesAggressively = mergeInterfacesAggressively;
        this.extraClassVisitor = extraClassVisitor;
    }

    public void visitProgramClass(ProgramClass programClass) {
        try {
            this.visitProgramClass0(programClass);
        }
        catch (RuntimeException ex) {
            System.err.println("Unexpected error while merging classes:");
            System.err.println("  Class        = [" + programClass.getName() + "]");
            System.err.println("  Target class = [" + this.targetClass.getName() + "]");
            System.err.println("  Exception    = [" + ex.getClass().getName() + "] (" + ex.getMessage() + ")");
            throw ex;
        }
    }

    public void visitProgramClass0(ProgramClass programClass) {
        if (!(programClass.equals(this.targetClass) || KeepMarker.isKept(programClass) || KeepMarker.isKept(this.targetClass) || ClassMerger.getTargetClass(programClass) != null || ClassMerger.getTargetClass(this.targetClass) != null || (programClass.getAccessFlags() & 0x2000) != 0 || !this.allowAccessModification && ((programClass.getAccessFlags() & this.targetClass.getAccessFlags() & 1) == 0 || PackageVisibleMemberContainingClassMarker.containsPackageVisibleMembers(programClass) || PackageVisibleMemberInvokingClassMarker.invokesPackageVisibleMembers(programClass)) && !ClassUtil.internalPackageName(programClass.getName()).equals(ClassUtil.internalPackageName(this.targetClass.getName())) || (programClass.getAccessFlags() & 0x600) != (this.targetClass.getAccessFlags() & 0x600) && (!this.isOnlySubClass(programClass, this.targetClass) || !programClass.getSuperClass().equals(this.targetClass) && !programClass.getSuperClass().equals(this.targetClass.getSuperClass())) || this.indirectlyImplementedInterfaces(programClass).contains(this.targetClass) || this.targetClass.extendsOrImplements(programClass) || !((Object)this.initializedSuperClasses(programClass)).equals(this.initializedSuperClasses(this.targetClass)) || !((Object)this.instanceofedSuperClasses(programClass)).equals(this.instanceofedSuperClasses(this.targetClass)) || DotClassMarker.isDotClassed(programClass) && DotClassMarker.isDotClassed(this.targetClass) || this.introducesUnwantedFields(programClass, this.targetClass) || this.introducesUnwantedFields(this.targetClass, programClass) || this.haveAnyIdenticalInitializers(programClass, this.targetClass) || !this.mergeInterfacesAggressively && (this.introducesUnwantedAbstractMethods(programClass, this.targetClass) || this.introducesUnwantedAbstractMethods(this.targetClass, programClass)) || this.overridesAnyMethods(programClass, this.targetClass) || this.overridesAnyMethods(this.targetClass, programClass) || this.shadowsAnyMethods(programClass, this.targetClass) || this.shadowsAnyMethods(this.targetClass, programClass))) {
            int targetAccessFlags = this.targetClass.getAccessFlags();
            int sourceAccessFlags = programClass.getAccessFlags();
            this.targetClass.u2accessFlags = targetAccessFlags & sourceAccessFlags & 0x600 | (targetAccessFlags | sourceAccessFlags) & 0x6001;
            programClass.interfaceConstantsAccept(new ExceptClassConstantFilter(this.targetClass.getName(), new ImplementedClassConstantFilter(this.targetClass, new ImplementingClassConstantFilter(this.targetClass, new InterfaceAdder(this.targetClass)))));
            MemberAdder memberAdder = new MemberAdder(this.targetClass);
            programClass.fieldsAccept(memberAdder);
            programClass.methodsAccept(memberAdder);
            programClass.attributesAccept(new AttributeAdder(this.targetClass, true));
            if (InstantiationClassMarker.isInstantiated(programClass)) {
                InstantiationClassMarker.setInstantiated(this.targetClass);
            }
            if (InstanceofClassMarker.isInstanceofed(programClass)) {
                InstanceofClassMarker.setInstanceofed(this.targetClass);
            }
            if (DotClassMarker.isDotClassed(programClass)) {
                DotClassMarker.setDotClassed(this.targetClass);
            }
            ClassMerger.setTargetClass(programClass, this.targetClass);
            if (this.extraClassVisitor != null) {
                this.extraClassVisitor.visitProgramClass(programClass);
            }
        }
    }

    private boolean isOnlySubClass(Clazz subClass, ProgramClass clazz) {
        return clazz.subClasses != null && clazz.subClasses.length == 1 && clazz.subClasses[0].equals(subClass);
    }

    private Set indirectlyImplementedInterfaces(Clazz clazz) {
        HashSet set = new HashSet();
        ReferencedClassVisitor referencedInterfaceCollector = new ReferencedClassVisitor(new ClassHierarchyTraveler(false, false, true, false, new ClassCollector(set)));
        clazz.superClassConstantAccept(referencedInterfaceCollector);
        clazz.interfaceConstantsAccept(referencedInterfaceCollector);
        return set;
    }

    private Set initializedSuperClasses(Clazz clazz) {
        HashSet set = new HashSet();
        clazz.hierarchyAccept(true, true, true, false, new NamedMethodVisitor("<clinit>", "()V", new MemberToClassVisitor(new ClassCollector(set))));
        return set;
    }

    private Set instanceofedSuperClasses(Clazz clazz) {
        HashSet set = new HashSet();
        clazz.hierarchyAccept(true, true, true, false, new InstanceofClassFilter(new ClassCollector(set)));
        return set;
    }

    private boolean introducesUnwantedFields(ProgramClass programClass, ProgramClass targetClass) {
        return programClass.u2fieldsCount != 0 && (InstantiationClassMarker.isInstantiated(targetClass) || targetClass.subClasses != null && !this.isOnlySubClass(programClass, targetClass));
    }

    private boolean haveAnyIdenticalInitializers(Clazz clazz, Clazz targetClass) {
        MemberCounter counter = new MemberCounter();
        clazz.methodsAccept(new SimilarMemberVisitor(targetClass, true, false, false, false, new MemberAccessFilter(0, 1024, counter)));
        return counter.getCount() > 0;
    }

    private boolean introducesUnwantedAbstractMethods(Clazz clazz, ProgramClass targetClass) {
        if ((targetClass.getAccessFlags() & 0x600) != 0 && (targetClass.subClasses == null || this.isOnlySubClass(clazz, targetClass))) {
            return false;
        }
        MemberCounter counter = new MemberCounter();
        HashSet targetSet = new HashSet();
        clazz.methodsAccept(new MemberAccessFilter(1024, 0, new MultiMemberVisitor(new MemberVisitor[]{counter, new SimilarMemberVisitor(targetClass, true, true, true, false, new MemberAccessFilter(1024, 0, new MemberCollector(targetSet)))})));
        return targetSet.size() < counter.getCount();
    }

    private boolean overridesAnyMethods(Clazz clazz, Clazz targetClass) {
        MemberCounter counter = new MemberCounter();
        clazz.methodsAccept(new MemberAccessFilter(0, 1034, new MemberNameFilter(new NotMatcher(new FixedStringMatcher("<clinit>")), (MemberVisitor)new MemberNameFilter(new NotMatcher(new FixedStringMatcher("<init>")), (MemberVisitor)new SimilarMemberVisitor(targetClass, true, true, false, false, new MemberAccessFilter(0, 1034, counter))))));
        return counter.getCount() > 0;
    }

    private boolean shadowsAnyMethods(Clazz clazz, Clazz targetClass) {
        MemberCounter counter = new MemberCounter();
        clazz.hierarchyAccept(true, false, false, true, new AllMethodVisitor(new MemberAccessFilter(2, 0, new MemberNameFilter(new NotMatcher(new FixedStringMatcher("<init>")), (MemberVisitor)new SimilarMemberVisitor(targetClass, true, true, true, false, new MemberAccessFilter(0, 2, counter))))));
        clazz.hierarchyAccept(true, false, false, true, new AllMethodVisitor(new MemberAccessFilter(8, 0, new MemberNameFilter(new NotMatcher(new FixedStringMatcher("<clinit>")), (MemberVisitor)new SimilarMemberVisitor(targetClass, true, true, true, false, new MemberAccessFilter(0, 2, counter))))));
        return counter.getCount() > 0;
    }

    public static void setTargetClass(Clazz clazz, Clazz targetClass) {
        ClassOptimizationInfo info = ClassOptimizationInfo.getClassOptimizationInfo(clazz);
        if (info != null) {
            info.setTargetClass(targetClass);
        }
    }

    public static Clazz getTargetClass(Clazz clazz) {
        Clazz targetClass = null;
        ClassOptimizationInfo info;
        while ((info = ClassOptimizationInfo.getClassOptimizationInfo(clazz)) != null) {
            clazz = info.getTargetClass();
            if (clazz == null) {
                return targetClass;
            }
            targetClass = clazz;
        }
        return targetClass;
    }
}

