/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.peephole;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionFactory;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.optimize.peephole.BranchTargetFinder;

public class LoadStoreRemover
extends SimplifiedVisitor
implements InstructionVisitor {
    private final BranchTargetFinder branchTargetFinder;
    private final CodeAttributeEditor codeAttributeEditor;
    private final InstructionVisitor extraInstructionVisitor;

    public LoadStoreRemover(BranchTargetFinder branchTargetFinder, CodeAttributeEditor codeAttributeEditor) {
        this(branchTargetFinder, codeAttributeEditor, null);
    }

    public LoadStoreRemover(BranchTargetFinder branchTargetFinder, CodeAttributeEditor codeAttributeEditor, InstructionVisitor extraInstructionVisitor) {
        this.branchTargetFinder = branchTargetFinder;
        this.codeAttributeEditor = codeAttributeEditor;
        this.extraInstructionVisitor = extraInstructionVisitor;
    }

    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
    }

    public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, VariableInstruction variableInstruction) {
        if (variableInstruction.isLoad() && variableInstruction.opcode != -87) {
            Instruction nextInstruction;
            int variableIndex = variableInstruction.variableIndex;
            int nextOffset = offset + variableInstruction.length(offset);
            if (!(this.codeAttributeEditor.isModified(offset) || this.codeAttributeEditor.isModified(nextOffset) || this.branchTargetFinder.isTarget(nextOffset) || !((nextInstruction = InstructionFactory.create(codeAttribute.code, nextOffset)) instanceof VariableInstruction) || (variableInstruction = (VariableInstruction)nextInstruction).isLoad() || variableInstruction.opcode == -124 || variableInstruction.variableIndex != variableIndex)) {
                this.codeAttributeEditor.deleteInstruction(offset);
                this.codeAttributeEditor.deleteInstruction(nextOffset);
                if (this.extraInstructionVisitor != null) {
                    this.extraInstructionVisitor.visitVariableInstruction(clazz, method, codeAttribute, offset, variableInstruction);
                }
            }
        }
    }
}

