/*
 * Decompiled with CFR 0.152.
 */
package proguard.shrink;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMember;
import proguard.classfile.VisitorAccepter;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.EnclosingMethodAttribute;
import proguard.classfile.attribute.InnerClassesAttribute;
import proguard.classfile.attribute.SignatureAttribute;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.AnnotationElementValue;
import proguard.classfile.attribute.annotation.AnnotationsAttribute;
import proguard.classfile.attribute.annotation.ArrayElementValue;
import proguard.classfile.attribute.annotation.ElementValue;
import proguard.classfile.attribute.annotation.ParameterAnnotationsAttribute;
import proguard.classfile.attribute.annotation.visitor.AnnotationVisitor;
import proguard.classfile.attribute.annotation.visitor.ElementValueVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.Utf8Constant;
import proguard.classfile.editor.ConstantPoolRemapper;
import proguard.classfile.util.DescriptorClassEnumeration;
import proguard.classfile.util.InternalTypeEnumeration;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.shrink.UsageMarker;

public class ClassShrinker
extends SimplifiedVisitor
implements ClassVisitor,
MemberVisitor,
AttributeVisitor,
AnnotationVisitor,
ElementValueVisitor {
    private final UsageMarker usageMarker;
    private int[] constantIndexMap = new int[256];
    private final ConstantPoolRemapper constantPoolRemapper = new ConstantPoolRemapper();

    public ClassShrinker(UsageMarker usageMarker) {
        this.usageMarker = usageMarker;
    }

    public void visitProgramClass(ProgramClass programClass) {
        programClass.u2interfacesCount = this.shrinkConstantIndexArray(programClass.constantPool, programClass.u2interfaces, programClass.u2interfacesCount);
        programClass.u2constantPoolCount = this.shrinkConstantPool(programClass.constantPool, programClass.u2constantPoolCount);
        programClass.u2fieldsCount = this.shrinkArray(programClass.fields, programClass.u2fieldsCount);
        programClass.u2methodsCount = this.shrinkArray(programClass.methods, programClass.u2methodsCount);
        programClass.u2attributesCount = this.shrinkArray(programClass.attributes, programClass.u2attributesCount);
        programClass.fieldsAccept(this);
        programClass.methodsAccept(this);
        programClass.attributesAccept(this);
        this.constantPoolRemapper.setConstantIndexMap(this.constantIndexMap);
        this.constantPoolRemapper.visitProgramClass(programClass);
        programClass.attributesAccept(new SignatureShrinker());
        programClass.subClasses = this.shrinkToNewArray(programClass.subClasses);
    }

    public void visitLibraryClass(LibraryClass libraryClass) {
        libraryClass.subClasses = this.shrinkToNewArray(libraryClass.subClasses);
    }

    public void visitProgramMember(ProgramClass programClass, ProgramMember programMember) {
        programMember.u2attributesCount = this.shrinkArray(programMember.attributes, programMember.u2attributesCount);
        programMember.attributesAccept(programClass, this);
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitInnerClassesAttribute(Clazz clazz, InnerClassesAttribute innerClassesAttribute) {
        innerClassesAttribute.u2classesCount = this.shrinkArray(innerClassesAttribute.classes, innerClassesAttribute.u2classesCount);
    }

    public void visitEnclosingMethodAttribute(Clazz clazz, EnclosingMethodAttribute enclosingMethodAttribute) {
        if (enclosingMethodAttribute.referencedMethod != null && !this.usageMarker.isUsed(enclosingMethodAttribute.referencedMethod)) {
            enclosingMethodAttribute.u2nameAndTypeIndex = 0;
            enclosingMethodAttribute.referencedMethod = null;
        }
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        codeAttribute.u2attributesCount = this.shrinkArray(codeAttribute.attributes, codeAttribute.u2attributesCount);
    }

    public void visitAnyAnnotationsAttribute(Clazz clazz, AnnotationsAttribute annotationsAttribute) {
        annotationsAttribute.u2annotationsCount = this.shrinkArray(annotationsAttribute.annotations, annotationsAttribute.u2annotationsCount);
        annotationsAttribute.annotationsAccept(clazz, this);
    }

    public void visitAnyParameterAnnotationsAttribute(Clazz clazz, Method method, ParameterAnnotationsAttribute parameterAnnotationsAttribute) {
        for (int parameterIndex = 0; parameterIndex < parameterAnnotationsAttribute.u2parametersCount; ++parameterIndex) {
            parameterAnnotationsAttribute.u2parameterAnnotationsCount[parameterIndex] = this.shrinkArray(parameterAnnotationsAttribute.parameterAnnotations[parameterIndex], parameterAnnotationsAttribute.u2parameterAnnotationsCount[parameterIndex]);
        }
        parameterAnnotationsAttribute.annotationsAccept(clazz, method, this);
    }

    public void visitAnnotation(Clazz clazz, Annotation annotation) {
        annotation.u2elementValuesCount = this.shrinkArray(annotation.elementValues, annotation.u2elementValuesCount);
        annotation.elementValuesAccept(clazz, this);
    }

    public void visitAnyElementValue(Clazz clazz, Annotation annotation, ElementValue elementValue) {
    }

    public void visitAnnotationElementValue(Clazz clazz, Annotation annotation, AnnotationElementValue annotationElementValue) {
        annotationElementValue.annotationAccept(clazz, this);
    }

    public void visitArrayElementValue(Clazz clazz, Annotation annotation, ArrayElementValue arrayElementValue) {
        arrayElementValue.u2elementValuesCount = this.shrinkArray(arrayElementValue.elementValues, arrayElementValue.u2elementValuesCount);
        arrayElementValue.elementValuesAccept(clazz, annotation, this);
    }

    private int shrinkConstantPool(Constant[] constantPool, int length) {
        int index;
        if (this.constantIndexMap.length < length) {
            this.constantIndexMap = new int[length];
        }
        int counter = 1;
        boolean isUsed = false;
        for (index = 1; index < length; ++index) {
            this.constantIndexMap[index] = counter;
            Constant constant = constantPool[index];
            if (constant != null) {
                isUsed = this.usageMarker.isUsed(constant);
            }
            if (!isUsed) continue;
            constantPool[counter++] = constant;
        }
        for (index = counter; index < length; ++index) {
            constantPool[index] = null;
        }
        return counter;
    }

    private int shrinkConstantIndexArray(Constant[] constantPool, int[] array, int length) {
        int index;
        int counter = 0;
        for (index = 0; index < length; ++index) {
            if (!this.usageMarker.isUsed(constantPool[array[index]])) continue;
            array[counter++] = array[index];
        }
        for (index = counter; index < length; ++index) {
            array[index] = 0;
        }
        return counter;
    }

    private Clazz[] shrinkToNewArray(Clazz[] array) {
        if (array == null) {
            return null;
        }
        int length = this.shrinkArray(array, array.length);
        if (length == 0) {
            return null;
        }
        if (length == array.length) {
            return array;
        }
        Clazz[] newArray = new Clazz[length];
        System.arraycopy(array, 0, newArray, 0, length);
        return newArray;
    }

    private int shrinkArray(VisitorAccepter[] array, int length) {
        int index;
        int counter = 0;
        for (index = 0; index < length; ++index) {
            if (!this.usageMarker.isUsed(array[index])) continue;
            array[counter++] = array[index];
        }
        for (index = counter; index < length; ++index) {
            array[index] = null;
        }
        return counter;
    }

    private class SignatureShrinker
    extends SimplifiedVisitor
    implements AttributeVisitor {
        private SignatureShrinker() {
        }

        public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
        }

        public void visitSignatureAttribute(Clazz clazz, SignatureAttribute signatureAttribute) {
            Clazz[] referencedClasses = signatureAttribute.referencedClasses;
            if (referencedClasses != null) {
                String signature = clazz.getString(signatureAttribute.u2signatureIndex);
                InternalTypeEnumeration internalTypeEnumeration = new InternalTypeEnumeration(signature);
                StringBuffer newSignatureBuffer = new StringBuffer();
                int referencedClassIndex = 0;
                int newReferencedClassIndex = 0;
                while (internalTypeEnumeration.hasMoreTypes()) {
                    String type = internalTypeEnumeration.nextType();
                    int classCount = new DescriptorClassEnumeration(type).classCount();
                    Clazz referencedClass = referencedClasses[referencedClassIndex];
                    if (referencedClass == null || ClassShrinker.this.usageMarker.isUsed(referencedClass)) {
                        newSignatureBuffer.append(type);
                        for (int counter = 0; counter < classCount; ++counter) {
                            referencedClasses[newReferencedClassIndex++] = referencedClasses[referencedClassIndex++];
                        }
                        continue;
                    }
                    referencedClassIndex += classCount;
                }
                if (newReferencedClassIndex < referencedClassIndex) {
                    ((Utf8Constant)((ProgramClass)clazz).constantPool[signatureAttribute.u2signatureIndex]).setString(newSignatureBuffer.toString());
                    while (newReferencedClassIndex < referencedClassIndex) {
                        referencedClasses[newReferencedClassIndex++] = null;
                    }
                }
            }
        }
    }
}

