/*
 * Decompiled with CFR 0.152.
 */
package proguard.preverify;

import java.util.ArrayList;
import java.util.List;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.preverification.FullFrame;
import proguard.classfile.attribute.preverification.LessZeroFrame;
import proguard.classfile.attribute.preverification.MoreZeroFrame;
import proguard.classfile.attribute.preverification.SameOneFrame;
import proguard.classfile.attribute.preverification.SameZeroFrame;
import proguard.classfile.attribute.preverification.StackMapAttribute;
import proguard.classfile.attribute.preverification.StackMapFrame;
import proguard.classfile.attribute.preverification.StackMapTableAttribute;
import proguard.classfile.attribute.preverification.VerificationType;
import proguard.classfile.attribute.preverification.VerificationTypeFactory;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.editor.AttributesEditor;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.evaluation.TracedStack;
import proguard.evaluation.TracedVariables;
import proguard.evaluation.value.InstructionOffsetValue;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.Value;
import proguard.optimize.evaluation.LivenessAnalyzer;
import proguard.optimize.evaluation.PartialEvaluator;

public class CodePreverifier
extends SimplifiedVisitor
implements MemberVisitor,
AttributeVisitor {
    private static final boolean DEBUG = false;
    private final boolean microEdition;
    private final PartialEvaluator partialEvaluator = new PartialEvaluator();
    private final LivenessAnalyzer livenessAnalyzer = new LivenessAnalyzer(this.partialEvaluator);

    public CodePreverifier(boolean microEdition) {
        this.microEdition = microEdition;
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        try {
            this.visitCodeAttribute0(clazz, method, codeAttribute);
        }
        catch (RuntimeException ex) {
            System.err.println("Unexpected error while preverifying:");
            System.err.println("  Class       = [" + clazz.getName() + "]");
            System.err.println("  Method      = [" + method.getName(clazz) + method.getDescriptor(clazz) + "]");
            System.err.println("  Exception   = [" + ex.getClass().getName() + "] (" + ex.getMessage() + ")");
            throw ex;
        }
    }

    public void visitCodeAttribute0(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        ProgramClass programClass = (ProgramClass)clazz;
        ProgramMethod programMethod = (ProgramMethod)method;
        this.livenessAnalyzer.visitCodeAttribute(clazz, method, codeAttribute);
        ArrayList<FullFrame> stackMapFrameList = new ArrayList<FullFrame>();
        for (int offset = 0; offset < codeAttribute.u4codeLength; ++offset) {
            if (!this.partialEvaluator.isTraced(offset) || !this.partialEvaluator.isBranchOrExceptionTarget(offset)) continue;
            VerificationType[] variableTypes = this.correspondingVerificationTypes(programClass, programMethod, codeAttribute, offset, this.partialEvaluator.getVariablesBefore(offset));
            VerificationType[] stackTypes = this.correspondingVerificationTypes(programClass, programMethod, codeAttribute, offset, this.partialEvaluator.getStackBefore(offset));
            stackMapFrameList.add(new FullFrame(offset, variableTypes, stackTypes));
        }
        if (!this.microEdition && !stackMapFrameList.isEmpty()) {
            VerificationType[] initialVariables = this.correspondingVerificationTypes(programClass, programMethod, codeAttribute, -1, this.partialEvaluator.getVariablesBefore(0));
            if (method.getName(programClass).equals("<init>")) {
                initialVariables[0] = VerificationTypeFactory.createUninitializedThisType();
            }
            this.compressStackMapFrames(initialVariables, stackMapFrameList);
        }
        String stackMapAttributeName = this.microEdition ? "StackMap" : "StackMapTable";
        int frameCount = stackMapFrameList.size();
        if (frameCount == 0) {
            new AttributesEditor(programClass, programMethod, codeAttribute, true).deleteAttribute(stackMapAttributeName);
        } else {
            Attribute stackMapAttribute;
            if (this.microEdition) {
                FullFrame[] stackMapFrames = new FullFrame[frameCount];
                stackMapFrameList.toArray(stackMapFrames);
                stackMapAttribute = new StackMapAttribute(stackMapFrames);
            } else {
                StackMapFrame[] stackMapFrames = new StackMapFrame[frameCount];
                stackMapFrameList.toArray(stackMapFrames);
                stackMapAttribute = new StackMapTableAttribute(stackMapFrames);
            }
            stackMapAttribute.u2attributeNameIndex = new ConstantPoolEditor(programClass).addUtf8Constant(stackMapAttributeName);
            new AttributesEditor(programClass, programMethod, codeAttribute, true).addAttribute(stackMapAttribute);
        }
    }

    private VerificationType[] correspondingVerificationTypes(ProgramClass programClass, ProgramMethod programMethod, CodeAttribute codeAttribute, int offset, TracedVariables variables) {
        int maximumVariablesSize = variables.size();
        int typeCount = 0;
        int typeIndex = 0;
        for (int index = 0; index < maximumVariablesSize; ++index) {
            Value value = variables.getValue(index);
            ++typeIndex;
            if (value == null || offset != -1 && !this.livenessAnalyzer.isAliveBefore(offset, index)) continue;
            typeCount = typeIndex;
            if (!value.isCategory2()) continue;
            ++index;
        }
        VerificationType[] types = new VerificationType[typeCount];
        typeIndex = 0;
        int index = 0;
        while (typeIndex < typeCount) {
            VerificationType type;
            Value value = variables.getValue(index);
            Value producerValue = variables.getProducerValue(index);
            if (value != null && (offset == -1 || this.livenessAnalyzer.isAliveBefore(offset, index))) {
                type = this.correspondingVerificationType(programClass, programMethod, codeAttribute, offset, index == 0, value, producerValue);
                if (value.isCategory2()) {
                    ++index;
                }
            } else {
                type = VerificationTypeFactory.createTopType();
            }
            types[typeIndex++] = type;
            ++index;
        }
        return types;
    }

    private VerificationType[] correspondingVerificationTypes(ProgramClass programClass, ProgramMethod programMethod, CodeAttribute codeAttribute, int offset, TracedStack stack) {
        int maximumStackSize = stack.size();
        int typeCount = 0;
        for (int index = 0; index < maximumStackSize; ++index) {
            Value value = stack.getTop(index);
            ++typeCount;
            if (!value.isCategory2()) continue;
            ++index;
        }
        VerificationType[] types = new VerificationType[typeCount];
        int typeIndex = typeCount;
        for (int index = 0; index < maximumStackSize; ++index) {
            Value value = stack.getTop(index);
            Value producerValue = stack.getTopProducerValue(index);
            types[--typeIndex] = this.correspondingVerificationType(programClass, programMethod, codeAttribute, offset, false, value, producerValue);
            if (!value.isCategory2()) continue;
            ++index;
        }
        return types;
    }

    private VerificationType correspondingVerificationType(ProgramClass programClass, ProgramMethod programMethod, CodeAttribute codeAttribute, int offset, boolean isVariable0, Value value, Value producerValue) {
        if (value == null) {
            return VerificationTypeFactory.createTopType();
        }
        int type = value.computationalType();
        switch (type) {
            case 1: 
            case 6: {
                return VerificationTypeFactory.createIntegerType();
            }
            case 2: {
                return VerificationTypeFactory.createLongType();
            }
            case 3: {
                return VerificationTypeFactory.createFloatType();
            }
            case 4: {
                return VerificationTypeFactory.createDoubleType();
            }
            case 7: {
                return VerificationTypeFactory.createTopType();
            }
            case 5: {
                InstructionOffsetValue producers;
                ReferenceValue referenceValue = value.referenceValue();
                if (referenceValue.isNull() == 1) {
                    return VerificationTypeFactory.createNullType();
                }
                if (offset != -1 && (producers = producerValue.instructionOffsetValue()).instructionOffsetCount() == 1) {
                    int producerOffset = producers.instructionOffset(0);
                    while (producerOffset != -1 && this.isDupOrSwap(codeAttribute.code[producerOffset])) {
                        producers = this.partialEvaluator.getStackBefore(producerOffset).getTopProducerValue(0).instructionOffsetValue();
                        producerOffset = producers.instructionOffset(0);
                    }
                    if (this.partialEvaluator.isInitializer() && offset <= this.partialEvaluator.superInitializationOffset() && (isVariable0 || producerOffset > -1 && codeAttribute.code[producerOffset] == 42)) {
                        return VerificationTypeFactory.createUninitializedThisType();
                    }
                    if (producerOffset > -1 && offset <= this.partialEvaluator.initializationOffset(producerOffset)) {
                        return VerificationTypeFactory.createUninitializedType(producerOffset);
                    }
                }
                return VerificationTypeFactory.createObjectType(this.createClassConstant(programClass, referenceValue));
            }
        }
        throw new IllegalArgumentException("Unknown computational type [" + type + "]");
    }

    private int createClassConstant(ProgramClass programClass, ReferenceValue referenceValue) {
        return new ConstantPoolEditor(programClass).addClassConstant(referenceValue.getType(), referenceValue.getReferencedClass());
    }

    private void compressStackMapFrames(VerificationType[] initialVariableTypes, List stackMapFrameList) {
        int previousVariablesCount = initialVariableTypes.length;
        VerificationType[] previousVariableTypes = initialVariableTypes;
        int previousOffset = -1;
        for (int index = 0; index < stackMapFrameList.size(); ++index) {
            FullFrame fullFrame = (FullFrame)stackMapFrameList.get(index);
            int variablesCount = fullFrame.variablesCount;
            VerificationType[] variables = fullFrame.variables;
            int stackCount = fullFrame.stackCount;
            VerificationType[] stack = fullFrame.stack;
            StackMapFrame compressedFrame = fullFrame;
            if (variablesCount == previousVariablesCount && this.equalVerificationTypes(variables, previousVariableTypes, variablesCount)) {
                if (stackCount == 0) {
                    compressedFrame = new SameZeroFrame();
                } else if (stackCount == 1) {
                    compressedFrame = new SameOneFrame(stack[0]);
                }
            } else if (stackCount == 0) {
                int additionalVariablesCount = variablesCount - previousVariablesCount;
                if (additionalVariablesCount < 0 && additionalVariablesCount > -4 && this.equalVerificationTypes(variables, previousVariableTypes, variablesCount)) {
                    compressedFrame = new LessZeroFrame((byte)(-additionalVariablesCount));
                } else if (additionalVariablesCount > 0 && additionalVariablesCount < 4 && this.equalVerificationTypes(variables, previousVariableTypes, previousVariablesCount)) {
                    VerificationType[] additionalVariables = new VerificationType[additionalVariablesCount];
                    System.arraycopy(variables, variablesCount - additionalVariablesCount, additionalVariables, 0, additionalVariablesCount);
                    compressedFrame = new MoreZeroFrame(additionalVariables);
                }
            }
            int offset = fullFrame.u2offsetDelta;
            compressedFrame.u2offsetDelta = offset - previousOffset - 1;
            previousOffset = offset;
            previousVariablesCount = fullFrame.variablesCount;
            previousVariableTypes = fullFrame.variables;
            stackMapFrameList.set(index, compressedFrame);
        }
    }

    private boolean equalVerificationTypes(VerificationType[] types1, VerificationType[] types2, int length) {
        if (length > 0 && (types1.length < length || types2.length < length)) {
            return false;
        }
        for (int index = 0; index < length; ++index) {
            if (types1[index].equals(types2[index])) continue;
            return false;
        }
        return true;
    }

    private boolean isDupOrSwap(int opcode) {
        return opcode >= 89 && opcode <= 95;
    }
}

