/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.util.List;
import proguard.ClassPath;
import proguard.ClassPathEntry;
import proguard.io.CascadingDataEntryWriter;
import proguard.io.DataEntryNameFilter;
import proguard.io.DataEntryParentFilter;
import proguard.io.DataEntryWriter;
import proguard.io.DirectoryWriter;
import proguard.io.FilteredDataEntryWriter;
import proguard.io.JarWriter;
import proguard.io.ParentDataEntryWriter;
import proguard.util.ExtensionMatcher;
import proguard.util.FileNameParser;
import proguard.util.ListParser;

public class DataEntryWriterFactory {
    public static DataEntryWriter createDataEntryWriter(ClassPath classPath, int fromIndex, int toIndex) {
        DataEntryWriter writer = null;
        for (int index = toIndex - 1; index >= fromIndex; --index) {
            ClassPathEntry entry = classPath.get(index);
            writer = DataEntryWriterFactory.createClassPathEntryWriter(entry, writer);
        }
        return writer;
    }

    private static DataEntryWriter createClassPathEntryWriter(ClassPathEntry classPathEntry, DataEntryWriter alternativeWriter) {
        String entryName = classPathEntry.getName();
        boolean isJar = DataEntryWriterFactory.endsWithIgnoreCase(entryName, ".jar");
        boolean isWar = DataEntryWriterFactory.endsWithIgnoreCase(entryName, ".war");
        boolean isEar = DataEntryWriterFactory.endsWithIgnoreCase(entryName, ".ear");
        boolean isZip = DataEntryWriterFactory.endsWithIgnoreCase(entryName, ".zip");
        List filter = classPathEntry.getFilter();
        List jarFilter = classPathEntry.getJarFilter();
        List warFilter = classPathEntry.getWarFilter();
        List earFilter = classPathEntry.getEarFilter();
        List zipFilter = classPathEntry.getZipFilter();
        System.out.println("Preparing output " + (isJar ? "jar" : (isWar ? "war" : (isEar ? "ear" : (isZip ? "zip" : "directory")))) + " [" + entryName + "]" + (filter != null || jarFilter != null || warFilter != null || earFilter != null || zipFilter != null ? " (filtered)" : ""));
        DataEntryWriter writer = new DirectoryWriter(classPathEntry.getFile(), isJar || isWar || isEar || isZip);
        writer = DataEntryWriterFactory.wrapInJarWriter(writer, isZip, zipFilter, ".zip", isJar || isWar || isEar);
        writer = DataEntryWriterFactory.wrapInJarWriter(writer, isEar, earFilter, ".ear", isJar || isWar);
        writer = DataEntryWriterFactory.wrapInJarWriter(writer, isWar, warFilter, ".war", isJar);
        writer = DataEntryWriterFactory.wrapInJarWriter(writer, isJar, jarFilter, ".jar", false);
        writer = filter != null ? new FilteredDataEntryWriter(new DataEntryNameFilter(new ListParser(new FileNameParser()).parse(filter)), writer) : writer;
        return alternativeWriter != null ? new CascadingDataEntryWriter(writer, alternativeWriter) : writer;
    }

    private static DataEntryWriter wrapInJarWriter(DataEntryWriter writer, boolean isJar, List jarFilter, String jarExtension, boolean dontWrap) {
        DataEntryWriter jarWriter = dontWrap ? new ParentDataEntryWriter(writer) : new JarWriter(writer);
        DataEntryWriter filteredJarWriter = jarFilter != null ? new FilteredDataEntryWriter(new DataEntryParentFilter(new DataEntryNameFilter(new ListParser(new FileNameParser()).parse(jarFilter))), jarWriter) : jarWriter;
        return new FilteredDataEntryWriter(new DataEntryParentFilter(new DataEntryNameFilter(new ExtensionMatcher(jarExtension))), filteredJarWriter, isJar ? jarWriter : writer);
    }

    private static boolean endsWithIgnoreCase(String string, String suffix) {
        int stringLength = string.length();
        int suffixLength = suffix.length();
        return string.regionMatches(true, stringLength - suffixLength, suffix, 0, suffixLength);
    }
}

